/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaGotoSuperHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/JavaGotoSuperHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/navigation/JavaGotoSuperHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/navigation/JavaGotoSuperHandler.invoke must not be null");
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement[] superElements = JavaGotoSuperHandler.findSuperElements(file, offset);
        if (superElements == null || superElements.length == 0) {
            return;
        }
        if (superElements.length == 1) {
            PsiElement superElement = superElements[0].getNavigationElement();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, superElement.getContainingFile().getVirtualFile(), superElement.getTextOffset());
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        } else {
            String title = superElements[0] instanceof PsiMethod ? CodeInsightBundle.message((String)"goto.super.method.chooser.title", (Object[])new Object[0]) : CodeInsightBundle.message((String)"goto.super.class.chooser.title", (Object[])new Object[0]);
            NavigationUtil.getPsiElementPopup(superElements, title).showInBestPositionFor(editor);
        }
    }

    @Nullable
    private static PsiElement[] findSuperElements(PsiFile file, int offset) {
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiMember e = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        if (e instanceof PsiClass) {
            PsiClass aClass = (PsiClass)e;
            ArrayList<PsiClass> allSupers = new ArrayList<PsiClass>(Arrays.asList(aClass.getSupers()));
            Iterator iterator = allSupers.iterator();
            while (iterator.hasNext()) {
                PsiClass superClass = (PsiClass)iterator.next();
                if (!"java.lang.Object".equals(superClass.getQualifiedName())) continue;
                iterator.remove();
            }
            return (PsiElement[])allSupers.toArray(new PsiClass[allSupers.size()]);
        }
        if (e instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)e;
            if (method.isConstructor()) {
                PsiMethod constructorInSuper = PsiSuperMethodUtil.findConstructorInSuper((PsiMethod)method);
                if (constructorInSuper != null) {
                    return new PsiElement[]{constructorInSuper};
                }
            } else {
                return method.findSuperMethods(false);
            }
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

