/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JList;

public class ImplementAbstractMethodHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.ImplementAbstractMethodHandler");
    private final Project myProject;
    private final Editor myEditor;
    private final PsiMethod myMethod;
    private JList myList;

    public ImplementAbstractMethodHandler(Project project, Editor editor, PsiMethod method) {
        this.myProject = project;
        this.myEditor = editor;
        this.myMethod = method;
    }

    public void invoke() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        final PsiClass[][] result = new PsiClass[1][];
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                PsiClass psiClass = ImplementAbstractMethodHandler.this.myMethod.getContainingClass();
                if (!psiClass.isValid()) {
                    return;
                }
                result[0] = ImplementAbstractMethodHandler.this.getClassImplementations(psiClass);
            }
        }, CodeInsightBundle.message((String)"intention.implement.abstract.method.searching.for.descendants.progress", (Object[])new Object[0]), true, this.myProject);
        if (result[0] == null) {
            return;
        }
        if (result[0].length == 0) {
            Messages.showMessageDialog((Project)this.myProject, (String)CodeInsightBundle.message((String)"intention.implement.abstract.method.error.no.classes.message", (Object[])new Object[0]), (String)CodeInsightBundle.message((String)"intention.implement.abstract.method.error.no.classes.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            return;
        }
        if (result[0].length == 1) {
            this.implementInClass(result[0][0]);
            return;
        }
        PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
        Arrays.sort(result[0], renderer.getComparator());
        this.myList = new JList<PsiClass>(result[0]);
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer(renderer);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int index = ImplementAbstractMethodHandler.this.myList.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                PsiElement element = (PsiElement)ImplementAbstractMethodHandler.this.myList.getSelectedValue();
                ImplementAbstractMethodHandler.this.implementInClass((PsiClass)element);
            }
        };
        PopupChooserBuilder builder = new PopupChooserBuilder(this.myList);
        renderer.installSpeedSearch(builder);
        builder.setTitle(CodeInsightBundle.message((String)"intention.implement.abstract.method.class.chooser.title", (Object[])new Object[0])).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(this.myEditor);
    }

    private void implementInClass(final PsiClass psiClass) {
        if (!psiClass.isValid()) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiClass.getContainingFile()), this.myProject)) {
            MessagesEx.fileIsReadOnly(this.myProject, psiClass.getContainingFile().getVirtualFile()).showNow();
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CodeInsightUtilBase.prepareFileForWrite(psiClass.getContainingFile());
                            OverrideImplementUtil.overrideOrImplement(psiClass, ImplementAbstractMethodHandler.this.myMethod);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, CodeInsightBundle.message((String)"intention.implement.abstract.method.command.name", (Object[])new Object[0]), null);
    }

    private PsiClass[] getClassImplementations(PsiClass psiClass) {
        ArrayList<PsiClass> list = new ArrayList<PsiClass>();
        for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)psiClass.getUseScope(), (boolean)true)) {
            PsiMethod method;
            if (inheritor.isInterface() || (method = inheritor.findMethodBySignature(this.myMethod, true)) == null || !method.getContainingClass().equals(psiClass)) continue;
            list.add(inheritor);
        }
        return list.toArray(new PsiClass[list.size()]);
    }
}

