/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSubclassAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.ImplementAbstractClassAction");
    private String myText = CodeInsightBundle.message((String)"intention.implement.abstract.class.default.text", (Object[])new Object[0]);
    @NonNls
    private static final String IMPL_SUFFIX = "Impl";

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/CreateSubclassAction.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.implement.abstract.class.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/CreateSubclassAction.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
        PsiJavaToken lBrace;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/CreateSubclassAction.isAvailable must not be null");
        }
        if (element == null) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass == null || psiClass.isAnnotationType() || psiClass.isEnum() || psiClass instanceof PsiAnonymousClass || psiClass.hasModifierProperty("final")) {
            return false;
        }
        PsiMethod[] constructors = psiClass.getConstructors();
        if (constructors.length > 0) {
            boolean hasNonPrivateConstructor = false;
            for (PsiMethod constructor : constructors) {
                if (constructor.hasModifierProperty("private")) continue;
                hasNonPrivateConstructor = true;
                break;
            }
            if (!hasNonPrivateConstructor) {
                return false;
            }
        }
        if ((lBrace = psiClass.getLBrace()) == null) {
            return false;
        }
        if (element.getTextOffset() >= lBrace.getTextOffset()) {
            return false;
        }
        TextRange declarationRange = HighlightNamesUtil.getClassDeclarationTextRange(psiClass);
        if (!declarationRange.contains(element.getTextRange())) {
            return false;
        }
        this.myText = CreateSubclassAction.getTitle(psiClass);
        return true;
    }

    private static String getTitle(PsiClass psiClass) {
        return psiClass.isInterface() ? CodeInsightBundle.message((String)"intention.implement.abstract.class.interface.text", (Object[])new Object[0]) : (psiClass.hasModifierProperty("abstract") ? CodeInsightBundle.message((String)"intention.implement.abstract.class.default.text", (Object[])new Object[0]) : CodeInsightBundle.message((String)"intention.implement.abstract.class.subclass.text", (Object[])new Object[0]));
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/CreateSubclassAction.invoke must not be null");
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        CreateClassDialog dlg = CreateSubclassAction.chooseSubclassToCreate(psiClass);
        if (dlg != null) {
            CreateSubclassAction.createSubclass(psiClass, dlg.getTargetDirectory(), dlg.getClassName());
        }
    }

    @Nullable
    public static CreateClassDialog chooseSubclassToCreate(PsiClass psiClass) {
        PsiDirectory sourceDir = psiClass.getContainingFile().getContainingDirectory();
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(sourceDir);
        CreateClassDialog dialog = new CreateClassDialog(psiClass.getProject(), CreateSubclassAction.getTitle(psiClass), psiClass.getName() + IMPL_SUFFIX, aPackage != null ? aPackage.getQualifiedName() : "", CreateClassKind.CLASS, true, ModuleUtil.findModuleForPsiElement((PsiElement)psiClass));
        dialog.show();
        if (!dialog.isOK()) {
            return null;
        }
        PsiDirectory targetDirectory = dialog.getTargetDirectory();
        if (targetDirectory == null) {
            return null;
        }
        return dialog;
    }

    public static PsiClass createSubclass(final PsiClass psiClass, final PsiDirectory targetDirectory, final String className) {
        final Project project = psiClass.getProject();
        final PsiClass[] targetClass = new PsiClass[1];
        PostprocessReformattingAspect.getInstance(project).postponeFormattingInside(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        IdeDocumentHistory.getInstance(project).includeCurrentPlaceAsChangePlace();
                        PsiTypeParameterList oldTypeParameterList = psiClass.getTypeParameterList();
                        try {
                            targetClass[0] = JavaDirectoryService.getInstance().createClass(targetDirectory, className);
                            if (psiClass.hasTypeParameters()) {
                                PsiTypeParameterList typeParameterList = targetClass[0].getTypeParameterList();
                                assert (typeParameterList != null);
                                typeParameterList.replace((PsiElement)oldTypeParameterList);
                            }
                        }
                        catch (IncorrectOperationException e) {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Messages.showErrorDialog((Project)project, (String)(CodeInsightBundle.message((String)"intention.error.cannot.create.class.message", (Object[])new Object[]{className}) + "\n" + e.getLocalizedMessage()), (String)CodeInsightBundle.message((String)"intention.error.cannot.create.class.title", (Object[])new Object[0]));
                                }
                            });
                            return;
                        }
                        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                        PsiJavaCodeReferenceElement ref = elementFactory.createClassReferenceElement(psiClass);
                        try {
                            ref = psiClass.isInterface() ? (PsiJavaCodeReferenceElement)targetClass[0].getImplementsList().add((PsiElement)ref) : (PsiJavaCodeReferenceElement)targetClass[0].getExtendsList().add((PsiElement)ref);
                            if (oldTypeParameterList != null) {
                                for (PsiTypeParameter parameter : oldTypeParameterList.getTypeParameters()) {
                                    ref.getParameterList().add((PsiElement)elementFactory.createTypeElement((PsiType)elementFactory.createType((PsiClass)parameter)));
                                }
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
                if (targetClass[0] == null) {
                    return;
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    Editor editor1 = CodeInsightUtil.positionCursor(project, targetClass[0].getContainingFile(), (PsiElement)targetClass[0].getLBrace());
                    if (editor1 == null) {
                        return;
                    }
                    OverrideImplementUtil.chooseAndImplementMethods(project, editor1, targetClass[0]);
                }
            }
        });
        return targetClass[0];
    }

    public boolean startInWriteAction() {
        return false;
    }
}

