/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.ElementLocationUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ImplementationTextSelectioner;
import com.intellij.codeInsight.hint.LanguageImplementationTextSelectioner;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EdgeBorder;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NonNls;

public class ImplementationViewComponent
extends JPanel {
    private final PsiElement[] myElements;
    private int myIndex;
    private final Editor myEditor;
    private final JPanel myViewingPanel;
    private final JLabel myLocationLabel;
    private final JLabel myCountLabel;
    private final CardLayout myBinarySwitch;
    private final JPanel myBinaryPanel;
    private JComboBox myFileChooser;
    private FileEditor myNonTextEditor;
    private FileEditorProvider myCurrentNonTextEditorProvider;
    private JBPopup myHint;
    private String myTitle;
    @NonNls
    private static final String TEXT_PAGE_KEY = "Text";
    @NonNls
    private static final String BINARY_PAGE_KEY = "Binary";
    private final ActionToolbar myToolbar;
    private static final Icon FIND_ICON = IconLoader.getIcon((String)"/actions/find.png");

    public void setHint(JBPopup hint, String title) {
        this.myHint = hint;
        this.myTitle = title;
    }

    public boolean hasElementsToShow() {
        return this.myElements.length > 0;
    }

    public ImplementationViewComponent(PsiElement[] elements, int index) {
        super(new BorderLayout());
        EditorHighlighter highlighter;
        ArrayList<PsiElement> candidates = new ArrayList<PsiElement>(elements.length);
        ArrayList<FileDescriptor> files = new ArrayList<FileDescriptor>(elements.length);
        for (PsiElement element : elements) {
            PsiFile file = ImplementationViewComponent.getContainingFile(element);
            if (file == null) continue;
            files.add(new FileDescriptor(file.getVirtualFile()));
            candidates.add(element.getNavigationElement());
        }
        this.myElements = candidates.toArray(new PsiElement[candidates.size()]);
        if (this.myElements.length == 0) {
            this.myToolbar = null;
            this.myEditor = null;
            this.myViewingPanel = null;
            this.myLocationLabel = null;
            this.myCountLabel = null;
            this.myBinarySwitch = null;
            this.myBinaryPanel = null;
            return;
        }
        this.myIndex = index < this.myElements.length ? index : 0;
        final Project project = elements[this.myIndex].getProject();
        EditorFactory factory = EditorFactory.getInstance();
        Document doc = factory.createDocument((CharSequence)"");
        doc.setReadOnly(true);
        this.myEditor = factory.createEditor(doc, project);
        PsiFile psiFile = ImplementationViewComponent.getContainingFile(this.myElements[this.myIndex]);
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null) {
            highlighter = HighlighterFactory.createHighlighter((Project)project, (VirtualFile)virtualFile);
        } else {
            String fileName = psiFile.getName();
            highlighter = HighlighterFactory.createHighlighter((Project)project, (String)fileName);
        }
        ((EditorEx)this.myEditor).setHighlighter(highlighter);
        ((EditorEx)this.myEditor).setBackgroundColor(EditorFragmentComponent.getBackgroundColor(this.myEditor));
        this.myEditor.getSettings().setAdditionalLinesCount(1);
        this.myEditor.getSettings().setAdditionalColumnsCount(1);
        this.myEditor.getSettings().setLineMarkerAreaShown(false);
        this.myEditor.getSettings().setIndentGuidesShown(false);
        this.myEditor.getSettings().setLineNumbersShown(false);
        this.myEditor.getSettings().setFoldingOutlineShown(false);
        this.myBinarySwitch = new CardLayout();
        this.myViewingPanel = new JPanel(this.myBinarySwitch);
        EdgeBorder lineBorder = new EdgeBorder(15);
        Border emptyBorder = BorderFactory.createEmptyBorder(0, 2, 2, 2);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(emptyBorder, (Border)lineBorder);
        this.myViewingPanel.setBorder(compoundBorder);
        this.myViewingPanel.add((Component)this.myEditor.getComponent(), TEXT_PAGE_KEY);
        this.myBinaryPanel = new JPanel(new BorderLayout());
        this.myViewingPanel.add((Component)this.myBinaryPanel, BINARY_PAGE_KEY);
        this.add((Component)this.myViewingPanel, "Center");
        this.myToolbar = this.createToolbar();
        this.myLocationLabel = new JLabel();
        this.myCountLabel = new JLabel();
        JPanel header = new JPanel(new BorderLayout());
        header.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel toolbarPanel = new JPanel(new FlowLayout());
        toolbarPanel.add(this.myToolbar.getComponent());
        if (this.myElements.length > 1) {
            this.myFileChooser = new JComboBox<FileDescriptor>(files.toArray(new FileDescriptor[files.size()]));
            this.myFileChooser.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
                    VirtualFile file = ((FileDescriptor)value).myFile;
                    this.setIcon(file.getIcon());
                    this.setForeground(FileStatusManager.getInstance((Project)project).getStatus(file).getColor());
                    this.setText(file.getPresentableName());
                    return this;
                }
            });
            this.myFileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = ImplementationViewComponent.this.myFileChooser.getSelectedIndex();
                    if (ImplementationViewComponent.this.myIndex != index) {
                        ImplementationViewComponent.this.myIndex = index;
                        ImplementationViewComponent.this.updateControls();
                    }
                }
            });
            toolbarPanel.add(this.myFileChooser);
            toolbarPanel.add(this.myCountLabel);
        } else {
            JLabel label = new JLabel();
            VirtualFile file = psiFile.getVirtualFile();
            if (file != null) {
                label.setIcon(file.getIcon());
                label.setForeground(FileStatusManager.getInstance((Project)project).getStatus(file).getColor());
                label.setText(file.getPresentableName());
                label.setBorder(new CompoundBorder(IdeBorderFactory.createBorder(), IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)5)));
            }
            toolbarPanel.add(label);
        }
        header.add((Component)toolbarPanel, "West");
        header.add((Component)this.myLocationLabel, "East");
        this.add((Component)header, "North");
        this.setPreferredSize(new Dimension(600, 400));
        this.updateControls();
    }

    public JComponent getPrefferedFocusableComponent() {
        return this.myFileChooser != null ? this.myFileChooser : this.myViewingPanel;
    }

    private void updateControls() {
        this.updateLabels();
        this.updateCombo();
        this.updateEditorText();
        this.myToolbar.updateActionsImmediately();
    }

    private void updateCombo() {
        if (this.myFileChooser != null) {
            this.myFileChooser.setSelectedIndex(this.myIndex);
        }
    }

    private void updateEditorText() {
        FileEditorProvider[] providers;
        this.disposeNonTextEditor();
        PsiElement elt = this.myElements[this.myIndex];
        Project project = elt.getProject();
        PsiFile psiFile = ImplementationViewComponent.getContainingFile(elt);
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null) {
            return;
        }
        for (FileEditorProvider provider : providers = FileEditorProviderManager.getInstance().getProviders(project, vFile)) {
            if (provider instanceof TextEditorProvider) {
                this.updateTextElement(elt);
                this.myBinarySwitch.show(this.myViewingPanel, TEXT_PAGE_KEY);
                break;
            }
            if (!provider.accept(project, vFile)) continue;
            this.myCurrentNonTextEditorProvider = provider;
            this.myNonTextEditor = this.myCurrentNonTextEditorProvider.createEditor(project, vFile);
            this.myBinaryPanel.removeAll();
            this.myBinaryPanel.add(this.myNonTextEditor.getComponent());
            this.myBinarySwitch.show(this.myViewingPanel, BINARY_PAGE_KEY);
            break;
        }
    }

    private void disposeNonTextEditor() {
        if (this.myNonTextEditor != null) {
            this.myCurrentNonTextEditorProvider.disposeEditor(this.myNonTextEditor);
            this.myNonTextEditor = null;
            this.myCurrentNonTextEditorProvider = null;
        }
    }

    private void updateTextElement(PsiElement elt) {
        Project project = elt.getProject();
        PsiFile psiFile = ImplementationViewComponent.getContainingFile(elt);
        final Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (doc == null) {
            return;
        }
        ImplementationTextSelectioner implementationTextSelectioner = (ImplementationTextSelectioner)LanguageImplementationTextSelectioner.INSTANCE.forLanguage(elt.getLanguage());
        int start = implementationTextSelectioner.getTextStartOffset(elt);
        int end = implementationTextSelectioner.getTextEndOffset(elt);
        final int lineStart = doc.getLineStartOffset(doc.getLineNumber(start));
        final int lineEnd = end < doc.getTextLength() ? doc.getLineEndOffset(doc.getLineNumber(end)) : end;
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        Document fragmentDoc = ImplementationViewComponent.this.myEditor.getDocument();
                        fragmentDoc.setReadOnly(false);
                        fragmentDoc.replaceString(0, fragmentDoc.getTextLength(), (CharSequence)((Object)doc.getCharsSequence().subSequence(lineStart, lineEnd)).toString());
                        fragmentDoc.setReadOnly(true);
                        ImplementationViewComponent.this.myEditor.getCaretModel().moveToOffset(0);
                        ImplementationViewComponent.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    }
                });
            }
        });
    }

    private static PsiFile getContainingFile(PsiElement elt) {
        PsiFile psiFile = elt.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        return psiFile.getOriginalFile();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditorFactory.getInstance().releaseEditor(this.myEditor);
        this.disposeNonTextEditor();
    }

    private void updateLabels() {
        ElementLocationUtil.customizeElementLabel(this.myElements[this.myIndex], this.myLocationLabel);
        this.myCountLabel.setText(CodeInsightBundle.message((String)"n.of.m", (Object[])new Object[]{this.myIndex + 1, this.myElements.length}));
    }

    private ActionToolbar createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        BackAction back = new BackAction();
        back.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(37, 0)), this);
        group.add((AnAction)back);
        ForwardAction forward = new ForwardAction();
        forward.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(39, 0)), this);
        group.add((AnAction)forward);
        EditSourceActionBase edit = new EditSourceAction();
        edit.registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{CommonShortcuts.getEditSource(), CommonShortcuts.ENTER}), this);
        group.add((AnAction)edit);
        edit = new ShowSourceAction();
        edit.registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{CommonShortcuts.getViewSource(), CommonShortcuts.CTRL_ENTER}), this);
        group.add((AnAction)edit);
        ShowFindUsagesAction findUsagesAction = new ShowFindUsagesAction();
        findUsagesAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("FindUsages")), this);
        group.add((AnAction)findUsagesAction);
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
    }

    private void goBack() {
        --this.myIndex;
        this.updateControls();
    }

    private void goForward() {
        ++this.myIndex;
        this.updateControls();
    }

    private PsiElement[] collectNonBinaryElements() {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement element : this.myElements) {
            if (element instanceof PsiBinaryFile) continue;
            result.add(element);
        }
        return result.toArray(new PsiElement[result.size()]);
    }

    private class ShowFindUsagesAction
    extends AnAction {
        private static final String ACTION_NAME = "Show in usage view";

        public ShowFindUsagesAction() {
            super(ACTION_NAME, ACTION_NAME, FIND_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            UsageViewPresentation presentation = new UsageViewPresentation();
            presentation.setCodeUsagesString(ImplementationViewComponent.this.myTitle);
            presentation.setTabName(ImplementationViewComponent.this.myTitle);
            presentation.setTabText(ImplementationViewComponent.this.myTitle);
            PsiElement[] elements = ImplementationViewComponent.this.collectNonBinaryElements();
            UsageInfo[] usages = new UsageInfo[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                usages[i] = new UsageInfo(elements[i]);
            }
            UsageViewManager.getInstance((Project)ImplementationViewComponent.this.myEditor.getProject()).showUsages(UsageTarget.EMPTY_ARRAY, UsageInfoToUsageConverter.convert((UsageInfoToUsageConverter.TargetElementsDescriptor)new UsageInfoToUsageConverter.TargetElementsDescriptor(elements), (UsageInfo[])usages), presentation);
            if (ImplementationViewComponent.this.myHint.isVisible()) {
                ImplementationViewComponent.this.myHint.cancel();
            }
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(ImplementationViewComponent.this.collectNonBinaryElements().length > 0);
        }
    }

    private class EditSourceActionBase
    extends AnAction {
        private final boolean myFocusEditor;

        public EditSourceActionBase(boolean focusEditor, Icon icon, String text) {
            super(text, null, icon);
            this.myFocusEditor = focusEditor;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ImplementationViewComponent.this.myFileChooser == null || !ImplementationViewComponent.this.myFileChooser.isPopupVisible());
        }

        public void actionPerformed(AnActionEvent e) {
            PsiElement element = ImplementationViewComponent.this.myElements[ImplementationViewComponent.this.myIndex];
            PsiElement navigationElement = element.getNavigationElement();
            PsiFile file = ImplementationViewComponent.getContainingFile(navigationElement);
            if (file == null) {
                return;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            Project project = element.getProject();
            FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project);
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, navigationElement.getTextOffset());
            fileEditorManager.openTextEditor(descriptor, this.myFocusEditor);
        }
    }

    private class ShowSourceAction
    extends EditSourceActionBase
    implements HintManagerImpl.ActionToIgnore {
        public ShowSourceAction() {
            super(false, IconLoader.getIcon((String)"/actions/showSource.png"), CodeInsightBundle.message((String)"quick.definition.show.source", (Object[])new Object[0]));
        }
    }

    private class EditSourceAction
    extends EditSourceActionBase {
        public EditSourceAction() {
            super(true, IconLoader.getIcon((String)"/actions/editSource.png"), CodeInsightBundle.message((String)"quick.definition.edit.source", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            super.actionPerformed(e);
            if (ImplementationViewComponent.this.myHint.isVisible()) {
                ImplementationViewComponent.this.myHint.cancel();
            }
        }
    }

    private class ForwardAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public ForwardAction() {
            super(CodeInsightBundle.message((String)"quick.definition.forward", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/forward.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            ImplementationViewComponent.this.goForward();
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(ImplementationViewComponent.this.myIndex < ImplementationViewComponent.this.myElements.length - 1);
        }
    }

    private class BackAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public BackAction() {
            super(CodeInsightBundle.message((String)"quick.definition.back", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/back.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            ImplementationViewComponent.this.goBack();
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(ImplementationViewComponent.this.myIndex > 0);
        }
    }

    private static class FileDescriptor {
        public final VirtualFile myFile;

        public FileDescriptor(VirtualFile file) {
            this.myFile = file;
        }
    }
}

