/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;

public class SurroundWithUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil");

    static PsiElement[] moveDeclarationsOut(PsiElement block, PsiElement[] statements, boolean generateInitializers) {
        try {
            PsiManager psiManager = block.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            ArrayList<Object> array = new ArrayList<Object>();
            for (PsiElement statement : statements) {
                PsiDeclarationStatement declaration;
                if (statement instanceof PsiDeclarationStatement && SurroundWithUtil.needToDeclareOut(block, statements, declaration = (PsiDeclarationStatement)statement)) {
                    PsiDeclarationStatement newDeclaration;
                    PsiAssignmentExpression expr;
                    PsiElement[] elements;
                    for (PsiElement element : elements = declaration.getDeclaredElements()) {
                        PsiVariable var = (PsiVariable)element;
                        PsiExpression initializer = var.getInitializer();
                        if (initializer == null) continue;
                        String name = var.getName();
                        PsiExpressionStatement assignment = (PsiExpressionStatement)factory.createStatementFromText(name + "=x;", null);
                        assignment = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)assignment);
                        expr = (PsiAssignmentExpression)assignment.getExpression();
                        expr.getRExpression().replace((PsiElement)initializer);
                        assignment = (PsiExpressionStatement)block.addAfter((PsiElement)assignment, (PsiElement)declaration);
                        array.add(assignment);
                    }
                    if (!array.isEmpty()) {
                        PsiElement firstStatement = (PsiElement)array.get(0);
                        newDeclaration = (PsiDeclarationStatement)block.addBefore((PsiElement)declaration, firstStatement);
                        declaration.delete();
                    } else {
                        newDeclaration = declaration;
                    }
                    for (PsiElement element1 : elements = newDeclaration.getDeclaredElements()) {
                        PsiVariable var = (PsiVariable)element1;
                        PsiExpression initializer = var.getInitializer();
                        if (initializer == null) continue;
                        if (!generateInitializers || var.hasModifierProperty("final")) {
                            initializer.delete();
                            continue;
                        }
                        String defaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)var.getType());
                        expr = factory.createExpressionFromText(defaultValue, null);
                        initializer.replace((PsiElement)expr);
                    }
                    continue;
                }
                array.add(statement);
            }
            return array.toArray(new PsiElement[array.size()]);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return statements;
        }
    }

    private static boolean needToDeclareOut(PsiElement block, PsiElement[] statements, PsiDeclarationStatement statement) {
        PsiElement[] elements = statement.getDeclaredElements();
        PsiElement lastStatement = statements[statements.length - 1];
        int endOffset = lastStatement.getTextRange().getEndOffset();
        for (PsiElement element : elements) {
            PsiReference lastRef;
            GlobalSearchScope projectScope;
            PsiReference[] refs;
            if (!(element instanceof PsiVariable) || (refs = (PsiReference[])ReferencesSearch.search((PsiElement)element, (SearchScope)(projectScope = GlobalSearchScope.projectScope((Project)element.getProject())), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)).length <= 0 || (lastRef = refs[refs.length - 1]).getElement().getTextOffset() <= endOffset) continue;
            return true;
        }
        return false;
    }

    public static TextRange getRangeToSelect(PsiCodeBlock block) {
        PsiElement first = block.getFirstBodyElement();
        if (first instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        if (first == null) {
            int offset = block.getTextRange().getStartOffset() + 1;
            return new TextRange(offset, offset);
        }
        PsiElement last = block.getRBrace().getPrevSibling();
        if (last instanceof PsiWhiteSpace) {
            last = last.getPrevSibling();
        }
        return new TextRange(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
    }
}

