/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.List;

public class CodeBlockOrInitializerSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiCodeBlock || e instanceof PsiArrayInitializerExpression;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        PsiElement[] children = e.getChildren();
        int start = CodeBlockOrInitializerSelectioner.findOpeningBrace(children);
        int end = CodeBlockOrInitializerSelectioner.findClosingBrace(children, start);
        result.add(e.getTextRange());
        result.addAll(CodeBlockOrInitializerSelectioner.expandToWholeLine(editorText, new TextRange(start, end)));
        return result;
    }

    public static int findOpeningBrace(PsiElement[] children) {
        int start = 0;
        for (int i = 0; i < children.length; ++i) {
            PsiJavaToken token;
            PsiElement child = children[i];
            if (!(child instanceof PsiJavaToken) || (token = (PsiJavaToken)child).getTokenType() != JavaTokenType.LBRACE) continue;
            int j = i + 1;
            while (children[j] instanceof PsiWhiteSpace) {
                ++j;
            }
            start = children[j].getTextRange().getStartOffset();
        }
        return start;
    }

    public static int findClosingBrace(PsiElement[] children, int startOffset) {
        int end = children[children.length - 1].getTextRange().getEndOffset();
        for (int i = 0; i < children.length; ++i) {
            PsiJavaToken token;
            PsiElement child = children[i];
            if (!(child instanceof PsiJavaToken) || (token = (PsiJavaToken)child).getTokenType() != JavaTokenType.RBRACE) continue;
            int j = i - 1;
            while (children[j] instanceof PsiWhiteSpace && children[j].getTextRange().getStartOffset() > startOffset) {
                --j;
            }
            end = children[j].getTextRange().getEndOffset();
        }
        return end;
    }
}

