/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;

public class MissingArrayInitializerBraceFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        int index;
        int startOffset;
        if (!(psiElement instanceof PsiArrayInitializerExpression)) {
            return;
        }
        PsiArrayInitializerExpression expr = (PsiArrayInitializerExpression)psiElement;
        Document doc = editor.getDocument();
        String exprText = expr.getText();
        TextRange textRange = expr.getTextRange();
        int endOffset = textRange.getEndOffset();
        int caretOffset = editor.getCaretModel().getOffset();
        if (caretOffset > (startOffset = textRange.getStartOffset()) && caretOffset < endOffset && (index = exprText.indexOf(10, caretOffset - startOffset)) >= 0) {
            doc.insertString(index + startOffset, (CharSequence)"}");
            return;
        }
        if (!exprText.endsWith("}")) {
            doc.insertString(endOffset, (CharSequence)"}");
        }
    }
}

