/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import java.util.List;

public class XmlTagSelectioner
extends ExtendWordSelectionHandlerBase {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof XmlTag;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        List<TextRange> result = super.select(e, editorText, cursorOffset, editor);
        PsiElement[] children = e.getChildren();
        XmlTagSelectioner.addTagContentSelection(children, result, editorText);
        PsiElement prev = e.getPrevSibling();
        while ((prev instanceof PsiWhiteSpace || prev instanceof XmlText || prev instanceof XmlComment) && (!(prev instanceof XmlText) || prev.getText().trim().length() <= 0)) {
            if (prev instanceof XmlComment) {
                result.addAll(XmlTagSelectioner.expandToWholeLine(editorText, new TextRange(prev.getTextRange().getStartOffset(), e.getTextRange().getEndOffset()), false));
            }
            prev = prev.getPrevSibling();
        }
        return result;
    }

    private static void addTagContentSelection(PsiElement[] children, List<TextRange> result, CharSequence editorText) {
        PsiElement first = null;
        PsiElement last = null;
        for (PsiElement child : children) {
            if (!(child instanceof XmlToken)) continue;
            XmlToken token = (XmlToken)child;
            if (token.getTokenType() == XmlTokenType.XML_TAG_END) {
                first = token.getNextSibling();
            }
            if (token.getTokenType() != XmlTokenType.XML_END_TAG_START) continue;
            last = token.getPrevSibling();
            break;
        }
        if (first != null && last != null) {
            result.addAll(XmlTagSelectioner.expandToWholeLine(editorText, new TextRange(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset()), false));
        }
    }
}

