/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SelectWordUtil {
    private static ExtendWordSelectionHandler[] SELECTIONERS = new ExtendWordSelectionHandler[0];
    private static boolean ourExtensionsLoaded = false;

    public static void registerSelectioner(ExtendWordSelectionHandler selectioner) {
        SELECTIONERS = (ExtendWordSelectionHandler[])ArrayUtil.append((Object[])SELECTIONERS, (Object)selectioner);
    }

    static ExtendWordSelectionHandler[] getExtendWordSelectionHandlers() {
        if (!ourExtensionsLoaded) {
            ourExtensionsLoaded = true;
            for (ExtendWordSelectionHandler handler : (ExtendWordSelectionHandler[])Extensions.getExtensions((ExtensionPointName)ExtendWordSelectionHandler.EP_NAME)) {
                SelectWordUtil.registerSelectioner(handler);
            }
        }
        return SELECTIONERS;
    }

    public static void addWordSelection(boolean camel, CharSequence editorText, int cursorOffset, @NotNull List<TextRange> ranges) {
        TextRange range;
        TextRange camelRange;
        if (ranges == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/editorActions/SelectWordUtil.addWordSelection must not be null");
        }
        TextRange textRange = camelRange = camel ? SelectWordUtil.getCamelSelectionRange(editorText, cursorOffset) : null;
        if (camelRange != null) {
            ranges.add(camelRange);
        }
        if ((range = SelectWordUtil.getWordSelectionRange(editorText, cursorOffset)) != null && !range.equals((Object)camelRange)) {
            ranges.add(range);
        }
    }

    private static TextRange getCamelSelectionRange(CharSequence editorText, int cursorOffset) {
        if (cursorOffset > 0 && !Character.isJavaIdentifierPart(editorText.charAt(cursorOffset)) && Character.isJavaIdentifierPart(editorText.charAt(cursorOffset - 1))) {
            --cursorOffset;
        }
        if (Character.isJavaIdentifierPart(editorText.charAt(cursorOffset))) {
            char nextChar;
            char curChar;
            char prevChar;
            int start;
            int end = cursorOffset + 1;
            int textLen = editorText.length();
            for (start = cursorOffset; start > 0 && Character.isJavaIdentifierPart(editorText.charAt(start - 1)); --start) {
                prevChar = editorText.charAt(start - 1);
                curChar = editorText.charAt(start);
                char c = nextChar = start + 1 < textLen ? editorText.charAt(start + 1) : (char)'\u0000';
                if (Character.isLowerCase(prevChar) && Character.isUpperCase(curChar) || prevChar == '_' && curChar != '_' || Character.isUpperCase(prevChar) && Character.isUpperCase(curChar) && Character.isLowerCase(nextChar)) break;
            }
            while (end < textLen && Character.isJavaIdentifierPart(editorText.charAt(end))) {
                prevChar = editorText.charAt(end - 1);
                curChar = editorText.charAt(end);
                char c = nextChar = end + 1 < textLen ? editorText.charAt(end + 1) : (char)'\u0000';
                if (Character.isLowerCase(prevChar) && Character.isUpperCase(curChar) || prevChar != '_' && curChar == '_' || Character.isUpperCase(prevChar) && Character.isUpperCase(curChar) && Character.isLowerCase(nextChar)) break;
                ++end;
            }
            if (start + 1 < end) {
                return new TextRange(start, end);
            }
        }
        return null;
    }

    public static TextRange getWordSelectionRange(CharSequence editorText, int cursorOffset) {
        if (editorText.length() == 0) {
            return null;
        }
        if (cursorOffset > 0 && !Character.isJavaIdentifierPart(editorText.charAt(cursorOffset)) && Character.isJavaIdentifierPart(editorText.charAt(cursorOffset - 1))) {
            --cursorOffset;
        }
        if (Character.isJavaIdentifierPart(editorText.charAt(cursorOffset))) {
            int start;
            int end = cursorOffset;
            for (start = cursorOffset; start > 0 && Character.isJavaIdentifierPart(editorText.charAt(start - 1)); --start) {
            }
            while (end < editorText.length() && Character.isJavaIdentifierPart(editorText.charAt(end))) {
                ++end;
            }
            return new TextRange(start, end);
        }
        return null;
    }
}

