/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class EmacsStyleIndentAction
extends BaseCodeInsightAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.actions.EmacsStyleIndentAction");

    protected CodeInsightActionHandler getHandler() {
        return new Handler();
    }

    protected boolean isValidForFile(Project project, Editor editor, PsiFile file) {
        PsiElement context = file.findElementAt(editor.getCaretModel().getOffset());
        return context != null && LanguageFormatting.INSTANCE.forContext(context) != null;
    }

    private static class Handler
    implements CodeInsightActionHandler {
        private Handler() {
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/editorActions/EmacsStyleIndentAction$Handler.invoke must not be null");
            }
            if (editor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/editorActions/EmacsStyleIndentAction$Handler.invoke must not be null");
            }
            if (file == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/editorActions/EmacsStyleIndentAction$Handler.invoke must not be null");
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
                return;
            }
            Document document = editor.getDocument();
            int startOffset = editor.getCaretModel().getOffset();
            int line = editor.offsetToLogicalPosition((int)startOffset).line;
            int col = editor.getCaretModel().getLogicalPosition().column;
            int lineStart = document.getLineStartOffset(line);
            int initLineEnd = document.getLineEndOffset(line);
            try {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                int newPos = codeStyleManager.adjustLineIndent(file, lineStart);
                int newCol = newPos - lineStart;
                int lineInc = document.getLineEndOffset(line) - initLineEnd;
                if (newCol >= col + lineInc) {
                    LogicalPosition pos = new LogicalPosition(line, newCol);
                    editor.getCaretModel().moveToLogicalPosition(pos);
                    editor.getSelectionModel().removeSelection();
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }
}

