/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class RenameFileReferenceIntentionAction
implements IntentionAction,
LocalQuickFix {
    private final String myExistingElementName;
    private final FileReference myFileReference;

    public RenameFileReferenceIntentionAction(String existingElementName, FileReference fileReference) {
        this.myExistingElementName = existingElementName;
        this.myFileReference = fileReference;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"rename.file.reference.text", (Object[])new Object[]{this.myExistingElementName});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"rename.file.reference.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction.getFamilyName must not return null");
        }
        return string;
    }

    public void applyFix(final @NotNull Project project, final @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction.applyFix must not be null");
        }
        if (this.isAvailable(project, null, null)) {
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(Result result) throws Throwable {
                    RenameFileReferenceIntentionAction.this.invoke(project, null, descriptor.getPsiElement().getContainingFile());
                }
            }.execute();
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction.isAvailable must not be null");
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        this.myFileReference.handleElementRename(this.myExistingElementName);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

