/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithArrayFix
extends PsiElementBaseIntentionAction {
    private final PsiCall myMethodCall;

    public SurroundWithArrayFix(PsiCall methodCall) {
        this.myMethodCall = methodCall;
    }

    @NotNull
    public String getText() {
        if ("Surround with array initialization" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix.getText must not return null");
        }
        return "Surround with array initialization";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @Nullable PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix.isAvailable must not be null");
        }
        return this.getExpression(element) != null;
    }

    @Nullable
    protected PsiExpression getExpression(PsiElement element) {
        if (this.myMethodCall == null || !this.myMethodCall.isValid()) {
            return null;
        }
        PsiMethod method = this.myMethodCall.resolveMethod();
        if (method != null) {
            PsiMethod psiMethod = method;
            return this.checkMethod(element, psiMethod);
        }
        if (this.myMethodCall instanceof PsiMethodCallExpression) {
            Collection<PsiElement> psiElements = TargetElementUtil.getInstance().getTargetCandidates((PsiReference)((PsiMethodCallExpression)this.myMethodCall).getMethodExpression());
            for (PsiElement psiElement : psiElements) {
                PsiExpression expression;
                if (!(psiElement instanceof PsiMethod) || (expression = this.checkMethod(element, (PsiMethod)psiElement)) == null) continue;
                return expression;
            }
        }
        return null;
    }

    @Nullable
    private PsiExpression checkMethod(PsiElement element, PsiMethod psiMethod) {
        PsiParameter[] psiParameters = psiMethod.getParameterList().getParameters();
        PsiExpressionList argumentList = this.myMethodCall.getArgumentList();
        int idx = 0;
        for (PsiExpression expression : argumentList.getExpressions()) {
            PsiType expressionType;
            PsiType paramType;
            if (element != null && PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)element, (boolean)false) && psiParameters.length > idx && (paramType = psiParameters[idx].getType()) instanceof PsiArrayType && (expressionType = expression.getType()) != null) {
                PsiType componentType = ((PsiArrayType)paramType).getComponentType();
                if (expressionType.isAssignableFrom(componentType)) {
                    return expression;
                }
                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)componentType);
                if (ArrayUtil.find((Object[])psiMethod.getTypeParameters(), (Object)psiClass) != -1) {
                    for (PsiClassType superType : psiClass.getSuperTypes()) {
                        if (!TypeConversionUtil.isAssignable((PsiType)superType, (PsiType)expressionType)) continue;
                        return expression;
                    }
                }
            }
            ++idx;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiExpression expression = this.getExpression(file.findElementAt(editor.getCaretModel().getOffset()));
        assert (expression != null);
        PsiExpression toReplace = elementFactory.createExpressionFromText(SurroundWithArrayFix.getArrayCreation(expression), (PsiElement)file);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(expression.replace((PsiElement)toReplace));
    }

    @NonNls
    private static String getArrayCreation(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithArrayFix.getArrayCreation must not be null");
        }
        PsiType expressionType = expression.getType();
        assert (expressionType != null);
        return "new " + expressionType.getCanonicalText() + "[]{" + expression.getText() + "}";
    }

    public boolean startInWriteAction() {
        return true;
    }
}

