/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MoveClassToSeparateFileFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.MoveClassToSeparateFileFix");
    private final PsiClass myClass;

    public MoveClassToSeparateFileFix(PsiClass aClass) {
        this.myClass = aClass;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("move.class.to.separate.file.text", this.myClass.getName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToSeparateFileFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("move.class.to.separate.file.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToSeparateFileFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToSeparateFileFix.isAvailable must not be null");
        }
        if (!this.myClass.isValid() || !this.myClass.getManager().isInProject((PsiElement)this.myClass)) {
            return false;
        }
        PsiDirectory dir = file.getContainingDirectory();
        if (dir == null) {
            return false;
        }
        try {
            String name = this.myClass.getName();
            if (this.myClass.isInterface()) {
                JavaDirectoryService.getInstance().checkCreateInterface(dir, name);
            } else {
                JavaDirectoryService.getInstance().checkCreateClass(dir, name);
            }
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MoveClassToSeparateFileFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myClass.getContainingFile())) {
            return;
        }
        PsiDirectory dir = file.getContainingDirectory();
        try {
            String name = this.myClass.getName();
            PsiClass placeHolder = this.myClass.isInterface() ? JavaDirectoryService.getInstance().createInterface(dir, name) : JavaDirectoryService.getInstance().createClass(dir, name);
            PsiClass newClass = (PsiClass)placeHolder.replace((PsiElement)this.myClass);
            this.myClass.delete();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, newClass.getContainingFile().getVirtualFile(), newClass.getTextOffset());
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

