/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodParameterFix
extends IntentionAndQuickFixAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnFix");
    private final PsiMethod myMethod;
    private final PsiType myParameterType;
    private final int myIndex;
    private final boolean myFixWholeHierarchy;

    public MethodParameterFix(PsiMethod method, PsiType type, int index, boolean fixWholeHierarchy) {
        this.myMethod = method;
        this.myParameterType = type;
        this.myIndex = index;
        this.myFixWholeHierarchy = fixWholeHierarchy;
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("fix.parameter.type.text", this.myMethod.getName(), this.myParameterType.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MethodParameterFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.parameter.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/MethodParameterFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/MethodParameterFix.isAvailable must not be null");
        }
        return this.myMethod != null && this.myMethod.isValid() && this.myMethod.getManager().isInProject((PsiElement)this.myMethod) && this.myParameterType != null && !TypeConversionUtil.isNullType((PsiType)this.myParameterType) && this.myMethod.getReturnType() != null && !Comparing.equal((Object)this.myParameterType, (Object)this.myMethod.getReturnType());
    }

    public void applyFix(Project project, PsiFile file, @Nullable Editor editor) {
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myMethod.getContainingFile())) {
            return;
        }
        try {
            PsiMethod method = this.myMethod;
            if (this.myFixWholeHierarchy && (method = this.myMethod.findDeepestSuperMethod()) == null) {
                method = this.myMethod;
            }
            ChangeSignatureProcessor processor = new ChangeSignatureProcessor(project, method, false, null, method.getName(), method.getReturnType(), this.getNewParametersInfo());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                processor.run();
            } else {
                processor.run();
            }
            UndoUtil.markPsiFileForUndo((PsiFile)file);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private ParameterInfoImpl[] getNewParametersInfo() throws IncorrectOperationException {
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters = this.myMethod.getParameterList().getParameters();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myMethod.getProject());
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, this.myParameterType);
        PsiParameter newParameter = factory.createParameter(nameInfo.names[0], this.myParameterType);
        if (this.myMethod.getContainingClass().isInterface()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)newParameter, (String)"final", (boolean)false);
        }
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            if (i == this.myIndex) {
                newParameter.setName(parameter.getName());
                parameter = newParameter;
            }
            result.add(new ParameterInfoImpl(i, parameter.getName(), parameter.getType()));
        }
        if (parameters.length == this.myIndex) {
            result.add(new ParameterInfoImpl(-1, newParameter.getName(), newParameter.getType()));
        }
        return result.toArray(new ParameterInfoImpl[result.size()]);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

