/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LocateLibraryDialog
extends DialogWrapper {
    private JPanel contentPane;
    private JTextPane myDescription;
    private JLabel myFileLabel;
    private TextFieldWithBrowseButton myLibraryFile;
    private JRadioButton myAddThisFileRadioButton;
    private JRadioButton myCopyToRadioButton;
    private TextFieldWithBrowseButton myCopyToDir;
    private final Project myProject;
    private String myResultingLibraryPath;

    public String getResultingLibraryPath() {
        return this.myResultingLibraryPath;
    }

    public LocateLibraryDialog(Module module, String libraryPath, @NonNls String libraryName, String libraryDescription) {
        super(module.getProject(), true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(QuickFixBundle.message("add.library.title.dialog", objectArray));
        this.myProject = module.getProject();
        JLabel label = new JLabel();
        this.myDescription.setFont(label.getFont());
        this.myDescription.setBackground(UIUtil.getOptionPaneBackground());
        this.myDescription.setForeground(label.getForeground());
        this.myDescription.setText(libraryDescription);
        this.myFileLabel.setLabelFor(this.myLibraryFile.getTextField());
        this.myLibraryFile.setText(new File(libraryPath, libraryName).getPath());
        this.myLibraryFile.addBrowseFolderListener(QuickFixBundle.message("add.library.title.locate.library", new Object[0]), QuickFixBundle.message("add.library.description.locate.library", new Object[0]), this.myProject, new FileChooserDescriptor(false, false, true, false, false, false));
        this.myCopyToDir.setText(new File(module.getModuleFilePath()).getParent());
        this.myCopyToDir.addBrowseFolderListener(QuickFixBundle.message("add.library.title.choose.folder", new Object[0]), QuickFixBundle.message("add.library.description.choose.folder", new Object[0]), this.myProject, new FileChooserDescriptor(false, true, false, false, false, false));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocateLibraryDialog.this.updateButtons();
            }
        };
        this.myAddThisFileRadioButton.addActionListener(listener);
        this.myCopyToRadioButton.addActionListener(listener);
        this.myAddThisFileRadioButton.setSelected(true);
        this.myCopyToDir.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                LocateLibraryDialog.this.updateButtons();
            }
        });
        this.updateButtons();
        this.init();
    }

    private void updateButtons() {
        boolean copyEnabled = this.myCopyToRadioButton.isSelected();
        this.myCopyToDir.setEnabled(copyEnabled);
        if (copyEnabled) {
            this.myCopyToDir.getTextField().requestFocusInWindow();
        }
        this.setOKActionEnabled(!copyEnabled || this.myCopyToDir.getText().length() != 0);
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "#org.jetbrains.codeInsight.daemon.impl.quickfix.LocateLibraryDialog";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            this.myResultingLibraryPath = this.getResultingPath();
            if (this.myResultingLibraryPath != null) {
                this.close(0);
            }
        }
    }

    @Nullable
    private String getResultingPath() {
        File srcFile = new File(this.myLibraryFile.getText());
        if (!srcFile.exists()) {
            Messages.showErrorDialog((Project)this.myProject, (String)QuickFixBundle.message("add.library.error.not.found", srcFile.getPath()), (String)QuickFixBundle.message("add.library.title.error", new Object[0]));
            return null;
        }
        if (!this.myCopyToRadioButton.isSelected()) {
            return srcFile.getPath();
        }
        String dstDir = this.myCopyToDir.getText();
        if (dstDir.length() == 0) {
            return null;
        }
        File dstFile = new File(dstDir, srcFile.getName());
        try {
            FileUtil.copy((File)srcFile, (File)dstFile);
            return dstFile.getPath();
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)QuickFixBundle.message("add.library.error.cannot.copy", srcFile.getPath(), dstFile.getPath(), e.getMessage()), (String)QuickFixBundle.message("add.library.title.error", new Object[0]));
            return null;
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JRadioButton jRadioButton;
        JLabel jLabel;
        JRadioButton jRadioButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 1, 1, 7, 4, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.myLibraryFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, new Dimension(100, -1), new Dimension(300, -1), null));
        this.myCopyToDir = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCopyToRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/QuickFixBundle").getString("add.library.copy.to"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFileLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/QuickFixBundle").getString("add.library.file"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myAddThisFileRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/QuickFixBundle").getString("add.library.add.this"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 7, 0, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.myDescription = jTextPane = new JTextPane();
        jTextPane.setText("");
        jTextPane.setEditable(false);
        jPanel3.add((Component)jTextPane, new GridConstraints(0, 0, 1, 1, 8, 2, 6, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

