/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class DeleteCatchFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.DeleteCatchFix");
    private final PsiParameter myCatchParameter;

    public DeleteCatchFix(PsiParameter myCatchParameter) {
        this.myCatchParameter = myCatchParameter;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("delete.catch.text", HighlightUtil.formatType(this.myCatchParameter.getType()));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/DeleteCatchFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("delete.catch.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/DeleteCatchFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/DeleteCatchFix.isAvailable must not be null");
        }
        return this.myCatchParameter != null && this.myCatchParameter.isValid() && PsiManager.getInstance((Project)project).isInProject((PsiElement)this.myCatchParameter.getContainingFile());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/DeleteCatchFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myCatchParameter.getContainingFile())) {
            return;
        }
        try {
            PsiTryStatement tryStatement = ((PsiCatchSection)this.myCatchParameter.getDeclarationScope()).getTryStatement();
            PsiElement tryParent = tryStatement.getParent();
            if (tryStatement.getCatchBlocks().length == 1 && tryStatement.getFinallyBlock() == null) {
                PsiCodeBlock tryBlock = tryStatement.getTryBlock();
                PsiElement firstElement = tryBlock.getFirstBodyElement();
                PsiElement lastAddedStatement = null;
                if (firstElement != null) {
                    PsiElement endElement = tryBlock.getLastBodyElement();
                    tryParent.addRangeBefore(firstElement, endElement, (PsiElement)tryStatement);
                    for (lastAddedStatement = tryStatement.getPrevSibling(); lastAddedStatement != null && (lastAddedStatement instanceof PsiWhiteSpace || lastAddedStatement.getTextLength() == 0); lastAddedStatement = lastAddedStatement.getPrevSibling()) {
                    }
                }
                tryStatement.delete();
                if (lastAddedStatement != null) {
                    editor.getCaretModel().moveToOffset(lastAddedStatement.getTextRange().getEndOffset());
                }
                return;
            }
            LOG.assertTrue(this.myCatchParameter.getParent() instanceof PsiCatchSection);
            PsiElement catchSection = this.myCatchParameter.getParent();
            PsiElement previousElement = catchSection.getPrevSibling();
            while (previousElement instanceof PsiWhiteSpace) {
                previousElement = previousElement.getPrevSibling();
            }
            catchSection.delete();
            if (previousElement != null) {
                editor.getCaretModel().moveToOffset(previousElement.getTextRange().getEndOffset());
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

