/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class CreateInnerClassFromUsageFix
extends CreateClassFromUsageBaseFix {
    public CreateInnerClassFromUsageFix(PsiJavaCodeReferenceElement refElement, CreateClassKind kind) {
        super(kind, refElement);
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.inner.class.from.usage.text", StringUtil.capitalize((String)this.myKind.getDescription()), varName);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateInnerClassFromUsageFix.invoke must not be null");
        }
        PsiJavaCodeReferenceElement element = this.getRefElement();
        assert (element != null);
        String superClassName = CreateInnerClassFromUsageFix.getSuperClassName(element);
        PsiClass[] targets = CreateInnerClassFromUsageFix.getPossibleTargets(element);
        LOG.assertTrue(targets.length > 0);
        if (targets.length == 1) {
            this.doInvoke(targets[0], superClassName);
        } else {
            this.chooseTargetClass(targets, editor, superClassName);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateInnerClassFromUsageFix.isAvailable must not be null");
        }
        return super.isAvailable(project, editor, file) && CreateInnerClassFromUsageFix.getPossibleTargets(this.getRefElement()).length > 0;
    }

    @NotNull
    private static PsiClass[] getPossibleTargets(PsiJavaCodeReferenceElement element) {
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        PsiJavaCodeReferenceElement run = element;
        PsiMember contextMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)run, PsiMember.class);
        while (contextMember != null) {
            if (contextMember instanceof PsiClass) {
                result.add((PsiClass)contextMember);
            }
            if ((contextMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)(run = contextMember), PsiMember.class)) == null || !contextMember.hasModifierProperty("static")) continue;
        }
        PsiClass[] psiClassArray = result.isEmpty() ? PsiClass.EMPTY_ARRAY : result.toArray(new PsiClass[result.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateInnerClassFromUsageFix.getPossibleTargets must not return null");
        }
        return psiClassArray;
    }

    private void chooseTargetClass(PsiClass[] classes, Editor editor, final String superClassName) {
        final Project project = classes[0].getProject();
        final JList<PsiClass> list = new JList<PsiClass>(classes);
        PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
        list.setSelectionMode(0);
        list.setCellRenderer(renderer);
        PopupChooserBuilder builder = new PopupChooserBuilder(list);
        renderer.installSpeedSearch(builder);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int index = list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                final PsiClass aClass = (PsiClass)list.getSelectedValue();
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    CreateInnerClassFromUsageFix.this.doInvoke(aClass, superClassName);
                                }
                                catch (IncorrectOperationException e) {
                                    CreateClassFromUsageBaseFix.LOG.error((Throwable)e);
                                }
                            }
                        });
                    }
                }, CreateInnerClassFromUsageFix.this.getText(), null);
            }
        };
        builder.setTitle(QuickFixBundle.message("target.class.chooser.title", new Object[0])).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(editor);
    }

    private void doInvoke(PsiClass aClass, String superClassName) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref = this.getRefElement();
        assert (ref != null);
        String refName = ref.getReferenceName();
        LOG.assertTrue(refName != null);
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        PsiClass created = this.myKind == CreateClassKind.INTERFACE ? elementFactory.createInterface(refName) : (this.myKind == CreateClassKind.CLASS ? elementFactory.createClass(refName) : elementFactory.createEnum(refName));
        PsiModifierList modifierList = created.getModifierList();
        LOG.assertTrue(modifierList != null);
        modifierList.setModifierProperty("private", true);
        if (superClassName != null) {
            PsiJavaCodeReferenceElement superClass = elementFactory.createReferenceElementByFQClassName(superClassName, created.getResolveScope());
            PsiReferenceList extendsList = created.getExtendsList();
            LOG.assertTrue(extendsList != null);
            extendsList.add((PsiElement)superClass);
        }
        created = (PsiClass)aClass.add((PsiElement)created);
        ref.bindToElement((PsiElement)created);
    }
}

