/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeMethodSignatureFromUsageFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.AssignFieldFromParameterAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateConstructorParameterFromFieldFix
implements IntentionAction {
    private final SmartPsiElementPointer<PsiField> myField;

    public CreateConstructorParameterFromFieldFix(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorParameterFromFieldFix.<init> must not be null");
        }
        this.myField = SmartPointerManager.getInstance((Project)field.getProject()).createSmartPsiElementPointer((PsiElement)field);
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("add.constructor.parameter.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorParameterFromFieldFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorParameterFromFieldFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorParameterFromFieldFix.isAvailable must not be null");
        }
        PsiField field = this.getField();
        PsiClass containingClass = field == null ? null : field.getContainingClass();
        return field != null && field.getManager().isInProject((PsiElement)field) && !field.hasModifierProperty("static") && containingClass != null && !(containingClass instanceof JspClass) && containingClass.getName() != null;
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateConstructorParameterFromFieldFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        PsiClass aClass = this.getField().getContainingClass();
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            final AddDefaultConstructorFix defaultConstructorFix = new AddDefaultConstructorFix(aClass);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    defaultConstructorFix.invoke(project, editor, file);
                }
            });
            aClass = this.getField().getContainingClass();
            constructors = aClass.getConstructors();
        }
        for (int i = 0; i < constructors.length && this.addParameterToConstructor(project, file, editor, this.getField().getContainingClass().getConstructors()[i]); ++i) {
        }
    }

    private boolean addParameterToConstructor(final Project project, PsiFile file, final Editor editor, PsiMethod constructor) throws IncorrectOperationException {
        final PsiParameter[] parameters = constructor.getParameterList().getParameters();
        PsiExpression[] expressions = new PsiExpression[parameters.length + 1];
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            String value = PsiTypesUtil.getDefaultValueOfType((PsiType)parameter.getType());
            expressions[i] = factory.createExpressionFromText(value, (PsiElement)parameter);
        }
        expressions[parameters.length] = factory.createExpressionFromText(this.getField().getName(), (PsiElement)constructor);
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.getField().getProject());
        final SmartPsiElementPointer constructorPointer = manager.createSmartPsiElementPointer((PsiElement)constructor);
        final ChangeMethodSignatureFromUsageFix addParamFix = new ChangeMethodSignatureFromUsageFix(constructor, expressions, PsiSubstitutor.EMPTY, (PsiElement)constructor, true, 1);
        addParamFix.invoke(project, editor, file);
        return (Boolean)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return CreateConstructorParameterFromFieldFix.this.doCreate(project, editor, parameters, constructorPointer, addParamFix);
            }
        });
    }

    private boolean doCreate(Project project, Editor editor, PsiParameter[] parameters, SmartPsiElementPointer constructorPointer, ChangeMethodSignatureFromUsageFix addParamFix) {
        PsiMethod constructor = (PsiMethod)constructorPointer.getElement();
        assert (constructor != null);
        PsiParameter[] newParameters = constructor.getParameterList().getParameters();
        if (newParameters == parameters) {
            return false;
        }
        String newName = addParamFix.getNewParameterNameByOldIndex(-1);
        PsiParameter parameter = null;
        for (PsiParameter newParameter : newParameters) {
            if (!Comparing.strEqual((String)newName, (String)newParameter.getName())) continue;
            parameter = newParameter;
            break;
        }
        if (parameter == null) {
            return false;
        }
        if (HighlightControlFlowUtil.getChainedConstructors(constructor) == null) {
            AssignFieldFromParameterAction.addFieldAssignmentStatement(project, this.getField(), parameter, editor);
        }
        return true;
    }

    private PsiField getField() {
        return (PsiField)this.myField.getElement();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

