/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddTypeArgumentsFix
extends MethodArgumentFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix");
    public static ArgumentFixerActionFactory REGISTRAR = new MyFixerActionFactory();

    private AddTypeArgumentsFix(PsiExpressionList list, int i, PsiType toType, ArgumentFixerActionFactory factory) {
        super(list, i, toType, factory);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getText() {
        String string;
        if (this.myArgList.getExpressions().length == 1) {
            string = QuickFixBundle.message("add.type.arguments.single.argument.text", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix.getText must not return null");
            return string;
        }
        string = QuickFixBundle.message("add.type.arguments.text", this.myIndex + 1);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix.getText must not return null");
    }

    private static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        private MyFixerActionFactory() {
        }

        @Override
        public AddTypeArgumentsFix createFix(PsiExpressionList list, int i, PsiType toType) {
            return new AddTypeArgumentsFix(list, i, toType, this);
        }

        @Override
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression)) {
                return null;
            }
            if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
                PsiReferenceParameterList list = methodCall.getMethodExpression().getParameterList();
                if (list == null || list.getTypeArguments().length > 0) {
                    return null;
                }
                JavaResolveResult resolveResult = methodCall.resolveMethodGenerics();
                PsiElement element = resolveResult.getElement();
                if (element instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)element;
                    PsiType returnType = method.getReturnType();
                    if (returnType == null) {
                        return null;
                    }
                    PsiTypeParameter[] typeParameters = method.getTypeParameters();
                    if (typeParameters.length > 0) {
                        PsiType[] mappings = new PsiType[typeParameters.length];
                        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)expression.getProject()).getResolveHelper();
                        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)expression);
                        for (int i = 0; i < typeParameters.length; ++i) {
                            PsiTypeParameter typeParameter = typeParameters[i];
                            PsiType substitution = helper.getSubstitutionForTypeParameter(typeParameter, returnType, toType, false, level);
                            if (substitution == null || PsiType.NULL.equals(substitution)) {
                                return null;
                            }
                            mappings[i] = substitution;
                        }
                        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory();
                        PsiMethodCallExpression copy = (PsiMethodCallExpression)expression.copy();
                        PsiReferenceParameterList parameterList = copy.getMethodExpression().getParameterList();
                        LOG.assertTrue(parameterList != null);
                        for (PsiType mapping : mappings) {
                            parameterList.add((PsiElement)factory.createTypeElement(mapping));
                        }
                        return copy;
                    }
                }
            }
            return null;
        }

        @Override
        public boolean areTypesConvertible(PsiType exprType, PsiType parameterType, PsiElement context) {
            return !(exprType instanceof PsiPrimitiveType) && !(parameterType instanceof PsiPrimitiveType);
        }
    }
}

