/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.IncreaseLanguageLevelFix;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.SetupJDKFix;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HighlightVisitorImpl
extends JavaElementVisitor
implements HighlightVisitor,
DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.HighlightVisitorImpl");
    private final PsiResolveHelper myResolveHelper;
    private HighlightInfoHolder myHolder;
    private RefCountHolder myRefCountHolder;
    private final Map<PsiElement, Collection<PsiReferenceExpression>> myUninitializedVarProblems;
    private final Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> myFinalVarProblems;
    private final Map<PsiParameter, Boolean> myParameterIsReassigned;
    private final Map<String, Pair<PsiImportStatementBase, PsiClass>> mySingleImportedClasses;
    private final Map<String, Pair<PsiImportStaticReferenceElement, PsiField>> mySingleImportedFields;
    private PsiFile myFile;
    private final PsiElementVisitor REGISTER_REFERENCES_VISITOR;

    public HighlightVisitorImpl(Project project) {
        this(JavaPsiFacade.getInstance((Project)project).getResolveHelper());
    }

    private HighlightVisitorImpl(@NotNull PsiResolveHelper resolveHelper) {
        if (resolveHelper == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl.<init> must not be null");
        }
        this.myUninitializedVarProblems = new THashMap();
        this.myFinalVarProblems = new THashMap();
        this.myParameterIsReassigned = new THashMap();
        this.mySingleImportedClasses = new THashMap();
        this.mySingleImportedFields = new THashMap();
        this.REGISTER_REFERENCES_VISITOR = new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                for (PsiReference reference : element.getReferences()) {
                    PsiElement resolved = reference.resolve();
                    if (!(resolved instanceof PsiNamedElement)) continue;
                    HighlightVisitorImpl.this.myRefCountHolder.registerLocallyReferenced((PsiNamedElement)resolved);
                }
            }
        };
        this.myResolveHelper = resolveHelper;
    }

    @Override
    public HighlightVisitorImpl clone() {
        return new HighlightVisitorImpl(this.myResolveHelper);
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public boolean suitableForFile(PsiFile file) {
        return !InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file);
    }

    @Override
    public void visit(PsiElement element, HighlightInfoHolder holder) {
        this.myHolder = holder;
        if (LOG.isDebugEnabled()) {
            LOG.assertTrue(element.isValid());
        }
        element.accept((PsiElementVisitor)this);
        if (this.myRefCountHolder != null) {
            this.instantiateInjections(element);
        }
    }

    private void instantiateInjections(PsiElement element) {
        InjectedLanguageUtil.enumerate(element, this.myFile, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl$2.visit must not be null");
                }
                if (places == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl$2.visit must not be null");
                }
            }
        }, false);
    }

    private void registerReferencesFromInjectedFragments(PsiElement element) {
        InjectedLanguageUtil.enumerate(element, this.myFile, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl$3.visit must not be null");
                }
                if (places == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl$3.visit must not be null");
                }
                injectedPsi.accept(HighlightVisitorImpl.this.REGISTER_REFERENCES_VISITOR);
            }
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(Runnable action, boolean updateWholeFile, PsiFile file) {
        this.myFile = file;
        boolean success = true;
        try {
            if (updateWholeFile) {
                RefCountHolder refCountHolder;
                Project project = file.getProject();
                DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
                FileStatusMap fileStatusMap = ((DaemonCodeAnalyzerImpl)daemonCodeAnalyzer).getFileStatusMap();
                this.myRefCountHolder = refCountHolder = RefCountHolder.getInstance(file);
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
                TextRange dirtyScope = document == null ? file.getTextRange() : fileStatusMap.getFileDirtyScope(document, 4);
                success = refCountHolder.analyze(action, dirtyScope, file);
            } else {
                this.myRefCountHolder = null;
                action.run();
            }
        }
        finally {
            this.myUninitializedVarProblems.clear();
            this.myFinalVarProblems.clear();
            this.mySingleImportedClasses.clear();
            this.mySingleImportedFields.clear();
            this.myParameterIsReassigned.clear();
            this.myRefCountHolder = null;
            this.myFile = null;
            this.myHolder = null;
        }
        return success;
    }

    public void visitElement(PsiElement element) {
        if (element instanceof XmlAttributeValue) {
            try {
                for (PsiReference reference : element.getReferences()) {
                    if (!(reference instanceof PsiJavaReference) || this.myRefCountHolder == null) continue;
                    PsiJavaReference psiJavaReference = (PsiJavaReference)reference;
                    this.myRefCountHolder.registerReference(psiJavaReference, psiJavaReference.advancedResolve(false));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
    }

    public void visitAnnotation(PsiAnnotation annotation) {
        super.visitAnnotation(annotation);
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)annotation)) {
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)annotation, JavaErrorMessages.message("annotations.prior.15", new Object[0]));
            QuickFixAction.registerQuickFixAction(info, new IncreaseLanguageLevelFix(LanguageLevel.JDK_1_5));
            this.myHolder.add(info);
            return;
        }
        this.myHolder.add(AnnotationsHighlightUtil.checkApplicability(annotation));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkAnnotationType(annotation));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkMissingAttributes(annotation));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkTargetAnnotationDuplicates(annotation));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkDuplicatedAnnotations(annotation));
        }
    }

    public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer) {
        PsiType type;
        PsiMethod method = null;
        PsiElement parent = initializer.getParent();
        if (parent instanceof PsiNameValuePair) {
            method = (PsiMethod)parent.getReference().resolve();
        } else if (parent instanceof PsiAnnotationMethod) {
            method = (PsiMethod)parent;
        }
        if (method != null && (type = method.getReturnType()) instanceof PsiArrayType) {
            PsiAnnotationMemberValue[] initializers;
            type = ((PsiArrayType)type).getComponentType();
            for (PsiAnnotationMemberValue initializer1 : initializers = initializer.getInitializers()) {
                this.myHolder.add(AnnotationsHighlightUtil.checkMemberValueType(initializer1, type));
            }
        }
    }

    public void visitAnnotationMethod(PsiAnnotationMethod method) {
        PsiType returnType = method.getReturnType();
        PsiAnnotationMemberValue value = method.getDefaultValue();
        if (returnType != null && value != null) {
            this.myHolder.add(AnnotationsHighlightUtil.checkMemberValueType(value, returnType));
        }
        this.myHolder.add(AnnotationsHighlightUtil.checkValidAnnotationType(method.getReturnTypeElement()));
        this.myHolder.add(AnnotationsHighlightUtil.checkCyclicMemberType(method.getReturnTypeElement(), method.getContainingClass()));
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        super.visitArrayInitializerExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkArrayInitializerApplicable(expression));
        }
        if (!(expression.getParent() instanceof PsiNewExpression) && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkGenericArrayCreation((PsiElement)expression, expression.getType()));
        }
    }

    public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssignmentCompatibleTypes(assignment));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssignmentOperatorApplicable(assignment));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)assignment);
        }
    }

    public void visitBinaryExpression(PsiBinaryExpression expression) {
        super.visitBinaryExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkBinaryOperatorApplicable(expression));
        }
    }

    public void visitBreakStatement(PsiBreakStatement statement) {
        super.visitBreakStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelDefined(statement.getLabelIdentifier(), statement.findExitedStatement()));
        }
    }

    public void visitClass(PsiClass aClass) {
        super.visitClass(aClass);
        if (aClass instanceof JspClass) {
            return;
        }
        if (aClass.isAnnotationType() && !PsiUtil.isLanguageLevel5OrHigher((PsiElement)aClass)) {
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)aClass.getNameIdentifier(), JavaErrorMessages.message("annotations.prior.15", new Object[0]));
            QuickFixAction.registerQuickFixAction(info, new IncreaseLanguageLevelFix(LanguageLevel.JDK_1_5));
            this.myHolder.add(info);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkInterfaceMultipleInheritance(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkDuplicateTopLevelClass(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumMustNotBeLocal(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkImplicitThisReferenceBeforeSuper(aClass));
        }
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        super.visitClassInitializer(initializer);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkInitializerCompleteNormally(initializer));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement(initializer.getBody()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkThingNotAllowedInInterface((PsiElement)initializer, initializer.getContainingClass()));
        }
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
        super.visitClassObjectAccessExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkClassObjectAccessExpression(expression));
        }
    }

    public void visitComment(PsiComment comment) {
        super.visitComment(comment);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnclosedComment(comment));
        }
        if (this.myRefCountHolder != null && !this.myHolder.hasErrorResults()) {
            this.registerReferencesFromInjectedFragments((PsiElement)comment);
        }
    }

    public void visitContinueStatement(PsiContinueStatement statement) {
        super.visitContinueStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelDefined(statement.getLabelIdentifier(), statement.findContinuedStatement()));
        }
    }

    public void visitJavaToken(PsiJavaToken token) {
        super.visitJavaToken(token);
        if (!this.myHolder.hasErrorResults() && token.getTokenType() == JavaTokenType.RBRACE && token.getParent() instanceof PsiCodeBlock && token.getParent().getParent() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)token.getParent().getParent();
            this.myHolder.add(HighlightControlFlowUtil.checkMissingReturnStatement(method));
        }
    }

    public void visitDocComment(PsiDocComment comment) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnclosedComment((PsiComment)comment));
        }
    }

    public void visitDocTagValue(PsiDocTagValue value) {
        PsiReference reference;
        if (value.getReference() != null && (reference = value.getReference()) != null) {
            PsiElement element = reference.resolve();
            if (element instanceof PsiMethod) {
                this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMethod)element, ((PsiDocMethodOrFieldRef)value).getNameElement(), false));
            } else if (element instanceof PsiParameter) {
                this.myHolder.add(HighlightNamesUtil.highlightVariable((PsiVariable)element, value.getNavigationElement()));
            }
        }
    }

    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        super.visitEnumConstant(enumConstant);
        if (!this.myHolder.hasErrorResults()) {
            GenericsHighlightUtil.checkEnumConstantForConstructorProblems(enumConstant, this.myHolder);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.registerConstructorCall((PsiConstructorCall)enumConstant);
        }
    }

    public void visitEnumConstantInitializer(PsiEnumConstantInitializer enumConstantInitializer) {
        super.visitEnumConstantInitializer(enumConstantInitializer);
        if (!this.myHolder.hasErrorResults()) {
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)enumConstantInitializer);
            this.myHolder.add(HighlightClassUtil.checkClassMustBeAbstract((PsiClass)enumConstantInitializer, textRange));
        }
    }

    public void visitExpression(PsiExpression expression) {
        ProgressManager.checkCanceled();
        super.visitExpression(expression);
        if (this.myHolder.add(HighlightUtil.checkMustBeBoolean(expression))) {
            return;
        }
        if (expression instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)expression).getIndexExpression() != null) {
            this.myHolder.add(HighlightUtil.checkValidArrayAccessExpression(((PsiArrayAccessExpression)expression).getArrayExpression(), ((PsiArrayAccessExpression)expression).getIndexExpression()));
        }
        if (expression.getParent() instanceof PsiNewExpression && ((PsiNewExpression)expression.getParent()).getQualifier() != expression && ((PsiNewExpression)expression.getParent()).getArrayInitializer() != expression) {
            this.myHolder.add(HighlightUtil.checkValidArrayAccessExpression(null, expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkCannotWriteToFinal(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkVariableExpected(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            HighlightUtil.checkArrayInitalizer(expression, this.myHolder);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkTernaryOperatorConditionIsBoolean(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssertOperatorTypes(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSynchronizedExpressionType(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkConditionalExpressionBranchTypesMatch(expression));
        }
        if (!this.myHolder.hasErrorResults() && expression.getParent() instanceof PsiThrowStatement && ((PsiThrowStatement)expression.getParent()).getException() == expression) {
            PsiType type = expression.getType();
            this.myHolder.add(HighlightUtil.checkMustBeThrowable(type, (PsiElement)expression, true));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkConstantExpression(expression));
        }
    }

    public void visitField(PsiField field) {
        super.visitField(field);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkFinalFieldInitialized(field));
        }
    }

    public void visitForeachStatement(PsiForeachStatement statement) {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)statement)) {
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, statement.getFirstChild(), JavaErrorMessages.message("foreach.prior.15", new Object[0]));
            QuickFixAction.registerQuickFixAction(info, new IncreaseLanguageLevelFix(LanguageLevel.JDK_1_5));
            this.myHolder.add(info);
        }
    }

    public void visitImportStaticStatement(PsiImportStaticStatement statement) {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)statement)) {
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, statement.getFirstChild(), JavaErrorMessages.message("static.imports.prior.15", new Object[0]));
            QuickFixAction.registerQuickFixAction(info, new IncreaseLanguageLevelFix(LanguageLevel.JDK_1_5));
            this.myHolder.add(info);
        }
    }

    public void visitIdentifier(PsiIdentifier identifier) {
        PsiMethod method;
        PsiElement parent = identifier.getParent();
        if (parent instanceof PsiVariable) {
            this.myHolder.add(HighlightUtil.checkVariableAlreadyDefined((PsiVariable)parent));
        } else if (parent instanceof PsiClass) {
            this.myHolder.add(HighlightClassUtil.checkClassAlreadyImported((PsiClass)parent, (PsiElement)identifier));
            this.myHolder.add(HighlightClassUtil.checkExternalizableHasPublicNoArgsConstructor((PsiClass)parent, (PsiElement)identifier));
            if (!(parent instanceof PsiAnonymousClass)) {
                this.myHolder.add(HighlightNamesUtil.highlightClassName((PsiClass)parent, (PsiElement)((PsiClass)parent).getNameIdentifier()));
            }
        } else if (parent instanceof PsiMethod && (method = (PsiMethod)parent).isConstructor()) {
            this.myHolder.add(HighlightMethodUtil.checkConstructorName(method));
        }
        super.visitIdentifier(identifier);
    }

    public void visitImportStatement(PsiImportStatement statement) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSingleImportClassConflict(statement, this.mySingleImportedClasses));
        }
    }

    public void visitImportStaticReferenceElement(PsiImportStaticReferenceElement ref) {
        String refName = ref.getReferenceName();
        JavaResolveResult[] results = ref.multiResolve(false);
        if (results.length == 0) {
            String description = JavaErrorMessages.message("cannot.resolve.symbol", refName);
            HighlightInfo info = HighlightInfo.createHighlightInfo(HighlightInfoType.WRONG_REF, ref.getReferenceNameElement(), description);
            this.myHolder.add(info);
            QuickFixAction.registerQuickFixAction(info, SetupJDKFix.getInstnace());
        } else {
            PsiManager manager = ref.getManager();
            for (JavaResolveResult result : results) {
                Pair<PsiImportStatementBase, PsiClass> imported;
                PsiElement element = result.getElement();
                if (!(element instanceof PsiModifierListOwner) || !((PsiModifierListOwner)element).hasModifierProperty("static")) continue;
                String messageKey = null;
                if (element instanceof PsiClass) {
                    imported = this.mySingleImportedClasses.get(refName);
                    PsiClass aClass = imported == null ? null : (PsiClass)imported.getSecond();
                    PsiImportStaticStatement statement = (PsiImportStaticStatement)ref.getParent();
                    if (aClass != null && !manager.areElementsEquivalent((PsiElement)aClass, element) && !((PsiImportStatementBase)imported.getFirst()).equals(statement)) {
                        messageKey = "class.is.already.defined.in.single.type.import";
                    }
                    this.mySingleImportedClasses.put(refName, (Pair<PsiImportStatementBase, PsiClass>)Pair.create((Object)statement, (Object)((PsiClass)element)));
                } else if (element instanceof PsiField) {
                    PsiField field;
                    imported = this.mySingleImportedFields.get(refName);
                    PsiField psiField = field = imported == null ? null : (PsiField)imported.getSecond();
                    if (field != null && !manager.areElementsEquivalent((PsiElement)field, element) && !((PsiImportStaticReferenceElement)imported.getFirst()).equals(ref.getParent())) {
                        messageKey = "field.is.already.defined.in.single.type.import";
                    }
                    this.mySingleImportedFields.put(refName, (Pair<PsiImportStaticReferenceElement, PsiField>)Pair.create((Object)ref, (Object)((PsiField)element)));
                }
                if (messageKey == null) continue;
                String description = JavaErrorMessages.message(messageKey, refName);
                this.myHolder.add(HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)ref, description));
            }
        }
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
        super.visitInstanceOfExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkInstanceOfApplicable(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkInstanceOfGenericType(expression));
        }
    }

    public void visitKeyword(PsiKeyword keyword) {
        super.visitKeyword(keyword);
        PsiElement parent = keyword.getParent();
        if (parent instanceof PsiModifierList) {
            PsiModifierList psiModifierList = (PsiModifierList)parent;
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkNotAllowedModifier(keyword, psiModifierList));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkIllegalModifierCombination(keyword, psiModifierList));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkPublicClassInRightFile(keyword, psiModifierList));
            }
            if ("abstract".equals(keyword.getText()) && psiModifierList.getParent() instanceof PsiMethod && !this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkAbstractMethodInConcreteClass((PsiMethod)psiModifierList.getParent(), (PsiElement)keyword));
            }
        } else if (keyword.getText().equals("continue") && parent instanceof PsiContinueStatement) {
            PsiContinueStatement statement = (PsiContinueStatement)parent;
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkContinueOutsideLoop(statement));
            }
        } else if (keyword.getText().equals("break") && parent instanceof PsiBreakStatement) {
            PsiBreakStatement statement = (PsiBreakStatement)parent;
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkBreakOutsideLoop(statement));
            }
        } else if ("interface".equals(keyword.getText()) && parent instanceof PsiClass && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkInterfaceCannotBeLocal((PsiClass)parent));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkStaticDeclarationInInnerClass(keyword));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkIllegalVoidType(keyword));
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)keyword, PsiDocTagValue.class) != null) {
            this.myHolder.add(HighlightInfo.createHighlightInfo(HighlightInfoType.JAVA_KEYWORD, (PsiElement)keyword, null));
        }
    }

    public void visitLabeledStatement(PsiLabeledStatement statement) {
        super.visitLabeledStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelWithoutStatement(statement));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelAlreadyInUse(statement));
        }
    }

    public void visitLiteralExpression(PsiLiteralExpression expression) {
        super.visitLiteralExpression(expression);
        if (this.myHolder.hasErrorResults()) {
            return;
        }
        this.myHolder.add(HighlightUtil.checkLiteralExpressionParsingError(expression));
        if (this.myRefCountHolder != null && !this.myHolder.hasErrorResults()) {
            this.registerReferencesFromInjectedFragments((PsiElement)expression);
        }
    }

    public void visitMethod(PsiMethod method) {
        super.visitMethod(method);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement(method.getBody()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkConstructorHandleSuperClassExceptions(method));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkRecursiveConstructorInvocation(method));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkOverrideAnnotation(method));
        }
        if (!this.myHolder.hasErrorResults() && method.isConstructor()) {
            this.myHolder.add(HighlightClassUtil.checkThingNotAllowedInInterface((PsiElement)method, method.getContainingClass()));
        }
        this.myHolder.add(HighlightNamesUtil.highlightMethodName(method, (PsiElement)method.getNameIdentifier(), true));
    }

    private void highlightMethodOrClassName(PsiJavaCodeReferenceElement element) {
        block13: {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiReferenceExpression || parent instanceof PsiJavaCodeReferenceElement) {
                return;
            }
            if (parent instanceof PsiMethodCallExpression) {
                PsiMethod method = ((PsiMethodCallExpression)parent).resolveMethod();
                PsiElement methodNameElement = element.getReferenceNameElement();
                if (method != null && methodNameElement != null) {
                    this.myHolder.add(HighlightNamesUtil.highlightMethodName(method, methodNameElement, false));
                    this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier(element));
                }
            } else if (parent instanceof PsiConstructorCall) {
                try {
                    PsiMethod method = ((PsiConstructorCall)parent).resolveConstructor();
                    if (method == null) {
                        PsiElement resolved = element.resolve();
                        if (resolved instanceof PsiClass) {
                            this.myHolder.add(HighlightNamesUtil.highlightClassName((PsiClass)resolved, (PsiElement)element));
                        }
                        break block13;
                    }
                    this.myHolder.add(HighlightNamesUtil.highlightMethodName(method, (PsiElement)element, false));
                }
                catch (IndexNotReadyException ignored) {}
            } else if (parent instanceof PsiImportStatement && ((PsiImportStatement)parent).isOnDemand()) {
                this.myHolder.add(HighlightNamesUtil.highlightClassName(null, (PsiElement)element));
            } else {
                PsiElement resolved = element.resolve();
                if (resolved instanceof PsiClass) {
                    this.myHolder.add(HighlightNamesUtil.highlightClassName((PsiClass)resolved, (PsiElement)element));
                }
            }
        }
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumSuperConstructorCall(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkSuperQualifierType(expression));
        }
        if (expression.getMethodExpression().isPhysical() && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkMethodCall(expression, this.myResolveHelper));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)expression);
        }
    }

    public void visitModifierList(PsiModifierList list) {
        super.visitModifierList(list);
        PsiElement parent = list.getParent();
        if (!this.myHolder.hasErrorResults() && parent instanceof PsiMethod) {
            this.myHolder.add(HighlightMethodUtil.checkMethodCanHaveBody((PsiMethod)parent));
        }
        if (parent instanceof PsiMethod) {
            List superMethodSignatures;
            PsiMethod method = (PsiMethod)parent;
            MethodSignatureBackedByPsiMethod methodSignature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (!method.isConstructor() && !(superMethodSignatures = method.getHierarchicalMethodSignature().getSuperSignatures()).isEmpty()) {
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightMethodUtil.checkMethodIncompatibleReturnType(methodSignature, superMethodSignatures, true));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightMethodUtil.checkMethodIncompatibleThrows(methodSignature, superMethodSignatures, true, method.getContainingClass()));
                }
                if (!method.hasModifierProperty("static")) {
                    if (!this.myHolder.hasErrorResults()) {
                        this.myHolder.add(HighlightMethodUtil.checkMethodWeakerPrivileges(methodSignature, superMethodSignatures, true));
                    }
                    if (!this.myHolder.hasErrorResults()) {
                        this.myHolder.add(GenericsHighlightUtil.checkUncheckedOverriding(method, superMethodSignatures));
                    }
                    if (!this.myHolder.hasErrorResults()) {
                        this.myHolder.add(HighlightMethodUtil.checkMethodOverridesFinal(methodSignature, superMethodSignatures));
                    }
                }
            }
            PsiClass aClass = method.getContainingClass();
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkMethodMustHaveBody(method, aClass));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkDuplicateMethod(aClass, method));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkConstructorCallsBaseClassConstructor(method, this.myRefCountHolder, this.myResolveHelper));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkStaticMethodOverride(method));
            }
        } else if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkDuplicateNestedClass(aClass));
            }
            if (!this.myHolder.hasErrorResults()) {
                TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
                this.myHolder.add(HighlightClassUtil.checkClassMustBeAbstract(aClass, textRange));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkClassDoesNotCallSuperConstructorOrHandleExceptions(aClass, this.myRefCountHolder, this.myResolveHelper));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkOverrideEquivalentInheritedMethods(aClass));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkCyclicInheritance(aClass));
            }
        } else if (parent instanceof PsiEnumConstant && !this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(GenericsHighlightUtil.checkEnumConstantModifierList(list));
        }
    }

    public void visitNameValuePair(PsiNameValuePair pair) {
        PsiIdentifier nameId;
        this.myHolder.add(AnnotationsHighlightUtil.checkNameValuePair(pair));
        if (!this.myHolder.hasErrorResults() && (nameId = pair.getNameIdentifier()) != null) {
            this.myHolder.add(HighlightInfo.createHighlightInfo(HighlightInfoType.ANNOTATION_ATTRIBUTE_NAME, (PsiElement)nameId, null));
        }
    }

    public void visitNewExpression(PsiNewExpression expression) {
        this.myHolder.add(HighlightUtil.checkUnhandledExceptions((PsiElement)expression, null));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkAnonymousInheritFinal(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkQualifiedNewOfStaticClass(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkCreateInnerClassFromStaticContext(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkTypeParameterInstantiation(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            HighlightMethodUtil.checkNewExpression(expression, this.myHolder);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumInstantiation(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkGenericArrayCreation((PsiElement)expression, expression.getType()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.registerConstructorCall((PsiConstructorCall)expression);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)expression);
        }
    }

    public void visitOuterLanguageElement(OuterLanguageElement element) {
        XmlHighlightVisitor.visitJspElement(element);
        super.visitOuterLanguageElement(element);
    }

    public void visitPackageStatement(PsiPackageStatement statement) {
        super.visitPackageStatement(statement);
        this.myHolder.add(AnnotationsHighlightUtil.checkPackageAnnotationContainingFile(statement));
    }

    public void visitParameter(PsiParameter parameter) {
        super.visitParameter(parameter);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkVarArgParameterIsLast(parameter));
        }
        if (!this.myHolder.hasErrorResults() && parameter.getParent() instanceof PsiForeachStatement) {
            this.myHolder.add(GenericsHighlightUtil.checkForeachLoopParameterType((PsiForeachStatement)parameter.getParent()));
        }
    }

    public void visitParameterList(PsiParameterList list) {
        PsiElement parent = list.getParent();
        if (parent instanceof PsiAnnotationMethod && list.getParametersCount() > 0) {
            this.myHolder.add(HighlightInfo.createHighlightInfo(HighlightInfoType.ERROR, (PsiElement)list, JavaErrorMessages.message("annotation.interface.members.may.not.have.parameters", new Object[0])));
        }
    }

    public void visitPostfixExpression(PsiPostfixExpression expression) {
        super.visitPostfixExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnaryOperatorApplicable(expression.getOperationSign(), expression.getOperand()));
        }
    }

    public void visitPrefixExpression(PsiPrefixExpression expression) {
        super.visitPrefixExpression(expression);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnaryOperatorApplicable(expression.getOperationSign(), expression.getOperand()));
        }
    }

    private void registerConstructorCall(PsiConstructorCall constructorCall) {
        JavaResolveResult resolveResult;
        PsiElement resolved;
        if (this.myRefCountHolder != null && (resolved = (resolveResult = constructorCall.resolveMethodGenerics()).getElement()) instanceof PsiNamedElement) {
            this.myRefCountHolder.registerLocallyReferenced((PsiNamedElement)resolved);
        }
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement ref) {
        JavaResolveResult result;
        try {
            result = ref.advancedResolve(true);
        }
        catch (IndexNotReadyException e) {
            return;
        }
        PsiElement resolved = result.getElement();
        PsiElement parent = ref.getParent();
        if (this.myRefCountHolder != null) {
            this.myRefCountHolder.registerReference((PsiJavaReference)ref, result);
        }
        this.myHolder.add(HighlightUtil.checkReference(ref, result, resolved));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkAbstractInstantiation(ref));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkExtendsDuplicate(ref, resolved));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkExceptionAlreadyCaught(ref, resolved));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkClassExtendsForeignInnerClass(ref, resolved));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkSelectStaticClassFromParameterizedType(resolved, ref));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, ref, result.getSubstitutor()));
        }
        if (resolved != null && parent instanceof PsiReferenceList && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkElementInReferenceList(ref, (PsiReferenceList)parent, result));
        }
        if (parent instanceof PsiAnonymousClass && ref.equals(((PsiAnonymousClass)parent).getBaseClassReference())) {
            this.myHolder.add(GenericsHighlightUtil.checkOverrideEquivalentMethods((PsiClass)parent));
        }
        if (resolved instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)resolved;
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class);
            if (containingClass instanceof PsiAnonymousClass && !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)variable, (boolean)false) && !(variable instanceof PsiField) && !PsiTreeUtil.isAncestor((PsiElement)((PsiAnonymousClass)containingClass).getArgumentList(), (PsiElement)ref, (boolean)false)) {
                this.myHolder.add(HighlightInfo.createHighlightInfo(HighlightInfoType.IMPLICIT_ANONYMOUS_CLASS_PARAMETER, (PsiElement)ref, null));
            }
            if (!variable.hasModifierProperty("final") && this.isReassigned(variable)) {
                this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable(variable, (PsiElement)ref));
            } else {
                this.myHolder.add(HighlightNamesUtil.highlightVariable(variable, ref.getReferenceNameElement()));
            }
            this.myHolder.add(HighlightNamesUtil.highlightClassNameInQualifier(ref));
        } else {
            this.highlightMethodOrClassName(ref);
        }
    }

    public void visitReferenceExpression(PsiReferenceExpression expression) {
        JavaResolveResult result;
        this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)expression);
            if (this.myHolder.hasErrorResults()) {
                return;
            }
        }
        try {
            result = expression.advancedResolve(false);
        }
        catch (IndexNotReadyException e) {
            return;
        }
        PsiElement resolved = result.getElement();
        if (resolved instanceof PsiVariable && resolved.getContainingFile() == expression.getContainingFile()) {
            PsiVariable variable;
            boolean isFinal;
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(expression, (PsiVariable)resolved, this.myUninitializedVarProblems));
            }
            if ((isFinal = (variable = (PsiVariable)resolved).hasModifierProperty("final")) && !variable.hasInitializer()) {
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightControlFlowUtil.checkFinalVariableMightAlreadyHaveBeenAssignedTo(variable, expression, this.myFinalVarProblems));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightControlFlowUtil.checkFinalVariableInitalizedInLoop(expression, resolved));
                }
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkExpressionRequired(expression));
        }
        if (!this.myHolder.hasErrorResults() && resolved instanceof PsiField) {
            this.myHolder.add(HighlightUtil.checkIllegalForwardReferenceToField(expression, (PsiField)resolved));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkConstructorCallMustBeFirstStatement(expression));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkAccessStaticFieldFromEnumConstructor(expression, result));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkClassReferenceAfterQualifier(expression, resolved));
        }
    }

    public void visitReferenceList(PsiReferenceList list) {
        if (list.getFirstChild() == null) {
            return;
        }
        PsiElement parent = list.getParent();
        if (!(parent instanceof PsiTypeParameter)) {
            this.myHolder.add(AnnotationsHighlightUtil.checkAnnotationDeclaration(parent, list));
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkImplementsAllowed(list));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkClassExtendsOnlyOneClass(list));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkGenericCannotExtendException(list));
            }
        }
    }

    public void visitReferenceParameterList(PsiReferenceParameterList list) {
        this.myHolder.add(GenericsHighlightUtil.checkParametersOnRaw(list));
    }

    public void visitReturnStatement(PsiReturnStatement statement) {
        this.myHolder.add(HighlightUtil.checkReturnStatementType(statement));
    }

    public void visitStatement(PsiStatement statement) {
        super.visitStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkNotAStatement(statement));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkStatementPrependedWithCaseInsideSwitch(statement));
        }
    }

    public void visitSuperExpression(PsiSuperExpression expr) {
        this.myHolder.add(HighlightUtil.checkThisOrSuperExpressionInIllegalContext((PsiExpression)expr, expr.getQualifier()));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkAbstractMethodDirectCall(expr));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)expr);
        }
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        super.visitSwitchLabelStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkCaseStatement(statement));
        }
    }

    public void visitSwitchStatement(PsiSwitchStatement statement) {
        super.visitSwitchStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSwitchSelectorType(statement));
        }
    }

    public void visitThisExpression(PsiThisExpression expr) {
        this.myHolder.add(HighlightUtil.checkThisOrSuperExpressionInIllegalContext((PsiExpression)expr, expr.getQualifier()));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkMemberReferencedBeforeConstructorCalled((PsiElement)expr));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)expr);
        }
    }

    public void visitThrowStatement(PsiThrowStatement statement) {
        this.myHolder.add(HighlightUtil.checkUnhandledExceptions((PsiElement)statement, null));
        if (!this.myHolder.hasErrorResults()) {
            this.visitStatement((PsiStatement)statement);
        }
    }

    public void visitTryStatement(PsiTryStatement statement) {
        super.visitTryStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            PsiParameter[] parameters;
            for (PsiParameter parameter : parameters = statement.getCatchBlockParameters()) {
                this.myHolder.add(HighlightUtil.checkExceptionThrownInTry(parameter));
                this.myHolder.add(HighlightUtil.checkCatchParameterIsThrowable(parameter));
                this.myHolder.add(GenericsHighlightUtil.checkCatchParameterIsClass(parameter));
            }
        }
    }

    public void visitTypeElement(PsiTypeElement type) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkIllegalType(type));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkReferenceTypeUsedAsTypeArgument(type));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkWildcardUsage(type));
        }
    }

    public void visitTypeCastExpression(PsiTypeCastExpression typeCast) {
        super.visitTypeCastExpression(typeCast);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkInconvertibleTypeCast(typeCast));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkUncheckedTypeCast(typeCast));
        }
    }

    public void visitTypeParameterList(PsiTypeParameterList list) {
        this.myHolder.add(GenericsHighlightUtil.checkTypeParametersList(list));
    }

    public void visitVariable(PsiVariable variable) {
        super.visitVariable(variable);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkVariableInitializerType(variable));
        }
        if (this.isReassigned(variable)) {
            this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable(variable, (PsiElement)variable.getNameIdentifier()));
        } else {
            PsiElement child;
            if (variable.getInitializer() == null && (child = variable.getLastChild()) instanceof PsiErrorElement && child.getPrevSibling() == variable.getNameIdentifier()) {
                return;
            }
            this.myHolder.add(HighlightNamesUtil.highlightVariable(variable, (PsiElement)variable.getNameIdentifier()));
        }
    }

    private boolean isReassigned(PsiVariable variable) {
        try {
            return HighlightControlFlowUtil.isReassigned(variable, this.myFinalVarProblems, this.myParameterIsReassigned);
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }
}

