/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WholeFileLocalInspectionsPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    private final Map<PsiFile, Boolean> myFileTools = new ConcurrentWeakHashMap();
    public InspectionProjectProfileManager myProfileManager;

    public WholeFileLocalInspectionsPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar, InspectionProjectProfileManager profileManager) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{7}, true, -1);
        this.myProfileManager = profileManager;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("WholeFileLocalInspectionsPassFactory" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory.getComponentName must not return null");
        }
        return "WholeFileLocalInspectionsPassFactory";
    }

    public void projectOpened() {
        final ProfileChangeAdapter myProfilesListener = new ProfileChangeAdapter(){

            public void profileChanged(Profile profile) {
                WholeFileLocalInspectionsPassFactory.this.myFileTools.clear();
            }

            public void profileActivated(Profile oldProfile, Profile profile) {
                WholeFileLocalInspectionsPassFactory.this.myFileTools.clear();
            }
        };
        this.myProfileManager.addProfilesListener(myProfilesListener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                WholeFileLocalInspectionsPassFactory.this.myProfileManager.removeProfilesListener(myProfilesListener);
                WholeFileLocalInspectionsPassFactory.this.myFileTools.clear();
            }
        });
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(final @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory.createHighlightingPass must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory.createHighlightingPass must not be null");
        }
        TextRange textRange = FileStatusMap.getDirtyTextRange(editor, 7);
        if (textRange == null || this.myFileTools.containsKey(file) && !this.myFileTools.get(file).booleanValue()) {
            return null;
        }
        return new LocalInspectionsPass(file, editor.getDocument(), 0, file.getTextLength()){

            @Override
            List<LocalInspectionTool> getInspectionTools(InspectionProfileWrapper profile) {
                List<LocalInspectionTool> tools = super.getInspectionTools(profile);
                ArrayList<LocalInspectionTool> result = new ArrayList<LocalInspectionTool>();
                for (LocalInspectionTool tool : tools) {
                    if (!tool.runForWholeFile()) continue;
                    result.add(tool);
                }
                WholeFileLocalInspectionsPassFactory.this.myFileTools.put(file, !result.isEmpty());
                return result;
            }

            @Override
            void inspectInjectedPsi(PsiElement[] elements, List<LocalInspectionTool> tools) {
            }
        };
    }
}

