/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.ExternalToolPass;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalToolPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public ExternalToolPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{5}, null, true, 8);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ExternalToolPassFactory" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/ExternalToolPassFactory.getComponentName must not return null");
        }
        return "ExternalToolPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ExternalToolPassFactory.createHighlightingPass must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/ExternalToolPassFactory.createHighlightingPass must not be null");
        }
        TextRange textRange = FileStatusMap.getDirtyTextRange(editor, 8);
        if (textRange == null || !ExternalToolPassFactory.externalAnnotatorsDefined(file)) {
            return null;
        }
        return new ExternalToolPass(file, editor, textRange.getStartOffset(), textRange.getEndOffset());
    }

    private static boolean externalAnnotatorsDefined(PsiFile file) {
        for (Language language : file.getViewProvider().getLanguages()) {
            List externalAnnotators = ExternalLanguageAnnotators.INSTANCE.allForLanguage(language);
            if (externalAnnotators.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

