/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="DaemonCodeAnalyzerSettings", storages={@Storage(id="other", file="$APP_CONFIG$/editor.codeinsight.xml")})
public class DaemonCodeAnalyzerSettings
implements PersistentStateComponent<Element>,
Cloneable,
ExportableComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings");
    @NonNls
    private static final String ROOT_TAG = "root";
    @NonNls
    private static final String PROFILE_ATT = "profile";
    @NonNls
    public static final String DEFAULT_PROFILE_ATT = "Default";
    @NonNls
    public static final String PROFILE_COPY_NAME = "copy";
    private final InspectionProfileManager myManager;
    public boolean NEXT_ERROR_ACTION_GOES_TO_ERRORS_FIRST = false;
    public int AUTOREPARSE_DELAY = 300;
    public boolean SHOW_ADD_IMPORT_HINTS = true;
    @NonNls
    public String NO_AUTO_IMPORT_PATTERN = "[a-z].?";
    public boolean SUPPRESS_WARNINGS = true;
    public boolean SHOW_METHOD_SEPARATORS = false;
    public int ERROR_STRIPE_MARK_MIN_HEIGHT = 3;
    public boolean SHOW_SMALL_ICONS_IN_GUTTER = true;

    public DaemonCodeAnalyzerSettings(InspectionProfileManager manager) {
        this.myManager = manager;
    }

    public static DaemonCodeAnalyzerSettings getInstance() {
        return (DaemonCodeAnalyzerSettings)ServiceManager.getService(DaemonCodeAnalyzerSettings.class);
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)"editor.codeinsight")};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/DaemonCodeAnalyzerSettings.getExportFiles must not return null");
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = DaemonBundle.message((String)"error.highlighting.settings", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/DaemonCodeAnalyzerSettings.getPresentableName must not return null");
        }
        return string;
    }

    public boolean isCodeHighlightingChanged(DaemonCodeAnalyzerSettings oldSettings) {
        try {
            Element rootNew = new Element(ROOT_TAG);
            this.writeExternal(rootNew);
            Element rootOld = new Element(ROOT_TAG);
            oldSettings.writeExternal(rootOld);
            return !JDOMUtil.areElementsEqual((Element)rootOld, (Element)rootNew);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public Object clone() {
        DaemonCodeAnalyzerSettings settings = new DaemonCodeAnalyzerSettings(this.myManager);
        settings.AUTOREPARSE_DELAY = this.AUTOREPARSE_DELAY;
        settings.SHOW_ADD_IMPORT_HINTS = this.SHOW_ADD_IMPORT_HINTS;
        settings.SHOW_METHOD_SEPARATORS = this.SHOW_METHOD_SEPARATORS;
        settings.NO_AUTO_IMPORT_PATTERN = this.NO_AUTO_IMPORT_PATTERN;
        settings.SHOW_SMALL_ICONS_IN_GUTTER = this.SHOW_SMALL_ICONS_IN_GUTTER;
        return settings;
    }

    public Element getState() {
        Element e = new Element("state");
        try {
            this.writeExternal(e);
        }
        catch (WriteExternalException ex) {
            LOG.error((Throwable)ex);
        }
        return e;
    }

    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.myManager.getConverter().storeEditorHighlightingProfile(element);
        this.myManager.setRootProfile(element.getAttributeValue(PROFILE_ATT));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        element.setAttribute(PROFILE_ATT, this.myManager.getRootProfile().getName());
    }

    public boolean isImportHintEnabled() {
        return this.SHOW_ADD_IMPORT_HINTS;
    }

    public void setImportHintEnabled(boolean isImportHintEnabled) {
        this.SHOW_ADD_IMPORT_HINTS = isImportHintEnabled;
    }
}

