/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.scope;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;

public class CompletionElement {
    private final PsiType myQualifier;
    private final PsiClass myQualifierClass;
    private final Object myElement;
    private final PsiSubstitutor mySubstitutor;

    public CompletionElement(PsiType qualifier, Object element, PsiSubstitutor substitutor, PsiClass qualifierClass) {
        this.myElement = element;
        this.myQualifier = qualifier;
        this.mySubstitutor = substitutor;
        this.myQualifierClass = qualifierClass;
    }

    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    public Object getElement() {
        return this.myElement;
    }

    public Object getUniqueId() {
        String name;
        if (this.myElement instanceof PsiClass) {
            name = ((PsiClass)this.myElement).getQualifiedName();
        } else if (this.myElement instanceof PsiPackage) {
            name = ((PsiPackage)this.myElement).getQualifiedName();
        } else {
            if (this.myElement instanceof PsiMethod) {
                return ((PsiMethod)this.myElement).getSignature(this.mySubstitutor);
            }
            if (this.myElement instanceof PsiField) {
                PsiField field = (PsiField)this.myElement;
                String s = field.getName();
                if (this.myQualifierClass != null || !field.hasModifierProperty("static")) {
                    return "#" + s;
                }
                return field.getContainingClass().getQualifiedName() + "#" + s;
            }
            name = this.myElement instanceof PsiElement ? PsiUtil.getName((PsiElement)((PsiElement)this.myElement)) : "";
        }
        return name;
    }

    public PsiType getQualifier() {
        return this.myQualifier;
    }
}

