/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.SmartCastProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartCompletionDecorator
extends TailTypeDecorator<LookupElement> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.SmartCompletionDecorator");
    @NotNull
    private final Collection<ExpectedTypeInfo> myExpectedTypeInfos;
    private PsiElement myPosition;

    public SmartCompletionDecorator(LookupElement item, Collection<ExpectedTypeInfo> expectedTypeInfos) {
        super(item);
        this.myExpectedTypeInfos = expectedTypeInfos;
    }

    @Override
    protected TailType computeTailType(InsertionContext context) {
        TailType defType = LookupItem.getDefaultTailType(context.getCompletionChar());
        if (defType != null) {
            context.setAddCompletionChar(false);
            return defType;
        }
        PsiExpression enclosing = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)this.myPosition, PsiExpression.class, (boolean)true);
        LookupElement item = this.getDelegate();
        if (enclosing != null && item.getObject() instanceof PsiElement) {
            TailType itemType;
            PsiType type = this.getItemType(item);
            TailType cached = itemType = item instanceof LookupItem ? ((LookupItem)item).getTailType() : TailType.NONE;
            int cachedPrior = 0;
            if (type != null && type.isValid()) {
                for (ExpectedTypeInfo info : this.myExpectedTypeInfos) {
                    PsiType infoType = info.getType();
                    if (PsiType.VOID.equals(infoType)) {
                        cached = info.getTailType();
                        continue;
                    }
                    if (infoType.equals(type) && cachedPrior < 2) {
                        cachedPrior = 2;
                        cached = info.getTailType();
                        continue;
                    }
                    if (cachedPrior == 2 && cached != info.getTailType()) {
                        cachedPrior = 3;
                        cached = itemType;
                        continue;
                    }
                    if ((infoType.isAssignableFrom(type) && info.getKind() == 1 || type.isAssignableFrom(infoType) && info.getKind() == 2) && cachedPrior < 1) {
                        cachedPrior = 1;
                        cached = info.getTailType();
                        continue;
                    }
                    if (cachedPrior != 1 || cached == info.getTailType()) continue;
                    cached = itemType;
                }
            } else if (this.myExpectedTypeInfos.size() == 1) {
                cached = this.myExpectedTypeInfos.iterator().next().getTailType();
            }
            return cached;
        }
        return null;
    }

    @Nullable
    private PsiType getItemType(LookupElement element) {
        return JavaCompletionUtil.getLookupElementType(element);
    }

    @Override
    public void handleInsert(InsertionContext context) {
        this.myPosition = SmartCompletionDecorator.getPosition(context, (LookupElement)this);
        if (this.getDelegate() instanceof LookupItem) {
            SmartCompletionDecorator.analyzeItem(context, (LookupItem)this.getDelegate(), this.getObject(), this.myPosition, this.myExpectedTypeInfos);
        }
        super.handleInsert(context);
    }

    private static void analyzeItem(InsertionContext context, LookupItem item, Object completion, @Nullable PsiElement position, @NotNull Collection<ExpectedTypeInfo> expectedTypes) {
        PsiAnonymousClass anonymousClass;
        if (expectedTypes == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/completion/SmartCompletionDecorator.analyzeItem must not be null");
        }
        if (position == null) {
            return;
        }
        PsiFile file = position.getContainingFile();
        int startOffset = position.getTextRange().getStartOffset();
        PsiReference ref = position.getContainingFile().findReferenceAt(startOffset);
        if (ref != null && completion instanceof PsiNamedElement && (completion instanceof PsiMethod || completion instanceof PsiField)) {
            PsiClass containingClass;
            PsiMember member = (PsiMember)completion;
            if (item.getAttribute(LookupItem.FORCE_QUALIFY) != null && member.hasModifierProperty("static") && PsiUtil.isAccessible((PsiMember)member, (PsiElement)position, null) && (containingClass = member.getContainingClass()) != null) {
                String refText = ref.getElement().getText();
                Document document = context.getEditor().getDocument();
                document.insertString(context.getEditor().getCaretModel().getOffset(), (CharSequence)" ");
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
                psiDocumentManager.commitDocument(document);
                LOG.assertTrue(!psiDocumentManager.isUncommited(psiDocumentManager.getDocument(file)));
                final PsiReference finalRef = file.findReferenceAt(startOffset);
                if (finalRef == null) {
                    String text = document.getText();
                    LOG.error("startOffset=" + startOffset + "\n" + "caretOffset=" + context.getEditor().getCaretModel().getOffset() + "\n" + "ref.getText()=" + refText + "\n" + "file=" + file + "\n" + "documentPart=" + text.substring(Math.max(startOffset - 100, 0), Math.min(startOffset + 100, text.length())));
                }
                String name = member.getName();
                assert (name != null);
                PsiElement psiElement = (PsiElement)file.getManager().performActionWithFormatterDisabled((Computable)new Computable<PsiElement>(){

                    public PsiElement compute() {
                        try {
                            return finalRef.bindToElement((PsiElement)containingClass);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                            return null;
                        }
                    }
                });
                PsiElement element = CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement(psiElement);
                int whereToInsert = element.getTextRange().getEndOffset();
                String insertString = "." + name;
                document.insertString(whereToInsert, (CharSequence)insertString);
                int endOffset = whereToInsert + insertString.length();
                context.getEditor().getCaretModel().moveToOffset(endOffset);
                context.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, endOffset);
                context.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, whereToInsert);
                context.getOffsetMap().addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, endOffset);
                item.setLookupString(name);
                document.deleteString(endOffset, endOffset + 1);
            }
        }
        PsiExpression enclosing = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)position, PsiExpression.class, (boolean)true);
        if (item.getObject() instanceof PsiClass && item.getUserData(LookupItem.BRACKETS_COUNT_ATTR) == null && enclosing instanceof PsiNewExpression && !(position instanceof PsiParenthesizedExpression) && item.getUserData(SmartCastProvider.TYPE_CAST) == null && PsiTreeUtil.getContextOfType((PsiElement)position, PsiReferenceParameterList.class, (boolean)false) == null && ((anonymousClass = (PsiAnonymousClass)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnonymousClass.class)) == null || anonymousClass.getParent() != enclosing)) {
            PsiClass psiClass = (PsiClass)item.getObject();
            item.setAttribute(LookupItem.NEW_OBJECT_ATTR, "");
            if (psiClass.hasModifierProperty("abstract") || psiClass.isInterface()) {
                item.setAttribute(LookupItem.GENERATE_ANONYMOUS_BODY_ATTR, "");
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.anonymous");
            } else {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.afternew");
            }
        }
    }

    public static boolean hasUnboundTypeParams(PsiMethod method) {
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        if (typeParameters.length == 0) {
            return false;
        }
        THashSet set = new THashSet(Arrays.asList(typeParameters));
        PsiTypeVisitor<Boolean> typeParamSearcher = new PsiTypeVisitor<Boolean>((Set)set){
            final /* synthetic */ Set val$set;
            {
                this.val$set = set;
            }

            public Boolean visitType(PsiType type) {
                return true;
            }

            public Boolean visitArrayType(PsiArrayType arrayType) {
                return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            }

            public Boolean visitClassType(PsiClassType classType) {
                PsiType[] types;
                PsiClass aClass = classType.resolve();
                if (aClass instanceof PsiTypeParameter && this.val$set.contains(aClass)) {
                    return false;
                }
                for (PsiType psiType : types = classType.getParameters()) {
                    if (((Boolean)psiType.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                    return false;
                }
                return true;
            }

            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                return bound == null || (Boolean)bound.accept((PsiTypeVisitor)this) != false;
            }
        };
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            if (((Boolean)parameter.getType().accept((PsiTypeVisitor)typeParamSearcher)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static PsiSubstitutor calculateMethodReturnTypeSubstitutor(PsiMethod method, PsiType expected) {
        PsiTypeParameter[] typeParameters;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)method.getProject()).getResolveHelper();
        for (PsiTypeParameter typeParameter : typeParameters = method.getTypeParameters()) {
            PsiType substitution = helper.getSubstitutionForTypeParameter(typeParameter, method.getReturnType(), expected, false, PsiUtil.getLanguageLevel((PsiElement)method));
            if (PsiType.NULL.equals(substitution)) {
                substitution = TypeConversionUtil.typeParameterErasure((PsiTypeParameter)typeParameter);
            }
            substitutor = substitutor.put(typeParameter, substitution);
        }
        return substitutor;
    }

    @Nullable
    public static PsiElement getPosition(InsertionContext context, LookupElement element) {
        PsiElement position = context.getFile().findElementAt(context.getStartOffset() + element.getLookupString().length() - 1);
        if (position instanceof PsiJavaToken && ">".equals(position.getText())) {
            return position.getParent().getParent();
        }
        return position;
    }
}

