/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Function;
import com.intellij.util.Icons;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class SameSignatureCallParametersProvider
extends CompletionProvider<CompletionParameters> {
    SameSignatureCallParametersProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/SameSignatureCallParametersProvider.addCompletions must not be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/SameSignatureCallParametersProvider.addCompletions must not be null");
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PsiMethodCallExpression.class);
        assert (methodCall != null);
        PsiReferenceExpression expression = methodCall.getMethodExpression();
        List<Pair<PsiMethod, PsiSubstitutor>> candidates = SameSignatureCallParametersProvider.getSuperMethodCandidates(expression);
        PsiMethod container = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class);
        while (container != null) {
            for (Pair<PsiMethod, PsiSubstitutor> candidate : candidates) {
                if (container.getParameterList().getParametersCount() <= 1 || !SameSignatureCallParametersProvider.isSuperMethod(container, (PsiMethod)candidate.first, (PsiSubstitutor)candidate.second)) continue;
                result.addElement(SameSignatureCallParametersProvider.createParametersLookupElement(container));
                return;
            }
            container = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)container, PsiMethod.class);
        }
    }

    private static LookupElement createParametersLookupElement(PsiMethod method) {
        String lookupString = StringUtil.join((Object[])method.getParameterList().getParameters(), (Function)new Function<PsiParameter, String>(){

            public String fun(PsiParameter psiParameter) {
                return psiParameter.getName();
            }
        }, (String)", ");
        int w = Icons.PARAMETER_ICON.getIconWidth();
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(Icons.PARAMETER_ICON, 0, 2 * w / 5, 0);
        icon.setIcon(Icons.PARAMETER_ICON, 1);
        LookupElementBuilder element = LookupElementBuilder.create((String)lookupString).setIcon((Icon)icon);
        element.putUserData(JavaCompletionUtil.SUPER_METHOD_PARAMETERS, (Object)Boolean.TRUE);
        TailType tail = method.isConstructor() || method.getReturnType() instanceof PsiPrimitiveType ? TailTypes.CALL_RPARENTH_SEMICOLON : TailTypes.CALL_RPARENTH;
        return TailTypeDecorator.withTail(element, tail);
    }

    private static List<Pair<PsiMethod, PsiSubstitutor>> getSuperMethodCandidates(PsiReferenceExpression expression) {
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> candidates = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (JavaResolveResult candidate : expression.multiResolve(true)) {
            PsiClass psiClass;
            PsiElement element = candidate.getElement();
            if (!(element instanceof PsiMethod) || (psiClass = ((PsiMethod)element).getContainingClass()) == null) continue;
            for (Pair overload : psiClass.findMethodsAndTheirSubstitutorsByName(((PsiMethod)element).getName(), true)) {
                if (((PsiMethod)overload.first).hasModifierProperty("abstract")) continue;
                candidates.add((Pair<PsiMethod, PsiSubstitutor>)overload);
            }
            break;
        }
        return candidates;
    }

    private static boolean isSuperMethod(PsiMethod container, PsiMethod callee, PsiSubstitutor substitutor) {
        if (PsiSuperMethodUtil.isSuperMethod((PsiMethod)container, (PsiMethod)callee)) {
            return true;
        }
        PsiParameter[] parameters = container.getParameterList().getParameters();
        PsiParameter[] superParams = callee.getParameterList().getParameters();
        if (superParams.length != parameters.length) {
            return false;
        }
        boolean checkNames = callee.isConstructor();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiParameter superParam = superParams[i];
            if ((!checkNames || Comparing.equal((String)parameter.getName(), (String)superParam.getName())) && Comparing.equal((Object)parameter.getType(), (Object)substitutor.substitute(superParam.getType()))) continue;
            return false;
        }
        return true;
    }
}

