/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.KeywordChooser;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaAwareCompletionData
extends CompletionData {
    @Override
    protected void addLookupItem(Set<LookupElement> set, TailType tailType, @NotNull Object completion, PsiFile file, CompletionVariant variant) {
        if (completion == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/JavaAwareCompletionData.addLookupItem must not be null");
        }
        if (completion instanceof LookupElement && !(completion instanceof LookupItem)) {
            set.add((LookupElement)completion);
            return;
        }
        LookupElement _ret = LookupItemUtil.objectToLookupItem(completion);
        if (_ret == null || !(_ret instanceof LookupItem)) {
            return;
        }
        LookupItem ret = (LookupItem)_ret;
        InsertHandler insertHandler = variant.getInsertHandler();
        if (insertHandler != null && ret.getInsertHandler() == null) {
            ret.setInsertHandler(insertHandler);
            ret.setTailType(TailType.UNKNOWN);
        } else if (tailType != TailType.NONE) {
            ret.setTailType(tailType);
        }
        Map<Object, Object> itemProperties = variant.getItemProperties();
        for (Object key : itemProperties.keySet()) {
            ret.setAttribute(key, itemProperties.get(key));
        }
        set.add((LookupElement)ret);
    }

    @Override
    protected void addKeywords(Set<LookupElement> set, PsiElement position, PrefixMatcher matcher, PsiFile file, CompletionVariant variant, Object comp, TailType tailType) {
        block3: {
            String[] keywords;
            CompletionContext context;
            PsiElementFactory factory;
            block4: {
                Object[] elements;
                block2: {
                    factory = JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory();
                    if (!(comp instanceof String)) break block2;
                    this.addKeyword(factory, set, tailType, comp, matcher, file, variant);
                    break block3;
                }
                context = (CompletionContext)position.getUserData(CompletionContext.COMPLETION_CONTEXT_KEY);
                if (!(comp instanceof ContextGetter)) break block4;
                for (Object element : elements = ((ContextGetter)comp).get(position, context)) {
                    this.addLookupItem(set, tailType, element, file, variant);
                }
                break block3;
            }
            if (!(comp instanceof KeywordChooser)) break block3;
            for (String keyword : keywords = ((KeywordChooser)comp).getKeywords(context, position)) {
                this.addKeyword(factory, set, tailType, keyword, matcher, file, variant);
            }
        }
    }

    private void addKeyword(PsiElementFactory factory, Set<LookupElement> set, TailType tailType, Object comp, PrefixMatcher matcher, PsiFile file, CompletionVariant variant) {
        for (LookupElement item : set) {
            if (!item.getObject().toString().equals(comp.toString())) continue;
            return;
        }
        if (factory == null) {
            this.addLookupItem(set, tailType, comp, file, variant);
        } else {
            try {
                PsiKeyword keyword = factory.createKeyword((String)comp);
                this.addLookupItem(set, tailType, keyword, file, variant);
            }
            catch (IncorrectOperationException e) {
                this.addLookupItem(set, tailType, comp, file, variant);
            }
        }
    }

    public void fillCompletions(CompletionParameters parameters, CompletionResultSet result) {
    }
}

