/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class CollectionsUtilityMethodsProvider
extends CompletionProvider<JavaSmartCompletionParameters> {
    CollectionsUtilityMethodsProvider() {
    }

    public void addCompletions(@NotNull JavaSmartCompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/CollectionsUtilityMethodsProvider.addCompletions must not be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/CollectionsUtilityMethodsProvider.addCompletions must not be null");
        }
        PsiElement element = parameters.getPosition();
        PsiElement parent = element.getParent();
        if (parent instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent).getQualifierExpression() != null) {
            return;
        }
        PsiClass collectionsClass = JavaPsiFacade.getInstance((Project)element.getProject()).findClass("java.util.Collections", element.getResolveScope());
        if (collectionsClass == null) {
            return;
        }
        PsiType type = parameters.getExpectedType();
        PsiType defaultType = parameters.getDefaultType();
        PsiElement pparent = parent.getParent();
        if (parameters.getInvocationCount() > 1 || pparent instanceof PsiReturnStatement || pparent instanceof PsiConditionalExpression && pparent.getParent() instanceof PsiReturnStatement) {
            CollectionsUtilityMethodsProvider.addCollectionMethod(result, type, defaultType, "java.util.List", "emptyList", collectionsClass);
            CollectionsUtilityMethodsProvider.addCollectionMethod(result, type, defaultType, "java.util.Set", "emptySet", collectionsClass);
            CollectionsUtilityMethodsProvider.addCollectionMethod(result, type, defaultType, "java.util.Map", "emptyMap", collectionsClass);
        }
        if (parameters.getInvocationCount() > 1) {
            CollectionsUtilityMethodsProvider.addCollectionMethod(result, type, defaultType, "java.util.List", "singletonList", collectionsClass);
            CollectionsUtilityMethodsProvider.addCollectionMethod(result, type, defaultType, "java.util.Set", "singleton", collectionsClass);
            CollectionsUtilityMethodsProvider.addCollectionMethod(result, type, defaultType, "java.util.Map", "singletonMap", collectionsClass);
            CollectionsUtilityMethodsProvider.addCollectionMethod(result, type, defaultType, "java.util.Collection", "unmodifiableCollection", collectionsClass);
            CollectionsUtilityMethodsProvider.addCollectionMethod(result, type, defaultType, "java.util.List", "unmodifiableList", collectionsClass);
            CollectionsUtilityMethodsProvider.addCollectionMethod(result, type, defaultType, "java.util.Set", "unmodifiableSet", collectionsClass);
            CollectionsUtilityMethodsProvider.addCollectionMethod(result, type, defaultType, "java.util.Map", "unmodifiableMap", collectionsClass);
            CollectionsUtilityMethodsProvider.addCollectionMethod(result, type, defaultType, "java.util.SortedSet", "unmodifiableSortedSet", collectionsClass);
            CollectionsUtilityMethodsProvider.addCollectionMethod(result, type, defaultType, "java.util.SortedMap", "unmodifiableSortedMap", collectionsClass);
        }
    }

    private static void addCollectionMethod(CompletionResultSet result, PsiType expectedType, PsiType defaultType, String baseClassName, @NonNls String method, @NotNull PsiClass collectionsClass) {
        if (collectionsClass == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/codeInsight/completion/CollectionsUtilityMethodsProvider.addCollectionMethod must not be null");
        }
        if (CollectionsUtilityMethodsProvider.isClassType(expectedType, baseClassName) || CollectionsUtilityMethodsProvider.isClassType(expectedType, "java.util.Collection")) {
            CollectionsUtilityMethodsProvider.addMethodItem(result, expectedType, method, collectionsClass);
        } else if (CollectionsUtilityMethodsProvider.isClassType(defaultType, baseClassName) || CollectionsUtilityMethodsProvider.isClassType(defaultType, "java.util.Collection")) {
            CollectionsUtilityMethodsProvider.addMethodItem(result, defaultType, method, collectionsClass);
        }
    }

    private static void addMethodItem(CompletionResultSet result, PsiType expectedType, String methodName, PsiClass containingClass) {
        PsiMethod[] methods = containingClass.findMethodsByName(methodName, false);
        if (methods.length == 0) {
            return;
        }
        PsiMethod method = methods[0];
        JavaMethodCallElement item = new JavaMethodCallElement(method);
        JavaCompletionUtil.qualify(item).setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        item.setInferenceSubstitutor(SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor(method, expectedType));
        result.addElement((LookupElement)item);
    }

    private static boolean isClassType(PsiType type, String className) {
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            return psiClass != null && className.equals(psiClass.getQualifiedName());
        }
        return false;
    }
}

