/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.XmlCompletionContributor;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.util.Consumer;

public class BasicToClassNameDelegator
extends CompletionContributor {
    public void fillCompletionVariants(CompletionParameters parameters, final CompletionResultSet result) {
        CompletionParameters classParams;
        String s;
        boolean isJava;
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        PsiFile file = parameters.getOriginalFile();
        boolean bl = isJava = file.getLanguage() == StdLanguages.JAVA;
        if (!isJava && !(file.getLanguage() instanceof XMLLanguage)) {
            return;
        }
        PsiElement position = parameters.getPosition();
        if (isJava) {
            if (!(position.getParent() instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            if (((PsiJavaCodeReferenceElement)position.getParent()).getQualifier() != null) {
                return;
            }
        }
        if (StringUtil.isEmpty((String)(s = result.getPrefixMatcher().getPrefix())) || !Character.isUpperCase(s.charAt(0))) {
            return;
        }
        final Ref empty = Ref.create((Object)true);
        result.runRemainingContributors(parameters, (Consumer)new Consumer<LookupElement>(){

            public void consume(LookupElement lookupElement) {
                empty.set((Object)false);
                result.addElement(lookupElement);
            }
        });
        int invocationCount = parameters.getInvocationCount();
        int offset = parameters.getOffset();
        if (((Boolean)empty.get()).booleanValue()) {
            classParams = new CompletionParameters(position, file, CompletionType.CLASS_NAME, offset, invocationCount);
        } else if (invocationCount > 1) {
            classParams = new CompletionParameters(position, file, CompletionType.CLASS_NAME, offset, invocationCount - 1);
        } else {
            return;
        }
        CompletionService.getCompletionService().getVariantsFromContributors(classParams, null, (Consumer)new Consumer<LookupElement>(){

            public void consume(LookupElement lookupElement) {
                if (lookupElement instanceof JavaPsiClassReferenceElement) {
                    ((JavaPsiClassReferenceElement)lookupElement).setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                }
                lookupElement.putUserData(XmlCompletionContributor.WORD_COMPLETION_COMPATIBLE, (Object)Boolean.TRUE);
                result.addElement(lookupElement);
            }
        });
    }
}

