/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ReformatCodeProcessor
extends AbstractLayoutCodeProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.ReformatCodeProcessor");
    private final TextRange myRange;
    private static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"progress.text.reformatting.code", (Object[])new Object[0]);
    private static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]);

    public ReformatCodeProcessor(Project project) {
        super(project, COMMAND_NAME, PROGRESS_TEXT);
        this.myRange = null;
    }

    public ReformatCodeProcessor(Project project, Module module) {
        super(project, module, COMMAND_NAME, PROGRESS_TEXT);
        this.myRange = null;
    }

    public ReformatCodeProcessor(Project project, PsiDirectory directory, boolean includeSubdirs) {
        super(project, directory, includeSubdirs, PROGRESS_TEXT, COMMAND_NAME);
        this.myRange = null;
    }

    public ReformatCodeProcessor(Project project, PsiFile file, TextRange range) {
        super(project, file, PROGRESS_TEXT, COMMAND_NAME);
        this.myRange = range;
    }

    public ReformatCodeProcessor(Project project, PsiFile[] files, Runnable postRunnable) {
        super(project, files, PROGRESS_TEXT, COMMAND_NAME, postRunnable);
        this.myRange = null;
    }

    @Override
    @NotNull
    protected Runnable preprocessFile(final PsiFile file) throws IncorrectOperationException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    TextRange range = ReformatCodeProcessor.this.myRange == null ? file.getTextRange() : ReformatCodeProcessor.this.myRange;
                    CodeStyleManager.getInstance((Project)ReformatCodeProcessor.this.myProject).reformatText(file, range.getStartOffset(), range.getEndOffset());
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        if (runnable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/actions/ReformatCodeProcessor.preprocessFile must not return null");
        }
        return runnable;
    }
}

