/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class OptimizeImportsProcessor
extends AbstractLayoutCodeProcessor {
    private static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"progress.text.optimizing.imports", (Object[])new Object[0]);
    private static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.optimize.imports", (Object[])new Object[0]);

    public OptimizeImportsProcessor(Project project) {
        super(project, COMMAND_NAME, PROGRESS_TEXT);
    }

    public OptimizeImportsProcessor(Project project, Module module) {
        super(project, module, COMMAND_NAME, PROGRESS_TEXT);
    }

    public OptimizeImportsProcessor(Project project, PsiDirectory directory, boolean includeSubdirs) {
        super(project, directory, includeSubdirs, PROGRESS_TEXT, COMMAND_NAME);
    }

    public OptimizeImportsProcessor(Project project, PsiFile file) {
        super(project, file, PROGRESS_TEXT, COMMAND_NAME);
    }

    public OptimizeImportsProcessor(Project project, PsiFile[] files, Runnable postRunnable) {
        super(project, files, PROGRESS_TEXT, COMMAND_NAME, postRunnable);
    }

    @Override
    @NotNull
    protected Runnable preprocessFile(PsiFile file) throws IncorrectOperationException {
        ImportOptimizer optimizer = LanguageImportStatements.INSTANCE.forFile(file);
        Runnable runnable = optimizer != null ? optimizer.processFile(file) : EmptyRunnable.getInstance();
        if (runnable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/actions/OptimizeImportsProcessor.preprocessFile must not return null");
        }
        return runnable;
    }
}

