/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.Nls;

public class EditorSmartKeysConfigurable
extends CompositeConfigurable<UnnamedConfigurable>
implements EditorOptionsProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.editor.EditorSmartKeysConfigurable");
    public static final ExtensionPointName<UnnamedConfigurable> EP_NAME = ExtensionPointName.create((String)"com.intellij.editorSmartKeysConfigurable");
    private JCheckBox myCbSmartHome;
    private JCheckBox myCbSmartEnd;
    private JCheckBox myCbInsertPairBracket;
    private JCheckBox myCbInsertPairQuote;
    private JCheckBox myCbCamelWords;
    private JCheckBox myCbSmartIndentOnEnter;
    private JComboBox myReformatOnPasteCombo;
    private JPanel myRootPanel;
    private JPanel myAddonPanel;
    private JCheckBox myCbInsertPairCurlyBraceOnEnter;
    private JCheckBox myCbInsertJavadocStubOnEnter;
    private static final String NO_REFORMAT = ApplicationBundle.message((String)"combobox.paste.reformat.none", (Object[])new Object[0]);
    private static final String INDENT_BLOCK = ApplicationBundle.message((String)"combobox.paste.reformat.indent.block", (Object[])new Object[0]);
    private static final String INDENT_EACH_LINE = ApplicationBundle.message((String)"combobox.paste.reformat.indent.each.line", (Object[])new Object[0]);
    private static final String REFORMAT_BLOCK = ApplicationBundle.message((String)"combobox.paste.reformat.reformat.block", (Object[])new Object[0]);

    public EditorSmartKeysConfigurable() {
        this.$$$setupUI$$$();
        this.myReformatOnPasteCombo.addItem(NO_REFORMAT);
        this.myReformatOnPasteCombo.addItem(INDENT_BLOCK);
        this.myReformatOnPasteCombo.addItem(INDENT_EACH_LINE);
        this.myReformatOnPasteCombo.addItem(REFORMAT_BLOCK);
        this.myCbInsertJavadocStubOnEnter.setVisible(EditorSmartKeysConfigurable.hasAnyDocAwareCommenters());
    }

    private static boolean hasAnyDocAwareCommenters() {
        Collection languages = Language.getRegisteredLanguages();
        for (Language language : languages) {
            CodeDocumentationAwareCommenter docCommenter;
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
            if (!(commenter instanceof CodeDocumentationAwareCommenter) || (docCommenter = (CodeDocumentationAwareCommenter)commenter).getDocumentationCommentLinePrefix() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<UnnamedConfigurable> createConfigurables() {
        return Arrays.asList(Extensions.getExtensions(EP_NAME));
    }

    @Nls
    public String getDisplayName() {
        return "Smart Keys";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.smartkey";
    }

    public JComponent createComponent() {
        for (UnnamedConfigurable provider : this.getConfigurables()) {
            this.myAddonPanel.add((Component)provider.createComponent(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.myRootPanel;
    }

    @Override
    public void reset() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        switch (codeInsightSettings.REFORMAT_ON_PASTE) {
            case 1: {
                this.myReformatOnPasteCombo.setSelectedItem(NO_REFORMAT);
                break;
            }
            case 2: {
                this.myReformatOnPasteCombo.setSelectedItem(INDENT_BLOCK);
                break;
            }
            case 3: {
                this.myReformatOnPasteCombo.setSelectedItem(INDENT_EACH_LINE);
                break;
            }
            case 4: {
                this.myReformatOnPasteCombo.setSelectedItem(REFORMAT_BLOCK);
            }
        }
        this.myCbSmartHome.setSelected(editorSettings.isSmartHome());
        this.myCbSmartEnd.setSelected(codeInsightSettings.SMART_END_ACTION);
        this.myCbSmartIndentOnEnter.setSelected(codeInsightSettings.SMART_INDENT_ON_ENTER);
        this.myCbInsertPairCurlyBraceOnEnter.setSelected(codeInsightSettings.INSERT_BRACE_ON_ENTER);
        this.myCbInsertJavadocStubOnEnter.setSelected(codeInsightSettings.JAVADOC_STUB_ON_ENTER);
        this.myCbInsertPairBracket.setSelected(codeInsightSettings.AUTOINSERT_PAIR_BRACKET);
        this.myCbInsertPairQuote.setSelected(codeInsightSettings.AUTOINSERT_PAIR_QUOTE);
        this.myCbCamelWords.setSelected(editorSettings.isCamelWords());
        super.reset();
    }

    @Override
    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        editorSettings.setSmartHome(this.myCbSmartHome.isSelected());
        codeInsightSettings.SMART_END_ACTION = this.myCbSmartEnd.isSelected();
        codeInsightSettings.SMART_INDENT_ON_ENTER = this.myCbSmartIndentOnEnter.isSelected();
        codeInsightSettings.INSERT_BRACE_ON_ENTER = this.myCbInsertPairCurlyBraceOnEnter.isSelected();
        codeInsightSettings.JAVADOC_STUB_ON_ENTER = this.myCbInsertJavadocStubOnEnter.isSelected();
        codeInsightSettings.AUTOINSERT_PAIR_BRACKET = this.myCbInsertPairBracket.isSelected();
        codeInsightSettings.AUTOINSERT_PAIR_QUOTE = this.myCbInsertPairQuote.isSelected();
        editorSettings.setCamelWords(this.myCbCamelWords.isSelected());
        codeInsightSettings.REFORMAT_ON_PASTE = this.getReformatPastedBlockValue();
        super.apply();
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        boolean isModified = this.getReformatPastedBlockValue() != codeInsightSettings.REFORMAT_ON_PASTE;
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbSmartHome, editorSettings.isSmartHome());
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbSmartEnd, codeInsightSettings.SMART_END_ACTION);
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbSmartIndentOnEnter, codeInsightSettings.SMART_INDENT_ON_ENTER);
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbInsertPairCurlyBraceOnEnter, codeInsightSettings.INSERT_BRACE_ON_ENTER);
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbInsertJavadocStubOnEnter, codeInsightSettings.JAVADOC_STUB_ON_ENTER);
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbInsertPairBracket, codeInsightSettings.AUTOINSERT_PAIR_BRACKET);
        isModified |= EditorSmartKeysConfigurable.isModified(this.myCbInsertPairQuote, codeInsightSettings.AUTOINSERT_PAIR_QUOTE);
        return isModified |= EditorSmartKeysConfigurable.isModified(this.myCbCamelWords, editorSettings.isCamelWords());
    }

    private static boolean isModified(JToggleButton checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private int getReformatPastedBlockValue() {
        Object selectedItem = this.myReformatOnPasteCombo.getSelectedItem();
        if (NO_REFORMAT.equals(selectedItem)) {
            return 1;
        }
        if (INDENT_BLOCK.equals(selectedItem)) {
            return 2;
        }
        if (INDENT_EACH_LINE.equals(selectedItem)) {
            return 3;
        }
        if (REFORMAT_BLOCK.equals(selectedItem)) {
            return 4;
        }
        LOG.assertTrue(false);
        return -1;
    }

    public String getId() {
        return "editor.preferences.smartKeys";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        JComboBox jComboBox;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(4, 4, 0, 0), -1, 0, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCbSmartHome = jCheckBox8 = new JCheckBox();
        jCheckBox8.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.smart.home"));
        jPanel2.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbSmartEnd = jCheckBox7 = new JCheckBox();
        jCheckBox7.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.smart.end.on.blank.line"));
        jPanel2.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbInsertPairBracket = jCheckBox6 = new JCheckBox();
        jCheckBox6.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.insert.pair.bracket"));
        jPanel2.add((Component)jCheckBox6, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbInsertPairQuote = jCheckBox5 = new JCheckBox();
        jCheckBox5.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.insert.pair.quote"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbCamelWords = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.use.camelhumps.words"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 5, 5, 5), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(6, 0, 1, 2, 1, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.paste.reformat"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myReformatOnPasteCombo = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAddonPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridConstraints(7, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Enter", 0, 0, null, null));
        this.myCbSmartIndentOnEnter = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.smart.indent"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbInsertPairCurlyBraceOnEnter = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.insert.pair.curly.brace"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbInsertJavadocStubOnEnter = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.javadoc.stub.after.slash.star.star"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

