/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.newEditor.OptionsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

class ScopeColorsPageFactory
implements ColorAndFontPanelFactory {
    ScopeColorsPageFactory() {
    }

    @Override
    public NewColorAndFontPanel createPanel(ColorAndFontOptions options) {
        final JPanel scopePanel = ScopeColorsPageFactory.createChooseScopePanel();
        return NewColorAndFontPanel.create(new PreviewPanel.Empty(){

            @Override
            public Component getPanel() {
                return scopePanel;
            }
        }, ColorAndFontOptions.SCOPES_GROUP, options, null, null);
    }

    @Override
    public String getPanelDisplayName() {
        return ColorAndFontOptions.SCOPES_GROUP;
    }

    private static JPanel createChooseScopePanel() {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        JPanel panel = new JPanel(new GridBagLayout());
        if (projects.length == 0) {
            return panel;
        }
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        Project contextProject = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        final Project project = contextProject != null ? contextProject : projects[0];
        JButton button = new JButton(ApplicationBundle.message((String)"button.edit.scopes", (Object[])new Object[0]));
        button.setPreferredSize(new Dimension(230, button.getPreferredSize().height));
        panel.add((Component)button, gc);
        gc.gridx = 0;
        gc.weightx = 1.0;
        panel.add((Component)new JPanel(), gc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weighty = 1.0;
        panel.add((Component)new JPanel(), gc);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsEditor optionsEditor = (OptionsEditor)OptionsEditor.KEY.getData(DataManager.getInstance().getDataContext());
                if (optionsEditor != null) {
                    try {
                        ScopeChooserConfigurable projectConfigurable = (ScopeChooserConfigurable)ShowSettingsUtil.getInstance().findProjectConfigurable(project, ScopeChooserConfigurable.class);
                        optionsEditor.select((Configurable)projectConfigurable);
                    }
                    catch (IllegalStateException ex) {
                        EditScopesDialog.editConfigurable(project, null);
                    }
                }
            }
        });
        return panel;
    }
}

