/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LanguageCodeStyleSettingsProvider {
    public static final ExtensionPointName<LanguageCodeStyleSettingsProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.langCodeStyleSettingsProvider");

    public abstract Language getLanguage();

    public abstract String getCodeSample(@NotNull SettingsType var1);

    public static Language[] getLanguagesWithCodeStyleSettings() {
        ArrayList<Language> langs = new ArrayList<Language>();
        for (LanguageCodeStyleSettingsProvider provider : (LanguageCodeStyleSettingsProvider[])Extensions.getExtensions(EP_NAME)) {
            langs.add(provider.getLanguage());
        }
        return langs.toArray(new Language[langs.size()]);
    }

    @Nullable
    public static String getCodeSample(Language lang, @NotNull SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/application/options/codeStyle/LanguageCodeStyleSettingsProvider.getCodeSample must not be null");
        }
        for (LanguageCodeStyleSettingsProvider provider : (LanguageCodeStyleSettingsProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.getLanguage().equals(lang)) continue;
            return provider.getCodeSample(settingsType);
        }
        return null;
    }

    @Nullable
    public static Language getLanguage(String langName) {
        for (LanguageCodeStyleSettingsProvider provider : (LanguageCodeStyleSettingsProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!langName.equals(provider.getLanguage().getDisplayName())) continue;
            return provider.getLanguage();
        }
        return null;
    }

    public static enum SettingsType {
        BLANK_LINE_SETTINGS,
        INDENT_AND_BRACES_SETTINGS,
        SPACING_SETTINGS,
        WRAPPING_SETTINGS,
        LANG_SPECIFIC;

    }
}

