/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsProvider;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCodeStylePanel
extends CodeStyleAbstractPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.GeneralCodeStylePanel");
    private static final String SYSTEM_DEPENDANT_STRING = ApplicationBundle.message((String)"combobox.crlf.system.dependent", (Object[])new Object[0]);
    private static final String UNIX_STRING = ApplicationBundle.message((String)"combobox.crlf.unix", (Object[])new Object[0]);
    private static final String WINDOWS_STRING = ApplicationBundle.message((String)"combobox.crlf.windows", (Object[])new Object[0]);
    private static final String MACINTOSH_STRING = ApplicationBundle.message((String)"combobox.crlf.mac", (Object[])new Object[0]);
    private JCheckBox myCbUseSameIndents;
    private final IndentOptionsEditor myOtherIndentOptions;
    private final Map<FileType, IndentOptionsEditor> myAdditionalIndentOptions;
    private final List<FileTypeIndentOptionsProvider> myIndentOptionsProviders;
    private TabbedPaneWrapper myIndentOptionsTabs;
    private JPanel myIndentPanel;
    private JPanel myPreviewPanel;
    private JTextField myRightMarginField;
    private JComboBox myLineSeparatorCombo;
    private JPanel myPanel;
    private int myRightMargin;
    private int myLastSelectedTab;

    public GeneralCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        FileTypeIndentOptionsProvider[] indentOptionsProviders;
        this.$$$setupUI$$$();
        this.myOtherIndentOptions = new IndentOptionsEditor();
        this.myAdditionalIndentOptions = new LinkedHashMap<FileType, IndentOptionsEditor>();
        this.myIndentOptionsProviders = new ArrayList<FileTypeIndentOptionsProvider>();
        this.myLastSelectedTab = 0;
        for (FileTypeIndentOptionsProvider indentOptionsProvider : indentOptionsProviders = (FileTypeIndentOptionsProvider[])Extensions.getExtensions((ExtensionPointName)FileTypeIndentOptionsProvider.EP_NAME)) {
            this.myIndentOptionsProviders.add(indentOptionsProvider);
            if (this.myAdditionalIndentOptions.containsKey(indentOptionsProvider.getFileType())) {
                LOG.error("Duplicate extension: " + indentOptionsProvider);
                continue;
            }
            this.myAdditionalIndentOptions.put(indentOptionsProvider.getFileType(), indentOptionsProvider.createOptionsEditor());
        }
        this.myIndentPanel.setLayout(new BorderLayout());
        this.myIndentPanel.add((Component)this.createTabOptionsPanel(), "Center");
        this.installPreviewPanel(this.myPreviewPanel);
        this.myLineSeparatorCombo.addItem(SYSTEM_DEPENDANT_STRING);
        this.myLineSeparatorCombo.addItem(UNIX_STRING);
        this.myLineSeparatorCombo.addItem(WINDOWS_STRING);
        this.myLineSeparatorCombo.addItem(MACINTOSH_STRING);
        this.addPanelToWatch(this.myPanel);
        this.myRightMargin = settings.RIGHT_MARGIN;
        this.myRightMarginField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                int valueFromControl = GeneralCodeStylePanel.this.getRightMarginImpl();
                if (valueFromControl > 0) {
                    GeneralCodeStylePanel.this.myRightMargin = valueFromControl;
                }
            }
        });
    }

    @Override
    protected void somethingChanged() {
        super.somethingChanged();
        this.update();
    }

    private void update() {
        boolean enabled;
        boolean bl = enabled = !this.myCbUseSameIndents.isSelected();
        if (!enabled && this.myIndentOptionsTabs.getSelectedIndex() != 0) {
            this.myIndentOptionsTabs.setSelectedIndex(0);
        }
        int index = 0;
        for (IndentOptionsEditor options : this.myAdditionalIndentOptions.values()) {
            boolean tabEnabled = enabled || index == 0;
            options.setEnabled(tabEnabled);
            this.myIndentOptionsTabs.setEnabledAt(index, tabEnabled);
            ++index;
        }
        this.myOtherIndentOptions.setEnabled(enabled);
        this.myIndentOptionsTabs.setEnabledAt(this.myIndentOptionsTabs.getTabCount() - 1, enabled);
    }

    private JPanel createTabOptionsPanel() {
        OptionGroup optionGroup = new OptionGroup(ApplicationBundle.message((String)"group.tabs.and.indents", (Object[])new Object[0]));
        this.myCbUseSameIndents = new JCheckBox(ApplicationBundle.message((String)"checkbox.indent.use.same.settings.for.all.file.types", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myCbUseSameIndents);
        this.myIndentOptionsTabs = new TabbedPaneWrapper(this);
        for (Map.Entry<FileType, IndentOptionsEditor> entry : this.myAdditionalIndentOptions.entrySet()) {
            FileType ft = entry.getKey();
            String tabName = ft instanceof LanguageFileType ? ((LanguageFileType)ft).getLanguage().getDisplayName() : ft.getName();
            this.myIndentOptionsTabs.addTab(tabName, entry.getValue().createPanel());
        }
        this.myIndentOptionsTabs.addTab(ApplicationBundle.message((String)"tab.indent.other", (Object[])new Object[0]), this.myOtherIndentOptions.createPanel());
        this.myIndentOptionsTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int selIndex = GeneralCodeStylePanel.this.myIndentOptionsTabs.getSelectedIndex();
                if (selIndex != GeneralCodeStylePanel.this.myLastSelectedTab) {
                    GeneralCodeStylePanel.this.myLastSelectedTab = selIndex;
                    GeneralCodeStylePanel.this.updatePreviewEditor();
                    GeneralCodeStylePanel.this.somethingChanged();
                }
            }
        });
        optionGroup.add(this.myIndentOptionsTabs.getComponent());
        return optionGroup.createPanel();
    }

    @Override
    protected int getRightMargin() {
        return this.myRightMargin;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType;
        FileTypeIndentOptionsProvider provider = this.getSelectedIndentProvider();
        if (provider == null) {
            languageFileType = FileTypes.PLAIN_TEXT;
            if (languageFileType == null) throw new IllegalStateException("@NotNull method com/intellij/application/options/GeneralCodeStylePanel.getFileType must not return null");
            return languageFileType;
        }
        languageFileType = provider.getFileType();
        if (languageFileType != null) return languageFileType;
        throw new IllegalStateException("@NotNull method com/intellij/application/options/GeneralCodeStylePanel.getFileType must not return null");
    }

    @Override
    protected String getPreviewText() {
        FileTypeIndentOptionsProvider provider = this.getSelectedIndentProvider();
        if (provider != null) {
            return provider.getPreviewText();
        }
        return "";
    }

    @Nullable
    private FileTypeIndentOptionsProvider getSelectedIndentProvider() {
        if (this.myIndentOptionsTabs == null) {
            return GeneralCodeStylePanel.getDefaultIndentProvider();
        }
        int selIndex = this.myIndentOptionsTabs.getSelectedIndex();
        if (selIndex >= 0 && selIndex < this.myIndentOptionsProviders.size()) {
            return this.myIndentOptionsProviders.get(selIndex);
        }
        return GeneralCodeStylePanel.getDefaultIndentProvider();
    }

    @Nullable
    private static FileTypeIndentOptionsProvider getDefaultIndentProvider() {
        FileTypeIndentOptionsProvider[] providers = (FileTypeIndentOptionsProvider[])Extensions.getExtensions((ExtensionPointName)FileTypeIndentOptionsProvider.EP_NAME);
        return providers.length == 0 ? null : providers[0];
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        settings.LINE_SEPARATOR = this.getSelectedLineSeparator();
        settings.USE_SAME_INDENTS = this.myCbUseSameIndents.isSelected();
        if (settings.USE_SAME_INDENTS) {
            IndentOptionsEditor theEditor = this.findEditorForSameIndents();
            theEditor.apply(settings, settings.OTHER_INDENT_OPTIONS);
        } else {
            this.myOtherIndentOptions.apply(settings, settings.OTHER_INDENT_OPTIONS);
            for (Map.Entry<FileType, IndentOptionsEditor> entry : this.myAdditionalIndentOptions.entrySet()) {
                FileType fileType = entry.getKey();
                IndentOptionsEditor editor = entry.getValue();
                editor.apply(settings, settings.getAdditionalIndentOptions(fileType));
            }
        }
        int rightMarginImpl = this.getRightMarginImpl();
        if (rightMarginImpl > 0) {
            settings.RIGHT_MARGIN = rightMarginImpl;
        }
    }

    private IndentOptionsEditor findEditorForSameIndents() {
        return this.myAdditionalIndentOptions.isEmpty() ? this.myOtherIndentOptions : this.myAdditionalIndentOptions.values().iterator().next();
    }

    private int getRightMarginImpl() {
        if (this.myRightMarginField == null) {
            return -1;
        }
        try {
            return Integer.parseInt(this.myRightMarginField.getText());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Nullable
    private String getSelectedLineSeparator() {
        if (UNIX_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\n";
        }
        if (MACINTOSH_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\r";
        }
        if (WINDOWS_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\r\n";
        }
        return null;
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        if (!Comparing.equal((String)this.getSelectedLineSeparator(), (String)settings.LINE_SEPARATOR)) {
            return true;
        }
        if (this.myCbUseSameIndents.isSelected() != settings.USE_SAME_INDENTS) {
            return true;
        }
        if (settings.USE_SAME_INDENTS) {
            IndentOptionsEditor editor = this.findEditorForSameIndents();
            if (editor.isModified(settings, settings.OTHER_INDENT_OPTIONS)) {
                return true;
            }
        } else {
            if (this.myOtherIndentOptions.isModified(settings, settings.OTHER_INDENT_OPTIONS)) {
                return true;
            }
            for (Map.Entry<FileType, IndentOptionsEditor> entry : this.myAdditionalIndentOptions.entrySet()) {
                FileType fileType;
                IndentOptionsEditor editor = entry.getValue();
                if (!editor.isModified(settings, settings.getAdditionalIndentOptions(fileType = entry.getKey()))) continue;
                return true;
            }
        }
        return !this.myRightMarginField.getText().equals(String.valueOf(settings.RIGHT_MARGIN));
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        this.myCbUseSameIndents.setSelected(settings.USE_SAME_INDENTS);
        this.myOtherIndentOptions.reset(settings, settings.OTHER_INDENT_OPTIONS);
        boolean first = true;
        for (Map.Entry<FileType, IndentOptionsEditor> entry : this.myAdditionalIndentOptions.entrySet()) {
            IndentOptionsEditor editor = entry.getValue();
            if (settings.USE_SAME_INDENTS && first) {
                first = false;
                editor.reset(settings, settings.OTHER_INDENT_OPTIONS);
                continue;
            }
            FileType type = entry.getKey();
            editor.reset(settings, settings.getAdditionalIndentOptions(type));
        }
        String lineSeparator = settings.LINE_SEPARATOR;
        if ("\n".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(UNIX_STRING);
        } else if ("\r\n".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(WINDOWS_STRING);
        } else if ("\r".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(MACINTOSH_STRING);
        } else {
            this.myLineSeparatorCombo.setSelectedItem(SYSTEM_DEPENDANT_STRING);
        }
        this.myRightMarginField.setText(String.valueOf(settings.RIGHT_MARGIN));
        this.update();
    }

    @Override
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getFileType(), scheme, null);
    }

    @Override
    protected void prepareForReformat(PsiFile psiFile) {
        FileTypeIndentOptionsProvider provider = this.getSelectedIndentProvider();
        if (provider != null) {
            provider.prepareForReformat(psiFile);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JTextField jTextField;
        JComboBox jComboBox;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 8, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 1, 1, 0, 3, null, null, null));
        this.myLineSeparatorCombo = jComboBox = new JComboBox();
        jPanel5.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(100, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.right.margin.columns"));
        jPanel5.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRightMarginField = jTextField = new JTextField();
        jPanel5.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(50, -1), new Dimension(50, -1)));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.line.separator.for.new.files"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myIndentPanel = jPanel2 = new JPanel();
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 3, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel4.add((Component)jPanel, new GridConstraints(0, 1, 2, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.preview"), 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

