/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ShareSchemeDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.WriteExternalException;
import java.io.IOException;
import javax.swing.Icon;

public abstract class ExportSchemeAction<T extends Scheme, E extends ExternalizableScheme>
extends AnAction {
    protected final SchemesManager<T, E> mySchemesManager;

    public ExportSchemeAction(SchemesManager<T, E> manager) {
        super("Share", "Share scheme on server", IconLoader.getIcon((String)"/actions/export.png"));
        this.mySchemesManager = manager;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        E profile = this.getSelectedScheme();
        presentation.setEnabled(profile != null && this.isAvailableFor(profile));
    }

    protected abstract E getSelectedScheme();

    private boolean isAvailableFor(E selected) {
        return selected != null && !this.mySchemesManager.isShared(selected);
    }

    public void actionPerformed(AnActionEvent e) {
        ExportSchemeAction.doExport(this.getSelectedScheme(), this.mySchemesManager);
    }

    public static <T extends Scheme, E extends ExternalizableScheme> void doExport(E scheme, SchemesManager<T, E> manager) {
        if (scheme != null) {
            try {
                ShareSchemeDialog dialog = new ShareSchemeDialog();
                dialog.init((Scheme)scheme);
                dialog.show();
                if (dialog.isOK()) {
                    try {
                        manager.exportScheme(scheme, dialog.getName(), dialog.getDescription());
                        Messages.showMessageDialog((String)("Scheme '" + scheme.getName() + "' was shared successfully as '" + dialog.getName() + " '"), (String)"Share Scheme", (Icon)Messages.getInformationIcon());
                    }
                    catch (IOException e) {
                        Messages.showErrorDialog((String)("Cannot share scheme '" + scheme.getName() + "': " + e.getLocalizedMessage()), (String)"Share Shceme");
                    }
                }
            }
            catch (WriteExternalException e1) {
                Messages.showErrorDialog((String)("Cannot share scheme: " + e1.getLocalizedMessage()), (String)"Share Scheme");
            }
        }
    }
}

