/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetRecognizer;
import java.util.Arrays;

abstract class CharsetRecog_mbcs
extends CharsetRecognizer {
    CharsetRecog_mbcs() {
    }

    abstract String getName();

    int match(CharsetDetector det, int[] commonChars) {
        int confidence;
        block14: {
            int singleByteCharCount = 0;
            int doubleByteCharCount = 0;
            int commonCharCount = 0;
            int badCharCount = 0;
            int totalCharCount = 0;
            confidence = 0;
            iteratedChar iter = new iteratedChar();
            iter.reset();
            while (this.nextChar(iter, det)) {
                ++totalCharCount;
                if (iter.error) {
                    ++badCharCount;
                } else if (iter.charValue <= 255) {
                    ++singleByteCharCount;
                } else {
                    ++doubleByteCharCount;
                    if (commonChars != null && Arrays.binarySearch(commonChars, iter.charValue) >= 0) {
                        ++commonCharCount;
                    }
                }
                if (badCharCount < 2 || badCharCount * 5 < doubleByteCharCount) {
                    continue;
                }
                break block14;
            }
            if (doubleByteCharCount == 0 && badCharCount == 0) {
                confidence = 10;
            } else if (doubleByteCharCount < 20 * badCharCount) {
                confidence = 0;
            } else if (commonChars == null) {
                confidence = 30 + doubleByteCharCount - 20 * badCharCount;
                if (confidence > 100) {
                    confidence = 100;
                }
            } else {
                double maxVal = Math.log((float)doubleByteCharCount / 4.0f);
                double scaleFactor = 90.0 / maxVal;
                confidence = (int)(Math.log(commonCharCount + 1) * scaleFactor + 10.0);
                confidence = Math.min(confidence, 100);
            }
        }
        return confidence;
    }

    abstract boolean nextChar(iteratedChar var1, CharsetDetector var2);

    static class iteratedChar {
        int charValue = 0;
        int index = 0;
        int nextIndex = 0;
        boolean error = false;
        boolean done = false;

        iteratedChar() {
        }

        void reset() {
            this.charValue = 0;
            this.index = -1;
            this.nextIndex = 0;
            this.error = false;
            this.done = false;
        }

        int nextByte(CharsetDetector det) {
            if (this.nextIndex >= det.fRawLength) {
                this.done = true;
                return -1;
            }
            int byteValue = det.fRawInput[this.nextIndex++] & 0xFF;
            return byteValue;
        }
    }

    static class CharsetRecog_sjis
    extends CharsetRecog_mbcs {
        static int[] commonChars = new int[]{33484, 33477, 33442, 33115, 33089, 33461, 33481, 33463, 33090, 33476, 33478, 33485, 33500, 33520, 33513, 33480, 33450, 33683, 33469, 33624, 33514, 33603, 33444, 33449, 33639, 33457, 33093, 33504, 33675, 33614, 33512, 33511, 33088, 33634, 33673, 33473, 33674, 33451, 33654, 33459, 33521, 33440, 33640, 37882, 33141, 33142, 33630, 33510, 33623, 33453, 33665, 33446, 33465, 33467, 33470, 33601, 33652, 33455, 36950, 33448, 33474, 33620, 36455, 33653, 33479, 38385, 33622, 38523, 37608, 33605, 33486, 33669, 38768, 33503, 33501, 33647, 33602, 36007, 33618, 33661, 33677, 33606, 33615, 33664, 33517, 36211, 33609, 33637, 36846, 38326, 33129, 33130, 33642, 36332, 33471, 33612, 33638, 33506, 33676, 37980};

        CharsetRecog_sjis() {
        }

        boolean nextChar(iteratedChar it, CharsetDetector det) {
            it.index = it.nextIndex;
            it.error = false;
            it.charValue = it.nextByte(det);
            int firstByte = it.charValue;
            if (firstByte < 0) {
                return false;
            }
            if (firstByte <= 127 || firstByte > 160 && firstByte <= 223) {
                return true;
            }
            int secondByte = it.nextByte(det);
            if (secondByte < 0) {
                return false;
            }
            it.charValue = firstByte << 8 | secondByte;
            if (!(secondByte >= 64 && secondByte <= 127 || secondByte >= 128 && secondByte <= 255)) {
                it.error = true;
            }
            return true;
        }

        int match(CharsetDetector det) {
            return this.match(det, commonChars);
        }

        String getName() {
            return "Shift_JIS";
        }
    }

    static abstract class CharsetRecog_euc
    extends CharsetRecog_mbcs {
        CharsetRecog_euc() {
        }

        boolean nextChar(iteratedChar it, CharsetDetector det) {
            it.index = it.nextIndex;
            it.error = false;
            int firstByte = 0;
            int secondByte = 0;
            int thirdByte = 0;
            it.charValue = it.nextByte(det);
            firstByte = it.charValue;
            if (firstByte < 0) {
                it.done = true;
            } else if (firstByte > 141) {
                secondByte = it.nextByte(det);
                it.charValue = it.charValue << 8 | secondByte;
                if (firstByte >= 161 && firstByte <= 254) {
                    if (secondByte < 161) {
                        it.error = true;
                    }
                } else if (firstByte == 142) {
                    if (secondByte < 161) {
                        it.error = true;
                    }
                } else if (firstByte == 143) {
                    thirdByte = it.nextByte(det);
                    it.charValue = it.charValue << 8 | thirdByte;
                    if (thirdByte < 161) {
                        it.error = true;
                    }
                }
            }
            return !it.done;
        }

        static class CharsetRecog_euc_jp
        extends CharsetRecog_euc {
            static int[] commonChars = new int[]{42190, 42183, 42148, 41404, 41378, 42167, 42187, 42169, 41379, 42182, 42184, 42191, 42206, 42226, 42219, 42186, 42156, 42483, 42175, 42425, 42220, 42404, 42150, 42155, 42440, 42163, 41382, 42210, 42475, 42415, 42218, 42217, 41377, 42435, 42473, 42179, 42474, 42157, 42455, 42165, 42227, 42146, 42441, 50940, 41430, 41431, 42431, 42216, 42424, 42159, 42465, 42152, 42171, 42173, 42176, 42402, 42453, 42161, 49079, 42154, 42180, 42421, 48072, 42454, 42185, 51955, 42423, 52188, 50410, 42406, 42192, 42469, 52689, 42209, 42207, 42448, 42403, 47273, 42419, 42462, 42477, 42407, 42416, 42464, 42223, 47572, 42410, 42438, 48880, 51896, 41418, 41419, 42443, 47854, 42177, 42413, 42439, 42212, 42476, 51133};

            CharsetRecog_euc_jp() {
            }

            String getName() {
                return "EUC-JP";
            }

            int match(CharsetDetector det) {
                return this.match(det, commonChars);
            }
        }

        static class CharsetRecog_euc_kr
        extends CharsetRecog_euc {
            static int[] commonChars = new int[]{49356, 46297, 46274, 49351, 49057, 51151, 45217, 45293, 51153, 49654, 49339, 47054, 45538, 48301, 49338, 48103, 49572, 49370, 46517, 47270, 48878, 46287, 48374, 48579, 45527, 46315, 47278, 49358, 45994, 48838, 49366, 47800, 46569, 46835, 51160, 45261, 49359, 48570, 49336, 45497, 49574, 47613, 48115, 45268, 47337, 47288, 45306, 49403, 47822, 49622, 49065, 49404, 49131, 47534, 50862, 48125, 48314, 49319, 49144, 46535, 49124, 49132, 48581, 51154, 51173, 45308, 45496, 47857, 48863, 50637, 47286, 48576, 47023, 46527, 46011, 51373, 49341, 45235, 50337, 47042, 47531, 49327, 48888, 46501, 48338, 47566, 49631, 49088, 49656, 45286, 45511, 47824, 48890, 49381, 48840, 49590, 47291, 45304, 47564, 45253};

            CharsetRecog_euc_kr() {
            }

            String getName() {
                return "EUC-KR";
            }

            int match(CharsetDetector det) {
                return this.match(det, commonChars);
            }
        }
    }

    static class CharsetRecog_gb_18030
    extends CharsetRecog_mbcs {
        static int[] commonChars = new int[]{41900, 46532, 41377, 41380, 41379, 51911, 53947, 46323, 54490, 54992, 51965, 54224, 41459, 45755, 41914, 48122, 51403, 41378, 54211, 53671, 51413, 48861, 47350, 53442, 52728, 53930, 47610, 49611, 51663, 41392, 41393, 52946, 48382, 52932, 53972, 50396, 49332, 54466, 51889, 53456, 48588, 49097, 46804, 48347, 45502, 46070, 47284, 51706, 45496, 48316, 53186, 47821, 48845, 46025, 54754, 47327, 47062, 50636, 49094, 48097, 52906, 51431, 53173, 41457, 50410, 45480, 46767, 49389, 54269, 47010, 51371, 47037, 52965, 49883, 48039, 53460, 47561, 50119, 47613, 51920, 46563, 48086, 53206, 51893, 53938, 49076, 46816, 52460, 51192, 53445, 51926, 47576, 46525, 47069, 50935, 51957, 41889, 47016, 47531, 53941, 52217, 52668, 50916, 54234, 53409, 53665, 54222, 49066, 46310, 50367, 55287, 46567, 52659, 51177, 55278, 50880, 53215, 46552, 46528, 48813, 46277, 50871, 50394, 53444, 47524, 54442, 49852, 50112, 47859, 51901, 48338, 52977, 48555, 41901, 41919, 45988, 47611, 54958, 49599, 48088, 47345, 46840, 46760, 52706, 47811, 46028, 52440, 55252, 52149};

        CharsetRecog_gb_18030() {
        }

        boolean nextChar(iteratedChar it, CharsetDetector det) {
            it.index = it.nextIndex;
            it.error = false;
            int firstByte = 0;
            int secondByte = 0;
            int thirdByte = 0;
            int fourthByte = 0;
            it.charValue = it.nextByte(det);
            firstByte = it.charValue;
            if (firstByte < 0) {
                it.done = true;
            } else if (firstByte > 128) {
                secondByte = it.nextByte(det);
                it.charValue = it.charValue << 8 | secondByte;
                if (!(firstByte < 129 || firstByte > 254 || secondByte >= 64 && secondByte <= 126 || secondByte >= 80 && secondByte <= 254)) {
                    if (secondByte >= 48 && secondByte <= 57 && (thirdByte = it.nextByte(det)) >= 129 && thirdByte <= 254 && (fourthByte = it.nextByte(det)) >= 48 && fourthByte <= 57) {
                        it.charValue = it.charValue << 16 | thirdByte << 8 | fourthByte;
                    } else {
                        it.error = true;
                    }
                }
            }
            return !it.done;
        }

        String getName() {
            return "GB18030";
        }

        int match(CharsetDetector det) {
            return this.match(det, commonChars);
        }
    }
}

