/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.texteditor.IUpdate;

public class CopyQualifiedNameAction
extends SelectionDispatchAction {
    private static final long LABEL_FLAGS = new Long(281477260838017L);
    public static final String JAVA_EDITOR_ACTION_DEFINITIONS_ID = "org.eclipse.jdt.ui.edit.text.java.copy.qualified.name";
    public static final String ACTION_HANDLER_ID = "org.eclipse.jdt.ui.actions.CopyQualifiedName";
    private final Clipboard fClipboard;
    private CompilationUnitEditor fEditor;
    private final IAction fPasteAction;

    public CopyQualifiedNameAction(CompilationUnitEditor editor, Clipboard clipboard, IAction pastAction) {
        this((IWorkbenchSite)editor.getSite(), clipboard, pastAction);
        this.fEditor = editor;
    }

    public CopyQualifiedNameAction(IWorkbenchSite site, Clipboard clipboard, IAction pastAction) {
        super(site);
        this.fPasteAction = pastAction;
        this.fClipboard = clipboard == null ? new Clipboard(this.getShell().getDisplay()) : clipboard;
        this.setText(ActionMessages.CopyQualifiedNameAction_ActionName);
        this.setToolTipText(ActionMessages.CopyQualifiedNameAction_ToolTipText);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_COPY_QUALIFIED_NAME);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_COPY_QUALIFIED_NAME);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection.toArray()));
    }

    private boolean canEnable(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            Object element = objects[i];
            if (this.isValideElement(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isValideElement(Object element) {
        if (element instanceof IMember) {
            return true;
        }
        if (element instanceof IClassFile) {
            return true;
        }
        if (element instanceof ICompilationUnit) {
            return true;
        }
        if (element instanceof IPackageDeclaration) {
            return true;
        }
        if (element instanceof IImportDeclaration) {
            return true;
        }
        return element instanceof IPackageFragment;
    }

    public void run() {
        try {
            IJavaElement[] elements = this.getSelectedElements();
            if (elements == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.CopyQualifiedNameAction_InfoDialogTitel, (String)ActionMessages.CopyQualifiedNameAction_NoElementToQualify);
                return;
            }
            Object[] data = null;
            Transfer[] dataTypes = null;
            if (elements.length == 1) {
                String qualifiedName = JavaElementLabels.getElementLabel(elements[0], LABEL_FLAGS);
                IResource resource = elements[0].getCorrespondingResource();
                if (resource != null) {
                    IPath location = resource.getLocation();
                    if (location != null) {
                        data = new Object[]{qualifiedName, resource, new String[]{location.toOSString()}};
                        dataTypes = new Transfer[]{TextTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
                    } else {
                        data = new Object[]{qualifiedName, resource};
                        dataTypes = new Transfer[]{TextTransfer.getInstance(), ResourceTransfer.getInstance()};
                    }
                } else {
                    data = new Object[]{qualifiedName};
                    dataTypes = new Transfer[]{TextTransfer.getInstance()};
                }
            } else {
                StringBuffer buf = new StringBuffer();
                buf.append(JavaElementLabels.getElementLabel(elements[0], LABEL_FLAGS));
                int i = 1;
                while (i < elements.length) {
                    IJavaElement element = elements[i];
                    String qualifiedName = JavaElementLabels.getElementLabel(element, LABEL_FLAGS);
                    buf.append('\r').append('\n').append(qualifiedName);
                    ++i;
                }
                data = new Object[]{buf.toString()};
                dataTypes = new Transfer[]{TextTransfer.getInstance()};
            }
            try {
                this.fClipboard.setContents(data, dataTypes);
                if (this.fPasteAction != null) {
                    if (this.fPasteAction instanceof SelectionDispatchAction) {
                        if (((SelectionDispatchAction)this.fPasteAction).getSelection() != null) {
                            ((SelectionDispatchAction)this.fPasteAction).update(((SelectionDispatchAction)this.fPasteAction).getSelection());
                        }
                    } else if (this.fPasteAction instanceof IUpdate) {
                        ((IUpdate)this.fPasteAction).update();
                    }
                }
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)ActionMessages.CopyQualifiedNameAction_ErrorTitle, (String)ActionMessages.CopyQualifiedNameAction_ErrorDescription)) {
                    this.fClipboard.setContents(data, dataTypes);
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private IJavaElement[] getSelectedElements() throws JavaModelException {
        if (this.fEditor != null) {
            IJavaElement element = this.getSelectedElement(this.fEditor);
            if (element == null) {
                return null;
            }
            return new IJavaElement[]{element};
        }
        ISelection selection = this.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (Object element : (IStructuredSelection)selection) {
            if (!this.isValideElement(element)) continue;
            result.add(element);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    private IJavaElement getSelectedElement(CompilationUnitEditor editor) {
        ISourceViewer viewer = editor.getViewer();
        if (viewer == null) {
            return null;
        }
        Point selectedRange = viewer.getSelectedRange();
        int length = selectedRange.y;
        int offset = selectedRange.x;
        ICompilationUnit cu = JavaUI.getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
        if (cu == null) {
            return null;
        }
        AssistContext context = new AssistContext(cu, offset, length);
        ASTNode node = context.getCoveringNode();
        IBinding binding = null;
        if (node instanceof Name) {
            binding = ((Name)node).resolveBinding();
        } else if (node instanceof MethodInvocation) {
            binding = ((MethodInvocation)node).resolveMethodBinding();
        } else if (node instanceof MethodDeclaration) {
            binding = ((MethodDeclaration)node).resolveBinding();
        } else if (node instanceof Type) {
            binding = ((Type)node).resolveBinding();
        } else if (node instanceof AnonymousClassDeclaration) {
            binding = ((AnonymousClassDeclaration)node).resolveBinding();
        } else if (node instanceof TypeDeclaration) {
            binding = ((TypeDeclaration)node).resolveBinding();
        } else {
            if (node instanceof CompilationUnit) {
                return ((CompilationUnit)node).getJavaElement();
            }
            if (node instanceof Expression) {
                binding = ((Expression)node).resolveTypeBinding();
            } else if (node instanceof ImportDeclaration) {
                binding = ((ImportDeclaration)node).resolveBinding();
            } else if (node instanceof MemberRef) {
                binding = ((MemberRef)node).resolveBinding();
            } else if (node instanceof MemberValuePair) {
                binding = ((MemberValuePair)node).resolveMemberValuePairBinding();
            } else if (node instanceof PackageDeclaration) {
                binding = ((PackageDeclaration)node).resolveBinding();
            } else if (node instanceof TypeParameter) {
                binding = ((TypeParameter)node).resolveBinding();
            } else if (node instanceof VariableDeclaration) {
                binding = ((VariableDeclaration)node).resolveBinding();
            }
        }
        if (binding != null) {
            return binding.getJavaElement();
        }
        return null;
    }
}

