/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.core.internal.ui.explorer.providers.content.virtual;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;


/**
 * @author ljulien
 */
public abstract class VirtualNode implements IVirtualNode
{
	private String name;
	private String displayName;
	private Object parent;
	private List children = new LinkedList ();
	
	public VirtualNode (String name, String displayName, Object parent)
	{
		this.name = name;
		this.displayName = displayName;
		this.parent = parent;
		if (parent != null && parent instanceof IVirtualNode)
		{
		    ((IVirtualNode)parent).addChildren(this);
		}
	}
	
	/**
	 * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode#getName()
	 */
	public String getName()
	{
		return this.name;
	}

	/**
	 * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode#getDisplayName()
	 */
	public String getDisplayName()
	{
		return this.displayName != null? this.displayName : this.name;
	}

    /**
     * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode#getParent()
     */
    public Object getParent()
    {
        return parent;
    }

    /**
     * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode#getChildren()
     */
    protected List getChildren()
    {
        return children;
    }

    /**
     * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode#hasChildren()
     */
    public boolean hasChildren()
    {
        return !children.isEmpty();
    }

    /**
     * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode#getChildrenArray()
     */
    public Object[] getChildrenArray()
    {
        return children.toArray(new Object [children.size()]);
    }

    /**
     * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode#addChildren(java.lang.Object)
     */
    public void addChildren(Object child)
    {
        if (!children.contains(child))
        {
            children.add(child);
        }
    }

    /**
     * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode#removeChildren(java.lang.Object)
     */
    public void removeChildren(Object child)
    {
        if (children.contains(child))
        {
            children.remove(child);
        }
    }

    /**
     * Will remove all the children include in the Children collection
     */
    public void removeAllChildren ()
    {
        children.removeAll(children);
    }
    
    /**
     * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode#supports(org.eclipse.emf.ecore.EClass)
     */
    public boolean supports(EClass type)
    {
        return false;
    }

    /**
     * @see org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode#addChildren(java.util.Collection)
     */
    public void addChildren(Collection collection)
    {
        children.removeAll(children);
        children.addAll(collection);
    }
}
