/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.provisional.format;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.sse.core.internal.format.AbstractStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.document.CDATASectionImpl;
import org.eclipse.wst.xml.core.internal.provisional.format.CommentNodeFormatter;
import org.eclipse.wst.xml.core.internal.provisional.format.DocumentNodeFormatter;
import org.eclipse.wst.xml.core.internal.provisional.format.ElementNodeFormatter;
import org.eclipse.wst.xml.core.internal.provisional.format.IStructuredFormatPreferencesXML;
import org.eclipse.wst.xml.core.internal.provisional.format.NodeFormatter;
import org.eclipse.wst.xml.core.internal.provisional.format.StructuredFormatPreferencesXML;
import org.eclipse.wst.xml.core.internal.provisional.format.TextNodeFormatter;
import org.w3c.dom.Node;

public class FormatProcessorXML
extends AbstractStructuredFormatProcessor {
    protected IStructuredFormatPreferences fFormatPreferences = null;

    protected String getFileExtension() {
        return "xml";
    }

    public IStructuredFormatPreferences getFormatPreferences() {
        if (this.fFormatPreferences == null) {
            this.fFormatPreferences = new StructuredFormatPreferencesXML();
            Preferences preferences = this.getModelPreferences();
            if (preferences != null) {
                this.fFormatPreferences.setLineWidth(preferences.getInt("lineWidth"));
                ((IStructuredFormatPreferencesXML)this.fFormatPreferences).setSplitMultiAttrs(preferences.getBoolean("splitMultiAttrs"));
                this.fFormatPreferences.setClearAllBlankLines(preferences.getBoolean("clearAllBlankLines"));
                char indentChar = ' ';
                String indentCharPref = preferences.getString("indentationChar");
                if ("tab".equals(indentCharPref)) {
                    indentChar = '\t';
                }
                int indentationWidth = preferences.getInt("indentationSize");
                StringBuffer indent = new StringBuffer();
                int i = 0;
                while (i < indentationWidth) {
                    indent.append(indentChar);
                    ++i;
                }
                this.fFormatPreferences.setIndent(indent.toString());
            }
        }
        return this.fFormatPreferences;
    }

    protected IStructuredFormatter getFormatter(Node node) {
        if (node == null) {
            return null;
        }
        short nodeType = node.getNodeType();
        NodeFormatter formatter = null;
        switch (nodeType) {
            case 1: {
                formatter = new ElementNodeFormatter();
                break;
            }
            case 3: {
                if (node instanceof CDATASectionImpl) {
                    formatter = new NodeFormatter();
                    break;
                }
                formatter = new TextNodeFormatter();
                break;
            }
            case 8: {
                formatter = new CommentNodeFormatter();
                break;
            }
            case 7: {
                formatter = new NodeFormatter();
                break;
            }
            case 9: {
                formatter = new DocumentNodeFormatter();
                break;
            }
            default: {
                formatter = new NodeFormatter();
            }
        }
        formatter.setFormatPreferences(this.getFormatPreferences());
        formatter.setProgressMonitor(this.fProgressMonitor);
        return formatter;
    }

    protected Preferences getModelPreferences() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected void refreshFormatPreferences() {
        this.fFormatPreferences = null;
    }
}

