/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;

public class RubyElementLabels {
    public static final long M_PARAMETER_NAMES = 2L;
    public static final long M_FULLY_QUALIFIED = 128L;
    public static final long M_POST_QUALIFIED = 256L;
    public static final long I_FULLY_QUALIFIED = 1024L;
    public static final long I_POST_QUALIFIED = 2048L;
    public static final long F_FULLY_QUALIFIED = 65536L;
    public static final long F_POST_QUALIFIED = 131072L;
    public static final long T_FULLY_QUALIFIED = 262144L;
    public static final long T_CONTAINER_QUALIFIED = 524288L;
    public static final long T_POST_QUALIFIED = 0x100000L;
    public static final long D_QUALIFIED = 0x1000000L;
    public static final long D_POST_QUALIFIED = 0x2000000L;
    public static final long CF_QUALIFIED = 0x8000000L;
    public static final long CF_POST_QUALIFIED = 0x10000000L;
    public static final long CU_QUALIFIED = 0x80000000L;
    public static final long CU_POST_QUALIFIED = 0x100000000L;
    public static final long P_QUALIFIED = 0x800000000L;
    public static final long P_POST_QUALIFIED = 0x1000000000L;
    public static final long P_COMPRESSED = 0x2000000000L;
    public static final long ROOT_VARIABLE = 0x10000000000L;
    public static final long ROOT_QUALIFIED = 0x20000000000L;
    public static final long ROOT_POST_QUALIFIED = 0x40000000000L;
    public static final long APPEND_ROOT_PATH = 0x80000000000L;
    public static final long PREPEND_ROOT_PATH = 0x100000000000L;
    public static final long REFERENCED_ROOT_POST_QUALIFIED = 0x200000000000L;
    public static final long T_DECLARATION_POINT = 0x400000000000L;
    public static final long USE_RESOLVED = 0x1000000000000L;
    public static final long ALL_FULLY_QUALIFIED = new Long(2235681801344L);
    public static final long ALL_POST_QUALIFIED = new Long(4471364126976L);
    public static final long ALL_DEFAULT = new Long(2L);
    public static final long DEFAULT_QUALIFIED = new Long(2298807424L);
    public static final long DEFAULT_POST_QUALIFIED = new Long(4598139136L);
    public static final String CONCAT_STRING = RubyUIMessages.RubyElementLabels_concat_string;
    public static final String COMMA_STRING = RubyUIMessages.RubyElementLabels_comma_string;
    public static final String DECL_STRING = RubyUIMessages.RubyElementLabels_declseparator_string;
    public static final String ELLIPSIS_STRING = "...";
    private static final long QUALIFIER_FLAGS = 0x1002000000000L;
    static /* synthetic */ Class class$0;

    private RubyElementLabels() {
    }

    private static final boolean getFlag(long l, long l2) {
        return (l & l2) != 0L;
    }

    public static String getTextLabel(Object object, long l) {
        if (object instanceof IRubyElement) {
            return RubyElementLabels.getElementLabel((IRubyElement)object, l);
        }
        if (object instanceof IAdaptable) {
            IWorkbenchAdapter iWorkbenchAdapter;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return iWorkbenchAdapter.getLabel(object);
            }
        }
        return "";
    }

    public static String getElementLabel(IRubyElement iRubyElement, long l) {
        StringBuffer stringBuffer = new StringBuffer(60);
        RubyElementLabels.getElementLabel(iRubyElement, l, stringBuffer);
        return stringBuffer.toString();
    }

    public static void getElementLabel(IRubyElement iRubyElement, long l, StringBuffer stringBuffer) {
        int n = iRubyElement.getElementType();
        switch (n) {
            case 4: {
                RubyElementLabels.getMethodLabel((IMethod)iRubyElement, l, stringBuffer);
                break;
            }
            case 13: {
                RubyElementLabels.getFieldLabel((IField)iRubyElement, l, stringBuffer);
                break;
            }
            case 10: {
                RubyElementLabels.getLocalVariableLabel((IField)iRubyElement, l, stringBuffer);
                break;
            }
            case 3: {
                RubyElementLabels.getTypeLabel((IType)iRubyElement, l, stringBuffer);
                break;
            }
            case 2: {
                RubyElementLabels.getCompilationUnitLabel((IRubyScript)iRubyElement, l, stringBuffer);
                break;
            }
            case 6: 
            case 14: {
                RubyElementLabels.getDeclarationLabel(iRubyElement, l, stringBuffer);
                break;
            }
            case 0: 
            case 1: {
                stringBuffer.append(iRubyElement.getElementName());
                break;
            }
            default: {
                stringBuffer.append(iRubyElement.getElementName());
            }
        }
    }

    public static void getMethodLabel(IMethod iMethod, long l, StringBuffer stringBuffer) {
        try {
            if (RubyElementLabels.getFlag(l, 128L) && iMethod.getDeclaringType() != null) {
                RubyElementLabels.getTypeLabel(iMethod.getDeclaringType(), 0x40000L | l & 0x1002000000000L, stringBuffer);
                stringBuffer.append('.');
            }
            stringBuffer.append(iMethod.getElementName());
            stringBuffer.append('(');
            if (RubyElementLabels.getFlag(l, 2L)) {
                String[] stringArray = null;
                int n = 0;
                String[] stringArray2 = null;
                if (RubyElementLabels.getFlag(l, 2L) && iMethod.exists()) {
                    stringArray2 = iMethod.getParameterNames();
                    if (stringArray == null) {
                        n = stringArray2.length;
                    } else if (n != stringArray2.length) {
                        stringArray2 = null;
                    }
                }
                int n2 = 0;
                while (n2 < n) {
                    if (n2 > 0) {
                        stringBuffer.append(COMMA_STRING);
                    }
                    if (stringArray2 != null) {
                        stringBuffer.append(stringArray2[n2]);
                    }
                    ++n2;
                }
            }
            stringBuffer.append(')');
            if (RubyElementLabels.getFlag(l, 256L) && iMethod.getDeclaringType() != null) {
                stringBuffer.append(CONCAT_STRING);
                RubyElementLabels.getTypeLabel(iMethod.getDeclaringType(), 0x40000L | l & 0x1002000000000L, stringBuffer);
            }
        }
        catch (RubyModelException rubyModelException) {
            RubyPlugin.log(rubyModelException);
        }
    }

    public static void getFieldLabel(IField iField, long l, StringBuffer stringBuffer) {
        if (RubyElementLabels.getFlag(l, 65536L)) {
            RubyElementLabels.getTypeLabel(iField.getDeclaringType(), 0x40000L | l & 0x1002000000000L, stringBuffer);
            stringBuffer.append('.');
        }
        stringBuffer.append(iField.getElementName());
        if (RubyElementLabels.getFlag(l, 131072L)) {
            stringBuffer.append(CONCAT_STRING);
            RubyElementLabels.getTypeLabel(iField.getDeclaringType(), 0x40000L | l & 0x1002000000000L, stringBuffer);
        }
    }

    public static void getLocalVariableLabel(IField iField, long l, StringBuffer stringBuffer) {
        if (RubyElementLabels.getFlag(l, 65536L)) {
            RubyElementLabels.getElementLabel(iField.getParent(), 0x40080L | l & 0x1002000000000L, stringBuffer);
            stringBuffer.append('.');
        }
        stringBuffer.append(iField.getElementName());
        if (RubyElementLabels.getFlag(l, 131072L)) {
            stringBuffer.append(CONCAT_STRING);
            RubyElementLabels.getElementLabel(iField.getParent(), 0x40080L | l & 0x1002000000000L, stringBuffer);
        }
    }

    public static void getTypeLabel(IType iType, long l, StringBuffer stringBuffer) {
        int n;
        Object object;
        RubyElementLabels.getFlag(l, 262144L);
        if (RubyElementLabels.getFlag(l, 786432L)) {
            object = iType.getDeclaringType();
            if (object != null) {
                RubyElementLabels.getTypeLabel((IType)object, 0x80000L | l & 0x1002000000000L, stringBuffer);
                stringBuffer.append('.');
            }
            if ((n = iType.getParent().getElementType()) == 4 || n == 13) {
                RubyElementLabels.getElementLabel(iType.getParent(), 0L, stringBuffer);
                stringBuffer.append('.');
            }
        }
        if (((String)(object = iType.getElementName())).length() == 0) {
            try {
                String string = iType.getSuperclassName();
                object = Messages.format(RubyUIMessages.RubyElementLabels_anonym_type, string);
            }
            catch (RubyModelException rubyModelException) {
                object = RubyUIMessages.RubyElementLabels_anonym;
            }
        }
        stringBuffer.append((String)object);
        if (RubyElementLabels.getFlag(l, 0x400000000000L)) {
            stringBuffer.append(" [");
            stringBuffer.append(iType.getPath().makeRelative().toOSString());
            try {
                n = iType.getNameRange().getOffset();
                stringBuffer.append(", offset: ");
                stringBuffer.append(n);
            }
            catch (RubyModelException rubyModelException) {
                rubyModelException.printStackTrace();
            }
            stringBuffer.append("] ");
        }
        if (RubyElementLabels.getFlag(l, 0x100000L)) {
            stringBuffer.append(CONCAT_STRING);
            IType iType2 = iType.getDeclaringType();
            if (iType2 != null) {
                RubyElementLabels.getTypeLabel(iType2, 0x40000L | l & 0x1002000000000L, stringBuffer);
                int n2 = iType.getParent().getElementType();
                if (n2 == 4 || n2 == 13) {
                    stringBuffer.append('.');
                    RubyElementLabels.getElementLabel(iType.getParent(), 0L, stringBuffer);
                }
            }
        }
    }

    public static void getDeclarationLabel(IRubyElement iRubyElement, long l, StringBuffer stringBuffer) {
        IRubyElement iRubyElement2;
        if (RubyElementLabels.getFlag(l, 0x1000000L) && (iRubyElement2 = (IRubyElement)iRubyElement.getOpenable()) != null) {
            stringBuffer.append(RubyElementLabels.getElementLabel(iRubyElement2, 0x88000000L | l & 0x1002000000000L));
            stringBuffer.append('/');
        }
        if (iRubyElement.getElementType() == 14) {
            stringBuffer.append(RubyUIMessages.RubyElementLabels_import_container);
        } else {
            stringBuffer.append(iRubyElement.getElementName());
        }
        if (RubyElementLabels.getFlag(l, 0x2000000L) && (iRubyElement2 = (IRubyElement)iRubyElement.getOpenable()) != null) {
            stringBuffer.append(CONCAT_STRING);
            stringBuffer.append(RubyElementLabels.getElementLabel(iRubyElement2, 0x88000000L | l & 0x1002000000000L));
        }
    }

    public static void getCompilationUnitLabel(IRubyScript iRubyScript, long l, StringBuffer stringBuffer) {
        RubyElementLabels.getFlag(l, 0x80000000L);
        stringBuffer.append(iRubyScript.getElementName());
        if (RubyElementLabels.getFlag(l, 0x100000000L)) {
            stringBuffer.append(CONCAT_STRING);
        }
    }
}

