/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.rubypeople.rdt.internal.ui.preferences.AbstractConfigurationBlock;
import org.rubypeople.rdt.internal.ui.preferences.OverlayPreferenceStore;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;

class RubyEditorAppearanceConfigurationBlock
extends AbstractConfigurationBlock {
    private final String[][] fAppearanceColorListModel;
    private List fAppearanceColorList;
    private ColorSelector fAppearanceColorEditor;
    private Button fAppearanceColorDefault;
    private FontMetrics fFontMetrics;

    public RubyEditorAppearanceConfigurationBlock(PreferencePage preferencePage, OverlayPreferenceStore overlayPreferenceStore) {
        super(overlayPreferenceStore, preferencePage);
        String[][] stringArrayArray = new String[7][];
        String[] stringArray = new String[3];
        stringArray[0] = PreferencesMessages.RubyEditorPreferencePage_matchingBracketsHighlightColor2;
        stringArray[1] = "matchingBracketsColor";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = PreferencesMessages.RubyEditorPreferencePage_backgroundForCompletionProposals;
        stringArray2[1] = "content_assist_proposals_background";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = PreferencesMessages.RubyEditorPreferencePage_foregroundForCompletionProposals;
        stringArray3[1] = "content_assist_proposals_foreground";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = PreferencesMessages.RubyEditorPreferencePage_backgroundForMethodParameters;
        stringArray4[1] = "content_assist_parameters_background";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = PreferencesMessages.RubyEditorPreferencePage_foregroundForMethodParameters;
        stringArray5[1] = "content_assist_parameters_foreground";
        stringArrayArray[4] = stringArray5;
        String[] stringArray6 = new String[3];
        stringArray6[0] = PreferencesMessages.RubyEditorPreferencePage_backgroundForCompletionReplacement;
        stringArray6[1] = "content_assist_completion_replacement_background";
        stringArrayArray[5] = stringArray6;
        String[] stringArray7 = new String[3];
        stringArray7[0] = PreferencesMessages.RubyEditorPreferencePage_foregroundForCompletionReplacement;
        stringArray7[1] = "content_assist_completion_replacement_foreground";
        stringArrayArray[6] = stringArray7;
        this.fAppearanceColorListModel = stringArrayArray;
        this.getPreferenceStore().addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "matchingBracketsColor"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "matchingBrackets"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "handleTemporaryProblems"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_background"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_foreground"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_background"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_foreground"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_completion_replacement_background"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_completion_replacement_foreground"));
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    public Control createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        this.createHeader(composite2);
        this.createAppearancePage(composite2);
        return composite2;
    }

    private void createHeader(Composite composite) {
        final Shell shell = composite.getShell();
        String string = PreferencesMessages.RubyEditorPreferencePage_link;
        Link link = new Link(composite, 0);
        link.setText(string);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.ui.preferencePages.GeneralTextEditor", null, null);
            }
        });
        link.setToolTipText(PreferencesMessages.RubyEditorPreferencePage_link_tooltip);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        link.setLayoutData((Object)gridData);
        this.addFiller(composite);
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
    }

    protected int convertWidthInCharsToPixels(int n) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)n);
    }

    protected int convertHeightInCharsToPixels(int n) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)n);
    }

    private Control createAppearancePage(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        String string = PreferencesMessages.RubyEditorPreferencePage_analyseAnnotationsWhileTyping;
        this.addCheckBox(composite2, string, "handleTemporaryProblems", 0);
        String string2 = PreferencesMessages.SmartTypingConfigurationBlock_annotationReporting_link;
        this.addLink(composite2, string2, 20);
        Label label = new Label(composite2, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        gridData.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
        string = PreferencesMessages.RubyEditorPreferencePage_highlightMatchingBrackets;
        this.addCheckBox(composite2, string, "matchingBrackets", 0);
        Label label2 = new Label(composite2, 16384);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        gridData.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        label2.setLayoutData((Object)gridData);
        label2 = new Label(composite2, 16384);
        label2.setText(PreferencesMessages.RubyEditorPreferencePage_appearanceOptions);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        label2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData(1296);
        gridData.horizontalSpan = 2;
        composite3.setLayoutData((Object)gridData);
        this.fAppearanceColorList = new List(composite3, 2564);
        gridData = new GridData(770);
        gridData.heightHint = this.convertHeightInCharsToPixels(12);
        this.fAppearanceColorList.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)new GridData(1808));
        label2 = new Label(composite4, 16384);
        label2.setText(PreferencesMessages.RubyEditorPreferencePage_color);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label2.setLayoutData((Object)gridData);
        this.fAppearanceColorEditor = new ColorSelector(composite4);
        Button button = this.fAppearanceColorEditor.getButton();
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        button.setLayoutData((Object)gridData);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = RubyEditorAppearanceConfigurationBlock.this.fAppearanceColorDefault.getSelection();
                RubyEditorAppearanceConfigurationBlock.this.fAppearanceColorEditor.getButton().setEnabled(!bl);
                int n = RubyEditorAppearanceConfigurationBlock.this.fAppearanceColorList.getSelectionIndex();
                if (n == -1) {
                    return;
                }
                String string = RubyEditorAppearanceConfigurationBlock.this.fAppearanceColorListModel[n][2];
                if (string != null) {
                    RubyEditorAppearanceConfigurationBlock.this.getPreferenceStore().setValue(string, bl);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        this.fAppearanceColorDefault = new Button(composite4, 32);
        this.fAppearanceColorDefault.setText(PreferencesMessages.RubyEditorPreferencePage_systemDefault);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 2;
        this.fAppearanceColorDefault.setLayoutData((Object)gridData);
        this.fAppearanceColorDefault.setVisible(false);
        this.fAppearanceColorDefault.addSelectionListener(selectionListener);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                RubyEditorAppearanceConfigurationBlock.this.handleAppearanceColorListSelection();
            }
        });
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = RubyEditorAppearanceConfigurationBlock.this.fAppearanceColorList.getSelectionIndex();
                if (n == -1) {
                    return;
                }
                String string = RubyEditorAppearanceConfigurationBlock.this.fAppearanceColorListModel[n][1];
                PreferenceConverter.setValue((IPreferenceStore)RubyEditorAppearanceConfigurationBlock.this.getPreferenceStore(), (String)string, (RGB)RubyEditorAppearanceConfigurationBlock.this.fAppearanceColorEditor.getColorValue());
            }
        });
        return composite2;
    }

    private void addLink(Composite composite, String string, int n) {
        final Link link = new Link(composite, 0);
        link.setText(string);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 300;
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = n;
        link.setLayoutData((Object)gridData);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)selectionEvent.text, null, null);
            }
        });
    }

    private void handleAppearanceColorListSelection() {
        int n = this.fAppearanceColorList.getSelectionIndex();
        if (n == -1) {
            return;
        }
        String string = this.fAppearanceColorListModel[n][1];
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)string);
        this.fAppearanceColorEditor.setColorValue(rGB);
        this.updateAppearanceColorWidgets(this.fAppearanceColorListModel[n][2]);
    }

    private void updateAppearanceColorWidgets(String string) {
        if (string == null) {
            this.fAppearanceColorDefault.setSelection(false);
            this.fAppearanceColorDefault.setVisible(false);
            this.fAppearanceColorEditor.getButton().setEnabled(true);
        } else {
            boolean bl = this.getPreferenceStore().getBoolean(string);
            this.fAppearanceColorDefault.setSelection(bl);
            this.fAppearanceColorDefault.setVisible(true);
            this.fAppearanceColorEditor.getButton().setEnabled(!bl);
        }
    }

    public void initialize() {
        super.initialize();
        int n = 0;
        while (n < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[n][0]);
            ++n;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (RubyEditorAppearanceConfigurationBlock.this.fAppearanceColorList != null && !RubyEditorAppearanceConfigurationBlock.this.fAppearanceColorList.isDisposed()) {
                    RubyEditorAppearanceConfigurationBlock.this.fAppearanceColorList.select(0);
                    RubyEditorAppearanceConfigurationBlock.this.handleAppearanceColorListSelection();
                }
            }
        });
    }

    public void performDefaults() {
        super.performDefaults();
        this.handleAppearanceColorListSelection();
    }

    protected void initializeDialogUnits(Control control) {
        GC gC = new GC((Drawable)control);
        gC.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gC.getFontMetrics();
        gC.dispose();
    }
}

