/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.util;

import org.rubypeople.rdt.internal.core.util.CharOperation;

public final class SimpleWordSet {
    public char[][] words;
    public int elementSize = 0;
    public int threshold;

    public SimpleWordSet(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.5f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.words = new char[n2][];
    }

    public char[] add(char[] cArray) {
        char[] cArray2;
        int n = this.words.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        while ((cArray2 = this.words[n2]) != null) {
            if (CharOperation.equals(cArray2, cArray)) {
                return cArray2;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.words[n2] = cArray;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return cArray;
    }

    public boolean includes(char[] cArray) {
        char[] cArray2;
        int n = this.words.length;
        int n2 = CharOperation.hashCode(cArray) % n;
        while ((cArray2 = this.words[n2]) != null) {
            if (CharOperation.equals(cArray2, cArray)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    private void rehash() {
        SimpleWordSet simpleWordSet = new SimpleWordSet(this.elementSize * 2);
        int n = this.words.length;
        while (--n >= 0) {
            char[] cArray = this.words[n];
            if (cArray == null) continue;
            simpleWordSet.add(cArray);
        }
        this.words = simpleWordSet.words;
        this.elementSize = simpleWordSet.elementSize;
        this.threshold = simpleWordSet.threshold;
    }
}

