/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.IProblemRequestor;
import org.rubypeople.rdt.core.parser.IProblem;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.parser.Error;
import org.rubypeople.rdt.internal.core.parser.RdtWarnings;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.parser.TaskParser;

public class RubyScriptProblemFinder {
    public static void process(RubyScript rubyScript, char[] cArray, IProblemRequestor iProblemRequestor, IProgressMonitor iProgressMonitor) {
        RdtWarnings rdtWarnings = new RdtWarnings();
        RubyParser rubyParser = new RubyParser(rdtWarnings);
        String string = new String(cArray);
        try {
            rubyParser.parse((IFile)rubyScript.getUnderlyingResource(), new StringReader(string));
        }
        catch (SyntaxException syntaxException) {
            iProblemRequestor.acceptProblem(new Error(syntaxException.getPosition(), "Syntax Error"));
        }
        TaskParser taskParser = new TaskParser(rubyScript.getRubyProject().getOptions(true));
        taskParser.parse(string);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(rdtWarnings.getWarnings());
        arrayList.addAll(taskParser.getTasks());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IProblem iProblem = (IProblem)iterator.next();
            iProblemRequestor.acceptProblem(iProblem);
        }
    }
}

