/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.views;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.internal.core.symbols.ClassSymbol;
import org.rubypeople.rdt.internal.core.symbols.ISymbolFinder;
import org.rubypeople.rdt.internal.core.symbols.Location;
import org.rubypeople.rdt.internal.core.symbols.MethodSymbol;
import org.rubypeople.rdt.internal.core.symbols.Symbol;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.dialogs.ElementListSelectionDialog;
import org.rubypeople.rdt.internal.ui.util.PositionBasedEditorOpener;
import org.rubypeople.rdt.testunit.views.TestUnitMessages;

public class OpenSymbolAction
extends Action
implements IAction {
    private final Symbol symbol;
    private final ISymbolFinder finder;
    private final Shell shell;
    private String dialogTitle;

    public static IAction forClass(String string, ISymbolFinder iSymbolFinder, Shell shell) {
        return new OpenSymbolAction((Symbol)new ClassSymbol(string), iSymbolFinder, shell, "Open Class");
    }

    public static IAction forMethod(String string, String string2, ISymbolFinder iSymbolFinder, Shell shell) {
        return new OpenSymbolAction((Symbol)new MethodSymbol(string, string2), iSymbolFinder, shell, "Open Method");
    }

    public OpenSymbolAction(Symbol symbol, ISymbolFinder iSymbolFinder, Shell shell, String string) {
        super(TestUnitMessages.getString("OpenEditor.action.label"));
        this.shell = shell;
        this.symbol = symbol;
        this.finder = iSymbolFinder;
        this.dialogTitle = string;
    }

    public void run() {
        ElementListSelectionDialog elementListSelectionDialog;
        Location location;
        Set set = this.finder.find(this.symbol);
        if (set.size() == 0) {
            return;
        }
        if (set.size() == 1) {
            location = (Location)set.iterator().next();
        } else {
            elementListSelectionDialog = new ElementListSelectionDialog(this.shell, (ILabelProvider)new LocationLabel());
            elementListSelectionDialog.setElements(set.toArray());
            elementListSelectionDialog.setMessage("Select a location");
            elementListSelectionDialog.setTitle(this.dialogTitle);
            elementListSelectionDialog.open();
            if (elementListSelectionDialog.getReturnCode() == 256) {
                return;
            }
            location = (Location)elementListSelectionDialog.getResult()[0];
        }
        elementListSelectionDialog = new PositionBasedEditorOpener(location.getFilename(), location.getPosition());
        elementListSelectionDialog.open();
    }

    private final class LocationLabel
    implements ILabelProvider {
        LocationLabel() {
        }

        public Image getImage(Object object) {
            return RubyPluginImages.get((String)"org.rubypeople.rdt.ui.ruby_page.gif");
        }

        public String getText(Object object) {
            Location location = (Location)object;
            IFile iFile = location.getSourceFile();
            return String.valueOf(iFile.getName()) + ":" + location.getPosition().getStartLine() + " - " + iFile.getFullPath().removeLastSegments(1);
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

