/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ForwardDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.obl.NonexistentObligationException;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationFactory;
import edu.umd.cs.findbugs.ba.obl.ObligationSet;
import edu.umd.cs.findbugs.ba.obl.PolicyDatabase;
import edu.umd.cs.findbugs.ba.obl.State;
import edu.umd.cs.findbugs.ba.obl.StateSet;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObligationAnalysis
extends ForwardDataflowAnalysis<StateSet> {
    private static final boolean DEBUG = SystemProperties.getBoolean("oa.debug");
    private TypeDataflow typeDataflow;
    private MethodGen methodGen;
    private ObligationFactory factory;
    private PolicyDatabase database;
    private RepositoryLookupFailureCallback lookupFailureCallback;

    public ObligationAnalysis(DepthFirstSearch dfs, TypeDataflow typeDataflow, MethodGen methodGen, ObligationFactory factory, PolicyDatabase database, RepositoryLookupFailureCallback lookupFailureCallback) {
        super(dfs);
        this.typeDataflow = typeDataflow;
        this.methodGen = methodGen;
        this.factory = factory;
        this.database = database;
        this.lookupFailureCallback = lookupFailureCallback;
    }

    @Override
    public StateSet createFact() {
        return new StateSet(this.factory);
    }

    @Override
    public boolean isFactValid(StateSet fact) {
        return fact.isValid();
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, StateSet fact) throws DataflowAnalysisException {
        Obligation obligation = this.addsObligation(handle);
        if (obligation != null) {
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Adding obligation ").append(obligation.toString()).toString());
            }
            fact.addObligation(obligation);
        } else {
            obligation = this.deletesObligation(handle);
            if (obligation != null) {
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("Deleting obligation ").append(obligation.toString()).toString());
                }
                this.deleteObligation(fact, obligation, handle);
            }
        }
    }

    @Override
    public void transfer(BasicBlock basicBlock, @CheckForNull InstructionHandle end, StateSet start, StateSet result) throws DataflowAnalysisException {
        super.transfer(basicBlock, end, start, result);
        this.endTransfer(basicBlock, end, result);
    }

    public void endTransfer(BasicBlock basicBlock, @CheckForNull InstructionHandle end, StateSet result) throws DataflowAnalysisException {
        Iterator<State> i = result.stateIterator();
        while (i.hasNext()) {
            State state = i.next();
            state.getPath().append(basicBlock.getId());
        }
    }

    private Obligation addsObligation(InstructionHandle handle) {
        return this.addsOrDeletesObligation(handle, 0);
    }

    private Obligation deletesObligation(InstructionHandle handle) {
        return this.addsOrDeletesObligation(handle, 1);
    }

    private Obligation addsOrDeletesObligation(InstructionHandle handle, int action) {
        boolean isStatic;
        Instruction ins = handle.getInstruction();
        if (!(ins instanceof InvokeInstruction)) {
            return null;
        }
        InvokeInstruction inv = (InvokeInstruction)ins;
        ConstantPoolGen cpg = this.methodGen.getConstantPool();
        String className = inv.getClassName(cpg);
        String methodName = inv.getName(cpg);
        String signature = inv.getSignature(cpg);
        boolean bl = isStatic = inv.getOpcode() == 184;
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Checking instruction: ").append(handle).toString());
            System.out.println(new StringBuffer().append("  class    =").append(className).toString());
            System.out.println(new StringBuffer().append("  method   =").append(methodName).toString());
            System.out.println(new StringBuffer().append("  signature=").append(signature).toString());
        }
        try {
            return this.database.lookup(className, methodName, signature, isStatic, action);
        }
        catch (ClassNotFoundException e) {
            this.lookupFailureCallback.reportMissingClass(e);
            return null;
        }
    }

    private void deleteObligation(StateSet fact, Obligation obligation, InstructionHandle handle) throws DataflowAnalysisException {
        try {
            fact.deleteObligation(obligation);
        }
        catch (NonexistentObligationException e) {
            throw new DataflowAnalysisException(new StringBuffer().append("Removing nonexistent obligation of type ").append(obligation.toString()).toString(), this.methodGen, handle, e);
        }
    }

    @Override
    public void copy(StateSet src, StateSet dest) {
        dest.copyFrom(src);
    }

    @Override
    public void initEntryFact(StateSet fact) throws DataflowAnalysisException {
        fact.initEntryFact(this.factory);
    }

    @Override
    public void initResultFact(StateSet fact) {
        fact.setTop();
    }

    @Override
    public void makeFactTop(StateSet fact) {
        fact.setTop();
    }

    @Override
    public boolean isTop(StateSet fact) {
        return fact.isTop();
    }

    @Override
    public boolean same(StateSet a, StateSet b) {
        return a.equals(b);
    }

    @Override
    public void meetInto(StateSet fact, Edge edge, StateSet result) throws DataflowAnalysisException {
        StateSet inputFact;
        Obligation obligation;
        BasicBlock sourceBlock;
        InstructionHandle handle;
        Obligation obligation2;
        if (edge.isExceptionEdge() && fact.isValid() && (obligation2 = this.deletesObligation(handle = (sourceBlock = (BasicBlock)edge.getSource()).getExceptionThrower())) != null) {
            fact = fact.duplicate();
            this.deleteObligation(fact, obligation2, handle);
        }
        if (this.isPossibleIfComparison(edge) && (obligation = this.comparesObligationTypeToNull(edge)) != null) {
            fact = fact.duplicate();
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Deleting ").append(obligation.toString()).append(" on edge from comparision ").append(((BasicBlock)edge.getSource()).getLastInstruction()).toString());
            }
            this.deleteObligation(fact, obligation, ((BasicBlock)edge.getSource()).getLastInstruction());
        }
        if (!(inputFact = fact).isTop() && !result.isBottom()) {
            if (inputFact.isBottom() || result.isTop()) {
                this.copy(inputFact, result);
            } else {
                final Map<ObligationSet, State> updatedStateMap = result.createEmptyMap();
                Iterator<State> i = inputFact.stateIterator();
                while (i.hasNext()) {
                    State otherState = i.next();
                    if (result.getStateWithObligationSet(otherState.getObligationSet()) != null) continue;
                    State dup = otherState.duplicate();
                    updatedStateMap.put(dup.getObligationSet(), dup);
                }
                StateSet.StateCallback callback = new StateSet.StateCallback(){

                    public void apply(State state) throws NonexistentObligationException {
                        State matchingState = inputFact.getStateWithObligationSet(state.getObligationSet());
                        if (matchingState != null && state.getPath().getLength() > matchingState.getPath().getLength()) {
                            state.getPath().copyFrom(matchingState.getPath());
                        }
                        updatedStateMap.put(state.getObligationSet(), state);
                    }
                };
                try {
                    result.applyToAllStatesAndUpdateMap(callback, updatedStateMap);
                }
                catch (NonexistentObligationException e) {
                    throw new DataflowAnalysisException("This shouldn't happen", e);
                }
            }
        }
    }

    private boolean isPossibleIfComparison(Edge edge) {
        return edge.getType() == 1 || edge.getType() == 0;
    }

    private Obligation comparesObligationTypeToNull(Edge edge) throws DataflowAnalysisException {
        Type type;
        BasicBlock sourceBlock = (BasicBlock)edge.getSource();
        InstructionHandle last = sourceBlock.getLastInstruction();
        if (last == null) {
            return null;
        }
        short opcode = last.getInstruction().getOpcode();
        switch (opcode) {
            case 198: 
            case 199: {
                if (edge.getType() == 1 && opcode == 199 || edge.getType() == 0 && opcode == 198) {
                    return null;
                }
                Location location = new Location(last, sourceBlock);
                TypeFrame typeFrame = this.typeDataflow.getFactAtLocation(location);
                type = (Type)typeFrame.getTopValue();
                break;
            }
            default: {
                return null;
            }
        }
        if (!(type instanceof ObjectType)) {
            return null;
        }
        try {
            return this.factory.getObligationByType((ObjectType)type);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            throw new DataflowAnalysisException("Subtype query failed during ObligationAnalysis", e);
        }
    }

    @Override
    public /* synthetic */ void transfer(BasicBlock x0, InstructionHandle x1, Object x2, Object x3) throws DataflowAnalysisException {
        this.transfer(x0, x1, (StateSet)x2, (StateSet)x3);
    }

    @Override
    public /* synthetic */ boolean isFactValid(Object x0) {
        return this.isFactValid((StateSet)x0);
    }

    @Override
    public /* synthetic */ void transferInstruction(InstructionHandle x0, BasicBlock x1, Object x2) throws DataflowAnalysisException {
        this.transferInstruction(x0, x1, (StateSet)x2);
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((StateSet)x0, x1, (StateSet)x2);
    }

    @Override
    public /* synthetic */ boolean same(Object x0, Object x1) {
        return this.same((StateSet)x0, (StateSet)x1);
    }

    @Override
    public /* synthetic */ boolean isTop(Object x0) {
        return this.isTop((StateSet)x0);
    }

    @Override
    public /* synthetic */ void makeFactTop(Object x0) {
        this.makeFactTop((StateSet)x0);
    }

    @Override
    public /* synthetic */ void initResultFact(Object x0) {
        this.initResultFact((StateSet)x0);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((StateSet)x0);
    }

    @Override
    public /* synthetic */ void copy(Object x0, Object x1) {
        this.copy((StateSet)x0, (StateSet)x1);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }
}

