/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;

public class DebugRepositoryLookupFailureCallback
implements RepositoryLookupFailureCallback {
    @SuppressWarnings(value={"DM_EXIT"})
    public void reportMissingClass(ClassNotFoundException ex) {
        System.out.println("Missing class");
        ex.printStackTrace();
        System.exit(1);
    }

    @SuppressWarnings(value={"DM_EXIT"})
    public void reportMissingClass(ClassDescriptor classDescriptor) {
        System.out.println("Missing class: " + classDescriptor);
        System.exit(1);
    }

    @SuppressWarnings(value={"DM_EXIT"})
    public void logError(String message) {
        System.err.println("Error: " + message);
        System.exit(1);
    }

    @SuppressWarnings(value={"DM_EXIT"})
    public void logError(String message, Throwable e) {
        if (e instanceof MissingClassException) {
            MissingClassException missingClassEx = (MissingClassException)e;
            ClassNotFoundException cnfe = missingClassEx.getClassNotFoundException();
            this.reportMissingClass(cnfe);
            return;
        }
        if (e instanceof MethodUnprofitableException) {
            return;
        }
        System.err.println("Error: " + message);
        e.printStackTrace();
        System.exit(1);
    }

    public void reportSkippedAnalysis(MethodDescriptor method) {
        System.err.println("Skipping " + method);
    }
}

