/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanelBuilder;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.RelationshipEditPanel;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EditRelationshipAction
extends AbstractAction
implements SelectionListener {
    private static final Logger logger = Logger.getLogger(EditRelationshipAction.class);
    protected PlayPen pp;
    protected DBTree dbt;

    public EditRelationshipAction() {
        super("Relationship Properties", ASUtils.createIcon("RelationshipProperties", "Relationship Properties", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "Relationship Properties");
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("PlayPen")) {
            List<PlayPenComponent> selection = this.pp.getSelectedItems();
            if (selection.size() < 1) {
                JOptionPane.showMessageDialog(this.pp, "Select a relationship (by clicking on it) and try again.");
            } else if (selection.size() > 1) {
                JOptionPane.showMessageDialog(this.pp, "You have selected multiple items, but you can only edit one at a time.");
            } else if (selection.get(0) instanceof Relationship) {
                Relationship r = (Relationship)selection.get(0);
                this.makeDialog(r.getModel());
            } else {
                JOptionPane.showMessageDialog(this.pp, "Please select the relationship you would like to edit.");
            }
        } else if (evt.getActionCommand().equals("DBTree")) {
            TreePath[] selections = this.dbt.getSelectionPaths();
            if (selections.length != 1) {
                JOptionPane.showMessageDialog(this.dbt, "Please select the relationship you would like to edit.");
            } else {
                TreePath tp = selections[0];
                SQLObject so = (SQLObject)tp.getLastPathComponent();
                if (so instanceof SQLRelationship) {
                    SQLRelationship sr = (SQLRelationship)so;
                    this.makeDialog(sr);
                } else {
                    JOptionPane.showMessageDialog(this.dbt, "Please select the relationship you would like to edit.");
                }
            }
        }
    }

    private void makeDialog(SQLRelationship sqr) {
        logger.debug((Object)"making edit relationship dialog");
        RelationshipEditPanel editPanel = new RelationshipEditPanel();
        JDialog d = ArchitectPanelBuilder.createArchitectPanelDialog(editPanel, ArchitectFrame.getMainInstance(), "Relationship Properties", "OK");
        editPanel.setRelationship(sqr);
        d.pack();
        d.setLocationRelativeTo(ArchitectFrame.getMainInstance());
        d.setVisible(true);
    }

    public void setPlayPen(PlayPen pp) {
        if (this.pp != null) {
            this.pp.removeSelectionListener(this);
        }
        this.pp = pp;
        pp.addSelectionListener(this);
        this.setupAction(pp.getSelectedItems());
    }

    public void setDBTree(DBTree newDBT) {
        this.dbt = newDBT;
    }

    public void setupAction(List selectedItems) {
        if (selectedItems.size() == 0) {
            this.setEnabled(false);
            logger.debug((Object)"Disabling edit relationship");
            this.putValue("ShortDescription", "Edit Relationship");
        } else {
            Selectable item = (Selectable)selectedItems.get(0);
            if (item instanceof Relationship) {
                this.setEnabled(true);
            }
        }
    }

    public void itemSelected(SelectionEvent e) {
        this.setupAction(this.pp.getSelectedItems());
    }

    public void itemDeselected(SelectionEvent e) {
        this.setupAction(this.pp.getSelectedItems());
    }
}

