/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.Monitorable;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.diff.ArchitectDiffException;
import ca.sqlpower.architect.diff.CompareSQL;
import ca.sqlpower.architect.diff.DiffChunk;
import ca.sqlpower.architect.diff.DiffType;
import ca.sqlpower.architect.qfa.ArchitectExceptionReportFactory;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanelBuilder;
import ca.sqlpower.architect.swingui.ArchitectSwingWorker;
import ca.sqlpower.architect.swingui.CompareDMFrame;
import ca.sqlpower.architect.swingui.CompareDMSettings;
import ca.sqlpower.architect.swingui.ConnectionComboBoxModel;
import ca.sqlpower.architect.swingui.DBCSPanel;
import ca.sqlpower.architect.swingui.DBConnectionCallBack;
import ca.sqlpower.architect.swingui.DataSourceRenderer;
import ca.sqlpower.architect.swingui.ListerProgressBarUpdater;
import ca.sqlpower.architect.swingui.Populator;
import ca.sqlpower.architect.swingui.ProgressWatcher;
import ca.sqlpower.architect.swingui.SQLScriptDialog;
import ca.sqlpower.architect.swingui.SwingUIProject;
import ca.sqlpower.architect.swingui.action.DBCSOkAction;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class CompareDMPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(CompareDMPanel.class);
    private static final String OUTPUT_ENGLISH = "OUTPUT_ENGLISH";
    private static final String OUTPUT_SQL = "OUTPUT_SQL";
    public static final String DBCS_DIALOG_TITLE = "New Database Connection";
    private JProgressBar progressBar;
    private JPanel buttonPanel;
    private JComboBox sqlTypeDropdown;
    private JRadioButton sqlButton;
    private JRadioButton englishButton;
    private JLabel statusLabel;
    private StartCompareAction startCompareAction;
    private SourceOrTargetStuff source = new SourceOrTargetStuff();
    private SourceOrTargetStuff target = new SourceOrTargetStuff();
    private SwingUIProject project;
    private ArchitectSession session;
    private ListCellRenderer dataSourceRenderer = new DataSourceRenderer();

    public boolean isStartable() {
        logger.debug((Object)"isStartable is checking...");
        return this.source.isThisPartStartable() && this.target.isThisPartStartable() && (!this.source.playPenRadio.isSelected() || !this.sqlButton.isSelected());
    }

    public Action getStartCompareAction() {
        return this.startCompareAction;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public CompareDMPanel(SwingUIProject project, ArchitectSession session) {
        this.project = project;
        this.session = session;
        this.buildUI();
    }

    private void buildUI() {
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        this.sqlTypeDropdown = new JComboBox<ASUtils.LabelValueBean>(DDLUtils.getDDLTypes());
        this.sqlTypeDropdown.setName("sqlTypeDropDown");
        OutputChoiceListener listener = new OutputChoiceListener(this.sqlTypeDropdown);
        this.sqlButton = new JRadioButton();
        this.sqlButton.setName(OUTPUT_SQL);
        this.sqlButton.setActionCommand(OUTPUT_SQL);
        this.sqlButton.setSelected(false);
        this.sqlButton.addActionListener(listener);
        this.englishButton = new JRadioButton();
        this.englishButton.setName("englishButton");
        this.englishButton.setActionCommand(OUTPUT_ENGLISH);
        this.englishButton.setSelected(true);
        this.englishButton.addActionListener(listener);
        ButtonGroup outputGroup = new ButtonGroup();
        outputGroup.add(this.sqlButton);
        outputGroup.add(this.englishButton);
        this.startCompareAction = new StartCompareAction();
        this.startCompareAction.setEnabled(false);
        this.buttonPanel = new JPanel(new FlowLayout(2));
        FormLayout formLayout = new FormLayout("20dlu, 2dlu, pref, 4dlu,0:grow, 4dlu, 0:grow, 4dlu,0:grow, 4dlu, pref", "");
        formLayout.setColumnGroups((int[][])new int[][]{{5, 7, 9}});
        Object panel = logger.isDebugEnabled() ? new FormDebugPanel() : new JPanel();
        DefaultFormBuilder builder = new DefaultFormBuilder(formLayout, (JPanel)panel);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.appendSeparator("Compare Older");
        builder.nextLine();
        builder.append("");
        this.source.buildPartialUI(builder, true);
        builder.appendSeparator("With Newer");
        builder.appendRow(builder.getLineGapSpec());
        builder.appendRow("pref");
        builder.nextLine(2);
        builder.append("");
        this.target.buildPartialUI(builder, false);
        ActionListener radioButtonActionEnabler = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
            }
        };
        this.source.playPenRadio.addActionListener(radioButtonActionEnabler);
        this.source.physicalRadio.addActionListener(radioButtonActionEnabler);
        this.source.loadRadio.addActionListener(radioButtonActionEnabler);
        this.target.playPenRadio.addActionListener(radioButtonActionEnabler);
        this.target.physicalRadio.addActionListener(radioButtonActionEnabler);
        this.target.loadRadio.addActionListener(radioButtonActionEnabler);
        builder.appendSeparator("Output Format");
        builder.appendRow(builder.getLineGapSpec());
        builder.appendRow("pref");
        builder.nextLine(2);
        builder.nextColumn(2);
        builder.append((Component)this.sqlButton);
        JPanel ddlTypePanel = new JPanel(new BorderLayout(3, 3));
        ddlTypePanel.add((Component)new JLabel("SQL for "), "West");
        ddlTypePanel.add((Component)this.sqlTypeDropdown, "Center");
        ddlTypePanel.add((Component)new JLabel(" to make Older look like Newer"), "East");
        builder.append((Component)ddlTypePanel, 3);
        builder.appendRow(builder.getLineGapSpec());
        builder.appendRow("pref");
        builder.nextLine(2);
        builder.nextColumn(2);
        builder.append((Component)this.englishButton);
        builder.append("English descriptions");
        builder.nextLine();
        builder.appendSeparator("Status");
        builder.appendRow(builder.getLineGapSpec());
        builder.appendRow("pref");
        builder.nextLine(2);
        this.statusLabel = new JLabel("");
        builder.add((Component)this.statusLabel, cc.xy(5, builder.getRow()));
        builder.add((Component)this.progressBar, cc.xyw(7, builder.getRow(), 5));
        this.setLayout(new BorderLayout());
        this.add(builder.getPanel());
        this.setPreferredSize(new Dimension(800, 600));
        try {
            this.restoreSettingsFromProject();
        }
        catch (ArchitectException e1) {
            logger.warn((Object)"Failed to save user CompareDM preferences!");
        }
    }

    public SourceOrTargetStuff getSourceStuff() {
        return this.source;
    }

    public void copySettingsToProject() {
        CompareDMSettings s = this.project.getCompareDMSettings();
        s.setSaveFlag(true);
        s.setOutputFormat(this.englishButton.isSelected() ? CompareDMSettings.OutputFormat.ENGLISH : CompareDMSettings.OutputFormat.SQL);
        s.setSqlScriptFormat(((ASUtils.LabelValueBean)this.sqlTypeDropdown.getSelectedItem()).getLabel());
        CompareDMSettings.SourceOrTargetSettings sourceSetting = s.getSourceSettings();
        this.copySourceOrTargetSettingsToProject(sourceSetting, this.source);
        CompareDMSettings.SourceOrTargetSettings targetSetting = s.getTargetSettings();
        this.copySourceOrTargetSettingsToProject(targetSetting, this.target);
    }

    public void copySourceOrTargetSettingsToProject(CompareDMSettings.SourceOrTargetSettings setting, SourceOrTargetStuff stuff) {
        if (stuff.databaseDropdown.getItemCount() > 0 && stuff.databaseDropdown.getSelectedIndex() >= 0 && stuff.databaseDropdown.getSelectedItem() != null) {
            setting.setConnectName(((ArchitectDataSource)stuff.databaseDropdown.getSelectedItem()).getName());
        } else {
            setting.setConnectName(null);
        }
        if (stuff.catalogDropdown.getItemCount() > 0 && stuff.catalogDropdown.getSelectedIndex() >= 0 && stuff.catalogDropdown.getSelectedItem() != null) {
            setting.setCatalog(((SQLObject)stuff.catalogDropdown.getSelectedItem()).getName());
        } else {
            setting.setCatalog(null);
        }
        if (stuff.schemaDropdown.getItemCount() > 0 && stuff.schemaDropdown.getSelectedIndex() >= 0 && stuff.schemaDropdown.getSelectedItem() != null) {
            setting.setSchema(((SQLObject)stuff.schemaDropdown.getSelectedItem()).getName());
        } else {
            setting.setSchema(null);
        }
        setting.setFilePath(stuff.loadFilePath.getText());
        if (stuff.loadRadio.isSelected()) {
            setting.setDatastoreType(CompareDMSettings.DatastoreType.FILE);
        }
        if (stuff.physicalRadio.isSelected()) {
            setting.setDatastoreType(CompareDMSettings.DatastoreType.DATABASE);
        }
        if (stuff.playPenRadio.isSelected()) {
            setting.setDatastoreType(CompareDMSettings.DatastoreType.PROJECT);
        }
    }

    private void restoreSettingsFromProject() throws ArchitectException {
        CompareDMSettings s = this.project.getCompareDMSettings();
        this.restoreSourceOrTargetSettingsFromProject(this.source, s.getSourceSettings());
        this.restoreSourceOrTargetSettingsFromProject(this.target, s.getTargetSettings());
        if (s.getOutputFormat() == CompareDMSettings.OutputFormat.ENGLISH) {
            this.englishButton.doClick();
        }
        if (s.getOutputFormat() == CompareDMSettings.OutputFormat.SQL) {
            this.sqlButton.doClick();
        }
        if (s.getSqlScriptFormat() != null && s.getSqlScriptFormat().length() > 0) {
            for (int i = 0; i < this.sqlTypeDropdown.getItemCount(); ++i) {
                ASUtils.LabelValueBean lvb = (ASUtils.LabelValueBean)this.sqlTypeDropdown.getItemAt(i);
                if (!lvb.getLabel().equals(s.getSqlScriptFormat())) continue;
                this.sqlTypeDropdown.setSelectedItem(lvb);
                break;
            }
        }
    }

    private void restoreSourceOrTargetSettingsFromProject(SourceOrTargetStuff stuff, CompareDMSettings.SourceOrTargetSettings set) throws ArchitectException {
        CompareDMSettings.DatastoreType rbs = set.getDatastoreType();
        if (rbs == CompareDMSettings.DatastoreType.PROJECT) {
            stuff.playPenRadio.doClick();
        } else if (rbs == CompareDMSettings.DatastoreType.DATABASE) {
            stuff.physicalRadio.doClick();
        } else if (rbs == CompareDMSettings.DatastoreType.FILE) {
            stuff.loadRadio.doClick();
        }
        List<ArchitectDataSource> lds = ArchitectFrame.getMainInstance().getUserSettings().getConnections();
        block0: for (ArchitectDataSource ds : lds) {
            if (!ds.getDisplayName().equals(set.getConnectName())) continue;
            stuff.databaseDropdown.setSelectedItem(ds);
            if (set.getCatalog() != null) {
                stuff.catalogDropdown.getModel().addListDataListener(new RestoreSettingsListener(stuff.catalogDropdown, set.getCatalog()));
            }
            if (set.getSchema() != null) {
                stuff.schemaDropdown.getModel().addListDataListener(new RestoreSettingsListener(stuff.schemaDropdown, set.getSchema()));
            }
            if (stuff.catalogDropdown.getItemCount() != 0 || stuff.schemaDropdown.getItemCount() <= 0 || set.getSchema() == null || set.getSchema().length() <= 0) break;
            for (int j = 0; j < stuff.schemaDropdown.getItemCount(); ++j) {
                SQLObject o2 = (SQLObject)stuff.schemaDropdown.getItemAt(j);
                if (!o2.getName().equals(set.getSchema())) continue;
                stuff.schemaDropdown.setSelectedIndex(j);
                break block0;
            }
        }
        if (set.getFilePath() != null) {
            stuff.loadFilePath.setText(set.getFilePath());
        }
    }

    public SourceOrTargetStuff getTargetStuff() {
        return this.target;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StartCompareAction
    extends AbstractAction {
        private Collection<SQLTable> sourceTables;
        private Collection<SQLTable> targetTables;

        public StartCompareAction() {
            super("Start");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CompareSQL targetComp;
            CompareSQL sourceComp;
            SQLObject left;
            CompareDMPanel.this.startCompareAction.setEnabled(false);
            CompareDMPanel.this.copySettingsToProject();
            try {
                left = CompareDMPanel.this.source.getObjectToCompare();
                this.sourceTables = left.getChildType() == SQLTable.class ? left.getChildren() : new ArrayList<SQLTable>();
                SQLObject right = CompareDMPanel.this.target.getObjectToCompare();
                this.targetTables = right.getChildType() == SQLTable.class ? right.getChildren() : new ArrayList<SQLTable>();
                sourceComp = new CompareSQL(this.sourceTables, this.targetTables);
                targetComp = new CompareSQL(this.targetTables, this.sourceTables);
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(ArchitectFrame.getMainInstance(), "File not found: " + ex.getMessage());
                logger.error((Object)"File could not be found.", (Throwable)ex);
                return;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(ArchitectFrame.getMainInstance(), "Could not read file: " + ex.getMessage());
                logger.error((Object)"Could not read file", (Throwable)ex);
                return;
            }
            catch (ArchitectException ex) {
                ASUtils.showExceptionDialog(CompareDMPanel.this, "Could not begin diff process", ex, new ArchitectExceptionReportFactory());
                return;
            }
            ArchitectSwingWorker compareWorker = new ArchitectSwingWorker(){
                private List<DiffChunk<SQLObject>> diff;
                private List<DiffChunk<SQLObject>> diff1;

                public void doStuff() throws ArchitectException {
                    this.diff = sourceComp.generateTableDiffs();
                    this.diff1 = targetComp.generateTableDiffs();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cleanup() {
                    if (this.getDoStuffException() != null) {
                        Exception exc = this.getDoStuffException();
                        logger.error((Object)"Error in doStuff()", (Throwable)exc);
                        ASUtils.showExceptionDialog(CompareDMPanel.this, "Database Comparison Failed!", exc, new ArchitectExceptionReportFactory());
                        return;
                    }
                    logger.debug((Object)"cleanup starts");
                    try {
                        DefaultStyledDocument sourceDoc = new DefaultStyledDocument();
                        DefaultStyledDocument targetDoc = new DefaultStyledDocument();
                        DDLGenerator gen = (DDLGenerator)((Class)((ASUtils.LabelValueBean)CompareDMPanel.this.sqlTypeDropdown.getSelectedItem()).getValue()).newInstance();
                        if (CompareDMPanel.this.source.physicalRadio.isSelected()) {
                            SQLCatalog cat = (SQLCatalog)CompareDMPanel.this.source.catalogDropdown.getSelectedItem();
                            SQLSchema sch = (SQLSchema)CompareDMPanel.this.source.schemaDropdown.getSelectedItem();
                            gen.setTargetCatalog(cat == null ? null : cat.getPhysicalName());
                            gen.setTargetSchema(sch == null ? null : sch.getPhysicalName());
                        }
                        HashMap<DiffType, SimpleAttributeSet> styles = new HashMap<DiffType, SimpleAttributeSet>();
                        SimpleAttributeSet att = new SimpleAttributeSet();
                        StyleConstants.setForeground(att, Color.red);
                        styles.put(DiffType.LEFTONLY, att);
                        att = new SimpleAttributeSet();
                        StyleConstants.setForeground(att, Color.green.darker().darker());
                        styles.put(DiffType.RIGHTONLY, att);
                        att = new SimpleAttributeSet();
                        StyleConstants.setForeground(att, Color.black);
                        styles.put(DiffType.SAME, att);
                        att = new SimpleAttributeSet();
                        StyleConstants.setForeground(att, Color.orange);
                        styles.put(DiffType.MODIFIED, att);
                        att = new SimpleAttributeSet();
                        StyleConstants.setForeground(att, Color.blue);
                        styles.put(DiffType.KEY_CHANGED, att);
                        if (CompareDMPanel.this.sqlButton.isSelected()) {
                            ArrayList<DiffChunk<SQLObject>> addRelationships = new ArrayList<DiffChunk<SQLObject>>();
                            ArrayList<DiffChunk<SQLObject>> dropRelationships = new ArrayList<DiffChunk<SQLObject>>();
                            ArrayList<DiffChunk<SQLObject>> nonRelationship = new ArrayList<DiffChunk<SQLObject>>();
                            for (DiffChunk<SQLObject> d : this.diff) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug(d);
                                }
                                if (d.getData() instanceof SQLRelationship) {
                                    if (d.getType() == DiffType.LEFTONLY) {
                                        dropRelationships.add(d);
                                        continue;
                                    }
                                    if (d.getType() != DiffType.RIGHTONLY) continue;
                                    addRelationships.add(d);
                                    continue;
                                }
                                nonRelationship.add(d);
                            }
                            StartCompareAction.this.sqlScriptGenerator(styles, dropRelationships, gen);
                            StartCompareAction.this.sqlScriptGenerator(styles, nonRelationship, gen);
                            StartCompareAction.this.sqlScriptGenerator(styles, addRelationships, gen);
                        } else if (CompareDMPanel.this.englishButton.isSelected()) {
                            StartCompareAction.this.generateEnglishDescription(styles, this.diff, sourceDoc);
                            StartCompareAction.this.generateEnglishDescription(styles, this.diff1, targetDoc);
                        } else {
                            throw new IllegalStateException("Don't know what type of output to make");
                        }
                        if (CompareDMPanel.this.sqlButton.isSelected()) {
                            String titleString = "Generated SQL Script to turn " + this.toTitleText(CompareDMPanel.this.source, true) + " into " + this.toTitleText(CompareDMPanel.this.target, false);
                            SQLDatabase db = null;
                            db = CompareDMPanel.this.source.loadRadio.isSelected() ? null : (CompareDMPanel.this.source.playPenRadio.isSelected() ? ArchitectFrame.getMainInstance().playpen.getDatabase() : CompareDMPanel.this.source.getDatabase());
                            SQLScriptDialog ssd = new SQLScriptDialog(ArchitectFrame.getMainInstance(), "Compare DM", titleString, false, gen, db == null ? null : db.getDataSource(), false);
                            ssd.setVisible(true);
                        } else {
                            String leftTitle = this.toTitleText(CompareDMPanel.this.source, true);
                            String rightTitle = this.toTitleText(CompareDMPanel.this.target, false);
                            CompareDMFrame cf = new CompareDMFrame(sourceDoc, targetDoc, leftTitle, rightTitle);
                            cf.pack();
                            cf.setVisible(true);
                        }
                    }
                    catch (ArchitectDiffException ex) {
                        JOptionPane.showMessageDialog(CompareDMPanel.this, "Could not perform the diff:\n" + ex.getMessage(), "Diff Error", 0);
                        logger.error((Object)"Couldn't do diff", (Throwable)ex);
                    }
                    catch (ArchitectException exp) {
                        ASUtils.showExceptionDialog("StartCompareAction failed", exp);
                        logger.error((Object)"StartCompareAction failed", (Throwable)exp);
                    }
                    catch (BadLocationException ex) {
                        ASUtils.showExceptionDialog("Could not create document for results", ex);
                        logger.error((Object)"Could not create document for results", (Throwable)ex);
                    }
                    catch (Exception ex) {
                        ASUtils.showExceptionDialog("Unxepected Exception!", ex);
                        logger.error((Object)"Unxepected Exception!", (Throwable)ex);
                    }
                    finally {
                        CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
                    }
                    logger.debug((Object)"cleanup finished");
                }

                private String toTitleText(SourceOrTargetStuff stuff, boolean isSource) {
                    StringBuffer fileName = new StringBuffer();
                    if (stuff.loadRadio.isSelected()) {
                        File f = new File(stuff.loadFilePath.getText());
                        String tempName = f.getName();
                        fileName.append(tempName.substring(0, tempName.lastIndexOf(".architect")));
                    } else if (stuff.playPenRadio.isSelected()) {
                        try {
                            String tempName = ArchitectFrame.getMainInstance().project.getFile().getName();
                            int lastIndex = tempName.lastIndexOf(".architect");
                            fileName.append(tempName.substring(0, lastIndex));
                        }
                        catch (NullPointerException e) {
                            fileName.append("New Project");
                        }
                    }
                    if (isSource) {
                        fileName.append(" (" + left.getName() + ")");
                    } else {
                        fileName.append(" (" + left.getName() + ")");
                    }
                    return fileName.toString();
                }
            };
            new Thread(compareWorker).start();
            new ProgressWatcher(CompareDMPanel.this.progressBar, (Monitorable)sourceComp);
        }

        private void generateEnglishDescription(Map<DiffType, AttributeSet> styles, List<DiffChunk<SQLObject>> diff, DefaultStyledDocument sourceDoc) throws BadLocationException, ArchitectException {
            for (DiffChunk<SQLObject> chunk : diff) {
                String diffTypeEnglish;
                AttributeSet attributes = styles.get((Object)chunk.getType());
                SimpleAttributeSet boldAttributes = new SimpleAttributeSet(attributes);
                StyleConstants.setBold(boldAttributes, true);
                SQLObject o = chunk.getData();
                if (o == null) {
                    sourceDoc.insertString(sourceDoc.getLength(), "ERROR: null object in diff list\n", attributes);
                } else if (o instanceof SQLTable) {
                    sourceDoc.insertString(sourceDoc.getLength(), "Table ", attributes);
                    sourceDoc.insertString(sourceDoc.getLength(), o.getName() + " ", boldAttributes);
                } else if (o instanceof SQLColumn) {
                    sourceDoc.insertString(sourceDoc.getLength(), "\tColumn ", attributes);
                    sourceDoc.insertString(sourceDoc.getLength(), o.getName() + " ", boldAttributes);
                } else if (o instanceof SQLRelationship) {
                    sourceDoc.insertString(sourceDoc.getLength(), "Foreign Key ", attributes);
                    sourceDoc.insertString(sourceDoc.getLength(), o.getName() + " ", boldAttributes);
                } else {
                    sourceDoc.insertString(sourceDoc.getLength(), "Unknown object type ", attributes);
                    sourceDoc.insertString(sourceDoc.getLength(), o.getClass().getName() + " ", boldAttributes);
                }
                switch (chunk.getType()) {
                    case LEFTONLY: {
                        diffTypeEnglish = "should be removed";
                        break;
                    }
                    case MODIFIED: {
                        diffTypeEnglish = "should be modified";
                        break;
                    }
                    case SAME: {
                        diffTypeEnglish = "needs no changes";
                        break;
                    }
                    case RIGHTONLY: {
                        diffTypeEnglish = "should be added";
                        break;
                    }
                    case KEY_CHANGED: {
                        diffTypeEnglish = "needs a different primary key";
                        break;
                    }
                    default: {
                        diffTypeEnglish = "!UNKNOWN DIFF TYPE!";
                        logger.error((Object)("Woops, unknown diff chunk type: " + (Object)((Object)chunk.getType())));
                    }
                }
                sourceDoc.insertString(sourceDoc.getLength(), diffTypeEnglish + "\n", attributes);
            }
        }

        private void sqlScriptGenerator(Map<DiffType, AttributeSet> styles, List<DiffChunk<SQLObject>> diff, DDLGenerator gen) throws ArchitectDiffException, SQLException, ArchitectException, BadLocationException, InstantiationException, IllegalAccessException {
            for (DiffChunk<SQLObject> chunk : diff) {
                SQLRelationship r;
                SQLColumn c;
                SQLTable t;
                if (chunk.getType() == DiffType.KEY_CHANGED) {
                    if (!(chunk.getData() instanceof SQLTable)) continue;
                    t = (SQLTable)chunk.getData();
                    if (this.hasKey(t)) {
                        gen.addPrimaryKey(t);
                        continue;
                    }
                    gen.dropPrimaryKey(t);
                    continue;
                }
                if (chunk.getType() == DiffType.LEFTONLY) {
                    if (chunk.getData() instanceof SQLTable) {
                        t = (SQLTable)chunk.getData();
                        gen.dropTable(t);
                        continue;
                    }
                    if (chunk.getData() instanceof SQLColumn) {
                        c = (SQLColumn)chunk.getData();
                        gen.dropColumn(c);
                        continue;
                    }
                    if (chunk.getData() instanceof SQLRelationship) {
                        r = (SQLRelationship)chunk.getData();
                        gen.dropRelationship(r);
                        continue;
                    }
                    throw new IllegalStateException("DiffChunk is an unexpected type.");
                }
                if (chunk.getType() == DiffType.RIGHTONLY) {
                    if (chunk.getData() instanceof SQLTable) {
                        t = (SQLTable)chunk.getData();
                        if (t == null) {
                            throw new NullPointerException();
                        }
                        if (t.getObjectType().equals("TABLE")) {
                            gen.addTable(t);
                        }
                        if (!this.hasKey(t)) continue;
                        gen.addPrimaryKey(t);
                        continue;
                    }
                    if (chunk.getData() instanceof SQLColumn) {
                        c = (SQLColumn)chunk.getData();
                        gen.addColumn(c);
                        continue;
                    }
                    if (chunk.getData() instanceof SQLRelationship) {
                        r = (SQLRelationship)chunk.getData();
                        gen.addRelationship(r);
                        continue;
                    }
                    throw new IllegalStateException("DiffChunk is an unexpected type.");
                }
                if (chunk.getType() != DiffType.MODIFIED) continue;
                if (chunk.getData() instanceof SQLColumn) {
                    c = (SQLColumn)chunk.getData();
                    gen.modifyColumn(c);
                    continue;
                }
                throw new IllegalStateException("DiffChunk is an unexpected type.");
            }
        }

        private boolean hasKey(SQLTable t) throws ArchitectException {
            boolean hasKey = false;
            for (SQLColumn c : t.getColumns()) {
                if (!c.isPrimaryKey()) continue;
                hasKey = true;
                break;
            }
            return hasKey;
        }
    }

    public class OutputChoiceListener
    implements ActionListener {
        JComboBox cb;

        public OutputChoiceListener(JComboBox cb) {
            this.cb = cb;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(CompareDMPanel.OUTPUT_SQL)) {
                this.cb.setEnabled(true);
            } else {
                this.cb.setEnabled(false);
            }
            CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
        }
    }

    class SourceOrTargetStuff
    implements DBConnectionCallBack {
        private JComboBox databaseDropdown;
        private JComboBox catalogDropdown;
        private JComboBox schemaDropdown;
        private JButton newConnButton;
        private JButton loadFileButton;
        private JTextField loadFilePath;
        private ButtonGroup buttonGroup = new ButtonGroup();
        private JRadioButton playPenRadio;
        private JRadioButton physicalRadio;
        private JRadioButton loadRadio;
        private JDialog newConnectionDialog;
        private JLabel catalogLabel;
        private JLabel schemaLabel;
        private SQLDatabase cachedDatabase;
        private Action newConnectionAction = new AbstractAction("New..."){

            public void actionPerformed(ActionEvent e) {
                if (SourceOrTargetStuff.this.getNewConnectionDialog() != null) {
                    SourceOrTargetStuff.this.getNewConnectionDialog().requestFocus();
                    return;
                }
                final DBCSPanel dbcsPanel = new DBCSPanel(CompareDMPanel.this.session.getUserSettings().getPlDotIni());
                dbcsPanel.setDbcs(new ArchitectDataSource());
                DBCSOkAction okAction = new DBCSOkAction(dbcsPanel, true);
                okAction.setConnectionSelectionCallBack(SourceOrTargetStuff.this);
                AbstractAction cancelAction = new AbstractAction(){

                    public void actionPerformed(ActionEvent e) {
                        dbcsPanel.discardChanges();
                        SourceOrTargetStuff.this.setNewConnectionDialog(null);
                    }
                };
                JDialog d = ArchitectPanelBuilder.createArchitectPanelDialog(dbcsPanel, SwingUtilities.getWindowAncestor(CompareDMPanel.this), CompareDMPanel.DBCS_DIALOG_TITLE, "OK", okAction, cancelAction);
                okAction.setConnectionDialog(d);
                SourceOrTargetStuff.this.setNewConnectionDialog(d);
                d.setVisible(true);
            }
        };
        private Action chooseFileAction = new AbstractAction("Choose..."){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.addChoosableFileFilter(ASUtils.ARCHITECT_FILE_FILTER);
                int returnVal = chooser.showOpenDialog(CompareDMPanel.this);
                if (returnVal == 0) {
                    File file = chooser.getSelectedFile();
                    SourceOrTargetStuff.this.loadFilePath.setText(file.getPath());
                }
            }
        };

        SourceOrTargetStuff() {
        }

        public synchronized JDialog getNewConnectionDialog() {
            return this.newConnectionDialog;
        }

        private synchronized void setNewConnectionDialog(JDialog d) {
            this.newConnectionDialog = d;
        }

        private void buildPartialUI(DefaultFormBuilder builder, boolean defaultPlayPen) {
            String prefix = defaultPlayPen ? "source" : "target";
            CellConstraints cc = new CellConstraints();
            ArchitectFrame af = ArchitectFrame.getMainInstance();
            SwingUIProject project = af.getProject();
            this.playPenRadio = new JRadioButton();
            this.playPenRadio.setName(prefix + "PlayPenRadio");
            this.physicalRadio = new JRadioButton();
            this.physicalRadio.setName(prefix + "PhysicalRadio");
            this.loadRadio = new JRadioButton();
            this.loadRadio.setName(prefix + "LoadRadio");
            this.buttonGroup.add(this.playPenRadio);
            this.buttonGroup.add(this.physicalRadio);
            this.buttonGroup.add(this.loadRadio);
            this.schemaDropdown = new JComboBox();
            this.schemaDropdown.setEnabled(false);
            this.schemaDropdown.setName(prefix + "SchemaDropdown");
            this.catalogDropdown = new JComboBox();
            this.catalogDropdown.setEnabled(false);
            this.catalogDropdown.setName(prefix + "CatalogDropdown");
            this.databaseDropdown = new JComboBox();
            this.databaseDropdown.setName(prefix + "DatabaseDropdown");
            this.databaseDropdown.setModel(new ConnectionComboBoxModel());
            this.databaseDropdown.setEnabled(false);
            this.databaseDropdown.setRenderer(CompareDMPanel.this.dataSourceRenderer);
            this.newConnButton = new JButton();
            this.newConnButton.setName(prefix + "NewConnButton");
            this.newConnButton.setAction(this.newConnectionAction);
            this.newConnectionAction.setEnabled(false);
            this.loadFilePath = new JTextField();
            this.loadFilePath.setName(prefix + "LoadFilePath");
            this.loadFilePath.setEnabled(false);
            this.loadFilePath.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
                }

                public void removeUpdate(DocumentEvent e) {
                    CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
                }

                public void changedUpdate(DocumentEvent e) {
                    CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
                }
            });
            this.loadFileButton = new JButton();
            this.loadFileButton.setName(prefix + "LoadFileButton");
            this.loadFileButton.setAction(this.chooseFileAction);
            this.chooseFileAction.setEnabled(false);
            this.catalogDropdown.addActionListener(new SchemaPopulator());
            this.databaseDropdown.addActionListener(new CatalogPopulator());
            OptionGroupListener listener = new OptionGroupListener();
            this.playPenRadio.addActionListener(listener);
            this.physicalRadio.addActionListener(listener);
            this.loadRadio.addActionListener(listener);
            if (defaultPlayPen) {
                this.playPenRadio.doClick();
            } else {
                this.physicalRadio.doClick();
            }
            builder.append((Component)this.playPenRadio);
            builder.append("Current Project [" + project.getName() + "]");
            builder.nextLine();
            builder.append("");
            builder.append((Component)this.physicalRadio);
            builder.append("Physical Database");
            this.catalogLabel = new JLabel("Catalog");
            builder.append((Component)this.catalogLabel);
            this.schemaLabel = new JLabel("Schema");
            builder.append((Component)this.schemaLabel);
            builder.appendRow(builder.getLineGapSpec());
            builder.appendRow("pref");
            builder.nextLine(2);
            builder.nextColumn(4);
            builder.append((Component)this.databaseDropdown);
            builder.append((Component)this.catalogDropdown, (Component)this.schemaDropdown, (Component)this.newConnButton);
            builder.nextLine();
            builder.append("");
            builder.append((Component)this.loadRadio);
            builder.append("From File:");
            builder.nextLine();
            builder.append("");
            builder.add((Component)this.loadFilePath, cc.xyw(5, builder.getRow(), 5));
            builder.nextColumn(8);
            builder.append((Component)this.loadFileButton);
            builder.nextLine();
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public SQLObject getObjectToCompare() throws ArchitectException, IOException {
            void var1_6;
            if (this.playPenRadio.isSelected()) {
                SQLDatabase sQLDatabase = ArchitectFrame.getMainInstance().playpen.getDatabase();
                return var1_6;
            } else if (this.physicalRadio.isSelected()) {
                if (this.schemaDropdown.getSelectedItem() != null) {
                    SQLObject sQLObject = (SQLObject)this.schemaDropdown.getSelectedItem();
                    return var1_6;
                } else if (this.catalogDropdown.getSelectedItem() != null) {
                    SQLObject sQLObject = (SQLObject)this.catalogDropdown.getSelectedItem();
                    return var1_6;
                } else {
                    if (this.databaseDropdown.getSelectedItem() == null) throw new IllegalStateException("You elected to compare a physical database, but have not selected a schema, catalog, or database to compare.");
                    SQLDatabase sQLDatabase = this.getDatabase();
                }
                return var1_6;
            } else {
                if (!this.loadRadio.isSelected()) throw new IllegalStateException("Do not know which source to compare from");
                SwingUIProject project = new SwingUIProject("Source");
                File f = new File(this.loadFilePath.getText());
                project.load(new BufferedInputStream(new FileInputStream(f)));
                SQLDatabase sQLDatabase = project.getTargetDatabase();
            }
            return var1_6;
        }

        private boolean isThisPartStartable() {
            if (this.playPenRadio.isSelected()) {
                return true;
            }
            if (this.physicalRadio.isSelected()) {
                return this.databaseDropdown.getSelectedItem() != null;
            }
            if (this.loadRadio.isSelected()) {
                return new File(this.loadFilePath.getText()).canRead();
            }
            throw new IllegalStateException("None of the radio buttons are selected!");
        }

        public synchronized SQLDatabase getDatabase() {
            ArchitectDataSource ds = (ArchitectDataSource)this.databaseDropdown.getSelectedItem();
            if (ds == null) {
                this.cachedDatabase = null;
            } else if (this.cachedDatabase == null || !this.cachedDatabase.getDataSource().equals(ds)) {
                this.cachedDatabase = new SQLDatabase(ds);
            }
            return this.cachedDatabase;
        }

        void enableDisablePhysicalComps() {
            boolean enable = this.physicalRadio.isSelected();
            this.databaseDropdown.setEnabled(enable);
            if (enable && this.catalogDropdown.getItemCount() > 0) {
                this.catalogDropdown.setEnabled(true);
            } else {
                this.catalogDropdown.setEnabled(false);
            }
            if (enable && this.schemaDropdown.getItemCount() > 0) {
                this.schemaDropdown.setEnabled(true);
            } else {
                this.schemaDropdown.setEnabled(false);
            }
            this.newConnectionAction.setEnabled(enable);
        }

        public void selectDBConnection(ArchitectDataSource ds) {
            this.databaseDropdown.setSelectedItem(ds);
        }

        public class OptionGroupListener
        implements ActionListener {
            public void actionPerformed(ActionEvent e) {
                SourceOrTargetStuff.this.enableDisablePhysicalComps();
                boolean enableLoadComps = e.getSource() == SourceOrTargetStuff.this.loadRadio;
                SourceOrTargetStuff.this.loadFilePath.setEnabled(enableLoadComps);
                SourceOrTargetStuff.this.loadFileButton.setEnabled(enableLoadComps);
            }
        }

        public class SchemaPopulator
        extends Populator
        implements ActionListener {
            public void actionPerformed(ActionEvent e) {
                logger.debug((Object)"SCHEMA POPULATOR IS ABOUT TO START...");
                SourceOrTargetStuff.this.schemaDropdown.removeAllItems();
                SourceOrTargetStuff.this.schemaDropdown.setEnabled(false);
                SQLCatalog catToPopulate = (SQLCatalog)SourceOrTargetStuff.this.catalogDropdown.getSelectedItem();
                if (catToPopulate != null) {
                    CompareDMPanel.this.startCompareAction.setEnabled(false);
                    Thread t = new Thread(this);
                    t.start();
                }
            }

            public void doStuff() throws ArchitectException {
                logger.debug((Object)"SCHEMA POPULATOR IS STARTED...");
                ListerProgressBarUpdater progressBarUpdater = new ListerProgressBarUpdater(CompareDMPanel.this.progressBar, this);
                new Timer(100, progressBarUpdater).start();
                SQLCatalog catToPopulate = (SQLCatalog)SourceOrTargetStuff.this.catalogDropdown.getSelectedItem();
                catToPopulate.getChildren();
            }

            public void cleanup() throws ArchitectException {
                logger.debug((Object)"SCHEMA POPULATOR IS ABOUT TO CLEAN UP...");
                SourceOrTargetStuff.this.schemaLabel.setText("");
                SQLCatalog populatedCat = (SQLCatalog)SourceOrTargetStuff.this.catalogDropdown.getSelectedItem();
                if (populatedCat.isSchemaContainer()) {
                    for (SQLObject item : populatedCat.getChildren()) {
                        SourceOrTargetStuff.this.schemaDropdown.addItem(item);
                    }
                    if (SourceOrTargetStuff.this.schemaDropdown.getItemCount() > 0) {
                        SourceOrTargetStuff.this.schemaDropdown.setEnabled(true);
                        if (((SQLSchema)populatedCat.getChild(0)).getNativeTerm() != null) {
                            SourceOrTargetStuff.this.schemaLabel.setText(((SQLSchema)populatedCat.getChild(0)).getNativeTerm());
                        }
                    }
                }
                CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
            }
        }

        public class CatalogPopulator
        extends Populator
        implements ActionListener {
            private SQLDatabase db;

            public void actionPerformed(ActionEvent e) {
                CompareDMPanel.this.startCompareAction.setEnabled(false);
                this.db = SourceOrTargetStuff.this.getDatabase();
                if (this.db != null) {
                    try {
                        this.progressMonitor = this.db.getProgressMonitor();
                    }
                    catch (ArchitectException e1) {
                        logger.debug((Object)"Error getting progressMonitor", (Throwable)e1);
                    }
                    if (((JComboBox)e.getSource()).getSelectedIndex() == 0) {
                        CompareDMPanel.this.startCompareAction.setEnabled(false);
                    }
                    new Thread(this).start();
                } else {
                    SourceOrTargetStuff.this.catalogDropdown.removeAllItems();
                    SourceOrTargetStuff.this.catalogDropdown.setEnabled(false);
                    SourceOrTargetStuff.this.schemaDropdown.removeAllItems();
                    SourceOrTargetStuff.this.schemaDropdown.setEnabled(false);
                }
            }

            public void doStuff() throws Exception {
                try {
                    ListerProgressBarUpdater progressBarUpdater = new ListerProgressBarUpdater(CompareDMPanel.this.progressBar, this);
                    new Timer(100, progressBarUpdater).start();
                    this.db.populate();
                }
                catch (ArchitectException e) {
                    logger.debug((Object)"Unexpected architect exception in ConnectionListener", (Throwable)e);
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(CompareDMPanel.this), "Unexpected architect exception in ConnectionListener\n" + e, "Error", 0);
                }
            }

            public void cleanup() throws ArchitectException {
                SQLDatabase schemaParent;
                this.setCleanupExceptionMessage("Could not populate catalog dropdown!");
                SourceOrTargetStuff.this.catalogDropdown.removeAllItems();
                SourceOrTargetStuff.this.catalogDropdown.setEnabled(false);
                SourceOrTargetStuff.this.catalogLabel.setText("");
                SourceOrTargetStuff.this.schemaLabel.setText("");
                if (this.db.isCatalogContainer()) {
                    for (SQLObject item : this.db.getChildren()) {
                        SourceOrTargetStuff.this.catalogDropdown.addItem(item);
                    }
                    SQLCatalog cat = (SQLCatalog)SourceOrTargetStuff.this.catalogDropdown.getSelectedItem();
                    if (cat != null && cat.getNativeTerm() != null) {
                        SourceOrTargetStuff.this.catalogLabel.setText(cat.getNativeTerm());
                    }
                    schemaParent = null;
                    if (cat == null) {
                        SourceOrTargetStuff.this.catalogDropdown.setEnabled(false);
                    } else {
                        SourceOrTargetStuff.this.catalogDropdown.setEnabled(true);
                    }
                } else if (this.db.isSchemaContainer()) {
                    schemaParent = this.db;
                    SourceOrTargetStuff.this.catalogDropdown.setEnabled(false);
                } else {
                    schemaParent = null;
                    SourceOrTargetStuff.this.catalogDropdown.setEnabled(false);
                }
                SourceOrTargetStuff.this.schemaDropdown.removeAllItems();
                SourceOrTargetStuff.this.schemaDropdown.setEnabled(false);
                if (schemaParent == null) {
                    CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
                } else {
                    final SQLDatabase finalSchemaParent = schemaParent;
                    new Thread(new Populator(){

                        public void doStuff() throws Exception {
                            ListerProgressBarUpdater progressBarUpdater = new ListerProgressBarUpdater(CompareDMPanel.this.progressBar, this);
                            new Timer(100, progressBarUpdater).start();
                            finalSchemaParent.getChildren();
                        }

                        public void cleanup() throws ArchitectException {
                            this.setCleanupExceptionMessage("Could not populate schema dropdown!");
                            for (SQLObject item : finalSchemaParent.getChildren()) {
                                SourceOrTargetStuff.this.schemaDropdown.addItem(item);
                            }
                            if (SourceOrTargetStuff.this.schemaDropdown.getItemCount() > 0) {
                                SourceOrTargetStuff.this.schemaDropdown.setEnabled(true);
                                if (((SQLSchema)finalSchemaParent.getChild(0)).getNativeTerm() != null) {
                                    SourceOrTargetStuff.this.schemaLabel.setText(((SQLSchema)finalSchemaParent.getChild(0)).getNativeTerm());
                                }
                            }
                            CompareDMPanel.this.startCompareAction.setEnabled(CompareDMPanel.this.isStartable());
                        }
                    }).start();
                }
            }
        }
    }

    private static class RestoreSettingsListener
    implements ListDataListener {
        private JComboBox box;
        private String selectItemName;

        public RestoreSettingsListener(JComboBox box, String selectItemName) {
            this.box = box;
            this.selectItemName = selectItemName;
        }

        public void intervalAdded(ListDataEvent e) {
            this.tryToSelectTheItem(e.getIndex0(), e.getIndex1());
        }

        public void intervalRemoved(ListDataEvent e) {
        }

        public void contentsChanged(ListDataEvent e) {
            this.tryToSelectTheItem(e.getIndex0(), e.getIndex1());
        }

        private void tryToSelectTheItem(int low, int high) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Looking for '" + this.selectItemName + "' from index " + low + " to " + high));
            }
            for (int i = low; i <= high; ++i) {
                SQLObject o = (SQLObject)this.box.getItemAt(i);
                if (o == null || !o.getName().equals(this.selectItemName)) continue;
                this.box.setSelectedIndex(i);
                this.box.getModel().removeListDataListener(this);
                return;
            }
        }
    }
}

