/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.profile.AbstractProfileResult;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableProfileResult
extends AbstractProfileResult<SQLTable> {
    private static final Logger logger = Logger.getLogger(TableProfileResult.class);
    private int rowCount;
    private List<ColumnProfileResult> columnProfileResults = new ArrayList<ColumnProfileResult>();
    private ProfileManager manager;
    private int progress;
    static final Date date = new Date();
    static final DateFormat df = DateFormat.getDateTimeInstance();
    public static final String TOSTRING_FORMAT = "Rows: %d   %s   Time:  %d ms";

    public TableProfileResult(SQLTable profiledObject, ProfileManager manager) {
        super(profiledObject);
        this.manager = manager;
        this.setSettings(manager.getProfileSettings());
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public String toString() {
        date.setTime(this.getCreateStartTime());
        return String.format(TOSTRING_FORMAT, this.rowCount, df.format(date), this.getTimeToCreate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doProfile() throws SQLException, ArchitectException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            List<SQLColumn> columns;
            SQLTable table = (SQLTable)this.getProfiledObject();
            SQLDatabase db = table.getParentDatabase();
            conn = db.getConnection();
            String databaseIdentifierQuoteString = null;
            databaseIdentifierQuoteString = conn.getMetaData().getIdentifierQuoteString();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT COUNT(*) AS ROW__COUNT");
            sql.append("\nFROM ");
            sql.append(DDLUtils.toQualifiedName(table.getCatalogName(), table.getSchemaName(), table.getName(), databaseIdentifierQuoteString, databaseIdentifierQuoteString));
            stmt = conn.createStatement();
            stmt.setEscapeProcessing(false);
            String lastSQL = sql.toString();
            rs = stmt.executeQuery(lastSQL);
            if (rs.next()) {
                this.rowCount = rs.getInt("ROW__COUNT");
            }
            if ((columns = table.getColumns()).size() == 0) {
                return;
            }
            DDLGenerator ddlg = this.getDDLGenerator();
            for (SQLColumn col : columns) {
                ColumnProfileResult columnResult = new ColumnProfileResult(col, this.manager, ddlg, this);
                columnResult.populate();
                this.columnProfileResults.add(columnResult);
                ++this.progress;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up result set", (Throwable)ex);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't clean up statement", (Throwable)ex);
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    public synchronized Integer getJobSize() {
        return null;
    }

    @Override
    public synchronized int getProgress() {
        return this.progress;
    }

    public List<ColumnProfileResult> getColumnProfileResults() {
        return Collections.unmodifiableList(this.columnProfileResults);
    }

    public Collection<ColumnProfileResult> getColumnProfileResult(SQLColumn c) {
        ArrayList<ColumnProfileResult> retCollection = new ArrayList<ColumnProfileResult>();
        for (ColumnProfileResult result : this.columnProfileResults) {
            if (c != result.getProfiledObject()) continue;
            retCollection.add(result);
        }
        return retCollection;
    }

    public DDLGenerator getDDLGenerator() throws ArchitectException {
        ArchitectDataSource ds = ((SQLTable)this.getProfiledObject()).getParentDatabase().getDataSource();
        try {
            return DDLUtils.createDDLGenerator(ds);
        }
        catch (InstantiationException ex) {
            throw new ArchitectException("Couldn't create DDL Generator for data source " + ds, ex);
        }
        catch (IllegalAccessException ex) {
            throw new ArchitectException("Couldn't create DDL Generator for data source " + ds, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new ArchitectException("Couldn't create DDL Generator for data source " + ds, ex);
        }
    }

    public void addColumnProfileResult(ColumnProfileResult profileResult) {
        this.columnProfileResults.add(profileResult);
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }
}

